/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.util.Collection;
import java.util.Objects;
import org.apache.logging.log4j.util.BiConsumer;
import org.apache.logging.log4j.util.PropertySource;
import org.apache.logging.log4j.util.PropertySource$Util;

public class SystemPropertiesPropertySource
implements PropertySource {
    private static final int DEFAULT_PRIORITY = 0;
    private static final String PREFIX = "log4j2.";

    public static String getSystemProperty(String string, String string2) {
        try {
            return System.getProperty(string, string2);
        }
        catch (SecurityException securityException) {
            return string2;
        }
    }

    @Override
    public int getPriority() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forEach(BiConsumer<String, String> biConsumer) {
        Object[] objectArray;
        try {
            objectArray = System.getProperties();
        }
        catch (SecurityException securityException) {
            return;
        }
        Object[] objectArray2 = objectArray;
        synchronized (objectArray) {
            Object[] objectArray3 = objectArray.keySet().toArray();
            // ** MonitorExit[var4_5] (shouldn't be in output)
            for (Object object : objectArray3) {
                String string = Objects.toString(object, null);
                biConsumer.accept(string, objectArray.getProperty(string));
            }
            return;
        }
    }

    @Override
    public CharSequence getNormalForm(Iterable<? extends CharSequence> iterable) {
        return PREFIX + PropertySource$Util.joinAsCamelCase(iterable);
    }

    @Override
    public Collection<String> getPropertyNames() {
        try {
            return System.getProperties().stringPropertyNames();
        }
        catch (SecurityException securityException) {
            return PropertySource.super.getPropertyNames();
        }
    }

    @Override
    public String getProperty(String string) {
        try {
            return System.getProperty(string);
        }
        catch (SecurityException securityException) {
            return PropertySource.super.getProperty(string);
        }
    }

    @Override
    public boolean containsProperty(String string) {
        return this.getProperty(string) != null;
    }
}

