/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.util.Iterator;
import java.util.Locale;
import java.util.Objects;
import org.apache.logging.log4j.util.SystemPropertiesPropertySource;

public final class Strings {
    private static final ThreadLocal<StringBuilder> tempStr = ThreadLocal.withInitial(StringBuilder::new);
    public static final String EMPTY = "";
    private static final String COMMA_DELIMITED_RE = "\\s*,\\s*";
    public static final String[] EMPTY_ARRAY = new String[0];
    public static final String LINE_SEPARATOR = SystemPropertiesPropertySource.getSystemProperty("line.separator", "\n");

    public static String dquote(String string) {
        return '\"' + string + '\"';
    }

    public static boolean isBlank(String string) {
        if (string == null || string.isEmpty()) {
            return true;
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isWhitespace(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(CharSequence charSequence) {
        return charSequence == null || charSequence.length() == 0;
    }

    public static boolean isNotBlank(String string) {
        return !Strings.isBlank(string);
    }

    public static boolean isNotEmpty(CharSequence charSequence) {
        return !Strings.isEmpty(charSequence);
    }

    public static String join(Iterable<?> iterable, char c) {
        if (iterable == null) {
            return null;
        }
        return Strings.join(iterable.iterator(), c);
    }

    public static String join(Iterator<?> iterator, char c) {
        if (iterator == null) {
            return null;
        }
        if (!iterator.hasNext()) {
            return EMPTY;
        }
        Object obj = iterator.next();
        if (!iterator.hasNext()) {
            return Objects.toString(obj, EMPTY);
        }
        StringBuilder stringBuilder = new StringBuilder(256);
        if (obj != null) {
            stringBuilder.append(obj);
        }
        while (iterator.hasNext()) {
            stringBuilder.append(c);
            Object obj2 = iterator.next();
            if (obj2 == null) continue;
            stringBuilder.append(obj2);
        }
        return stringBuilder.toString();
    }

    public static String[] splitList(String string) {
        return string != null ? string.split(COMMA_DELIMITED_RE) : new String[]{};
    }

    public static String left(String string, int n) {
        if (string == null) {
            return null;
        }
        if (n < 0) {
            return EMPTY;
        }
        if (string.length() <= n) {
            return string;
        }
        return string.substring(0, n);
    }

    public static String quote(String string) {
        return '\'' + string + '\'';
    }

    public static String trimToNull(String string) {
        String string2 = string == null ? null : string.trim();
        return Strings.isEmpty(string2) ? null : string2;
    }

    private Strings() {
    }

    public static String toRootLowerCase(String string) {
        return string.toLowerCase(Locale.ROOT);
    }

    public static String toRootUpperCase(String string) {
        return string.toUpperCase(Locale.ROOT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String concat(String string, String string2) {
        if (Strings.isEmpty(string)) {
            return string2;
        }
        if (Strings.isEmpty(string2)) {
            return string;
        }
        StringBuilder stringBuilder = tempStr.get();
        try {
            String string3 = stringBuilder.append(string).append(string2).toString();
            return string3;
        }
        finally {
            stringBuilder.setLength(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String repeat(String string, int n) {
        Objects.requireNonNull(string, "str");
        if (n < 0) {
            throw new IllegalArgumentException("count");
        }
        StringBuilder stringBuilder = tempStr.get();
        try {
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(string);
            }
            String string2 = stringBuilder.toString();
            return string2;
        }
        finally {
            stringBuilder.setLength(0);
        }
    }
}

