/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.lang.invoke.MethodHandles;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.Spliterator;
import java.util.function.Consumer;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.ServiceLoaderUtil;

class ServiceLoaderUtil$ServiceLoaderSpliterator<S>
implements Spliterator<S> {
    private final Iterator<S> serviceIterator;
    private final Logger logger;
    private final String serviceName;

    public ServiceLoaderUtil$ServiceLoaderSpliterator(Class<S> clazz, MethodHandles.Lookup lookup, ClassLoader classLoader, boolean bl) {
        this.serviceIterator = ServiceLoaderUtil.callServiceLoader(lookup, clazz, classLoader, bl).iterator();
        this.logger = bl ? StatusLogger.getLogger() : null;
        this.serviceName = clazz.toString();
    }

    @Override
    public boolean tryAdvance(Consumer<? super S> consumer) {
        int n = 8;
        while (n-- > 0) {
            try {
                if (!this.serviceIterator.hasNext()) continue;
                consumer.accept(this.serviceIterator.next());
                return true;
            }
            catch (LinkageError | ServiceConfigurationError error) {
                if (this.logger == null) continue;
                this.logger.warn("Unable to load service class for service {}", (Object)this.serviceName, (Object)error);
            }
            catch (Throwable throwable) {
                if (this.logger != null) {
                    this.logger.warn("Unable to load service class for service {}", (Object)this.serviceName, (Object)throwable);
                }
                throw throwable;
            }
        }
        return false;
    }

    @Override
    public Spliterator<S> trySplit() {
        return null;
    }

    @Override
    public long estimateSize() {
        return Long.MAX_VALUE;
    }

    @Override
    public int characteristics() {
        return 1280;
    }
}

