/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.apache.logging.log4j.util.LoaderUtil;
import org.apache.logging.log4j.util.LowLevelLogUtil;
import org.apache.logging.log4j.util.PropertiesPropertySource;

public class PropertyFilePropertySource
extends PropertiesPropertySource {
    public PropertyFilePropertySource(String string) {
        this(string, true);
    }

    public PropertyFilePropertySource(String string, boolean bl) {
        super(PropertyFilePropertySource.loadPropertiesFile(string, bl));
    }

    private static Properties loadPropertiesFile(String string, boolean bl) {
        Properties properties = new Properties();
        for (URL uRL : LoaderUtil.findResources(string, bl)) {
            try {
                InputStream inputStream = uRL.openStream();
                Throwable throwable = null;
                try {
                    properties.load(inputStream);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                LowLevelLogUtil.logException("Unable to read " + uRL, iOException);
            }
        }
        return properties;
    }
}

