/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.util.LowLevelLogUtil;
import org.apache.logging.log4j.util.PropertiesPropertySource;
import org.apache.logging.log4j.util.PropertiesUtil$Environment;
import org.apache.logging.log4j.util.PropertiesUtil$TimeUnit;
import org.apache.logging.log4j.util.PropertyFilePropertySource;
import org.apache.logging.log4j.util.PropertySource;
import org.apache.logging.log4j.util.Supplier;

public final class PropertiesUtil {
    private static final String LOG4J_PROPERTIES_FILE_NAME = "log4j2.component.properties";
    private static final String LOG4J_SYSTEM_PROPERTIES_FILE_NAME = "log4j2.system.properties";
    private static final PropertiesUtil LOG4J_PROPERTIES = new PropertiesUtil("log4j2.component.properties", false);
    private final PropertiesUtil$Environment environment;

    public PropertiesUtil(Properties properties) {
        this(new PropertiesPropertySource(properties));
    }

    public PropertiesUtil(String string) {
        this(string, true);
    }

    private PropertiesUtil(String string, boolean bl) {
        this(new PropertyFilePropertySource(string, bl));
    }

    PropertiesUtil(PropertySource propertySource) {
        this.environment = new PropertiesUtil$Environment(propertySource, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Properties loadClose(InputStream inputStream, Object object) {
        Properties properties = new Properties();
        if (null != inputStream) {
            try {
                properties.load(inputStream);
            }
            catch (IOException iOException) {
                LowLevelLogUtil.logException("Unable to read " + object, iOException);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    LowLevelLogUtil.logException("Unable to close " + object, iOException);
                }
            }
        }
        return properties;
    }

    public static PropertiesUtil getProperties() {
        return LOG4J_PROPERTIES;
    }

    public void addPropertySource(PropertySource propertySource) {
        if (this.environment != null) {
            this.environment.addPropertySource(propertySource);
        }
    }

    public boolean hasProperty(String string) {
        return PropertiesUtil$Environment.access$100(this.environment, string);
    }

    public boolean getBooleanProperty(String string) {
        return this.getBooleanProperty(string, false);
    }

    public boolean getBooleanProperty(String string, boolean bl) {
        String string2 = this.getStringProperty(string);
        return string2 == null ? bl : "true".equalsIgnoreCase(string2);
    }

    public boolean getBooleanProperty(String string, boolean bl, boolean bl2) {
        String string2 = this.getStringProperty(string);
        return string2 == null ? bl : (string2.isEmpty() ? bl2 : "true".equalsIgnoreCase(string2));
    }

    public Boolean getBooleanProperty(String[] stringArray, String string, Supplier<Boolean> supplier) {
        for (String string2 : stringArray) {
            if (!this.hasProperty(string2 + string)) continue;
            return this.getBooleanProperty(string2 + string);
        }
        return supplier != null ? supplier.get() : null;
    }

    public Charset getCharsetProperty(String string) {
        return this.getCharsetProperty(string, Charset.defaultCharset());
    }

    public Charset getCharsetProperty(String string, Charset charset) {
        String string2;
        String string3 = this.getStringProperty(string);
        if (string3 == null) {
            return charset;
        }
        if (Charset.isSupported(string3)) {
            return Charset.forName(string3);
        }
        ResourceBundle resourceBundle = PropertiesUtil.getCharsetsResourceBundle();
        if (resourceBundle.containsKey(string) && Charset.isSupported(string2 = resourceBundle.getString(string))) {
            return Charset.forName(string2);
        }
        LowLevelLogUtil.log("Unable to get Charset '" + string3 + "' for property '" + string + "', using default " + charset + " and continuing.");
        return charset;
    }

    public double getDoubleProperty(String string, double d) {
        String string2 = this.getStringProperty(string);
        if (string2 != null) {
            try {
                return Double.parseDouble(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return d;
    }

    public int getIntegerProperty(String string, int n) {
        String string2 = this.getStringProperty(string);
        if (string2 != null) {
            try {
                return Integer.parseInt(string2.trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n;
    }

    public Integer getIntegerProperty(String[] stringArray, String string, Supplier<Integer> supplier) {
        for (String string2 : stringArray) {
            if (!this.hasProperty(string2 + string)) continue;
            return this.getIntegerProperty(string2 + string, 0);
        }
        return supplier != null ? supplier.get() : null;
    }

    public long getLongProperty(String string, long l) {
        String string2 = this.getStringProperty(string);
        if (string2 != null) {
            try {
                return Long.parseLong(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return l;
    }

    public Long getLongProperty(String[] stringArray, String string, Supplier<Long> supplier) {
        for (String string2 : stringArray) {
            if (!this.hasProperty(string2 + string)) continue;
            return this.getLongProperty(string2 + string, 0L);
        }
        return supplier != null ? supplier.get() : null;
    }

    public Duration getDurationProperty(String string, Duration duration) {
        String string2 = this.getStringProperty(string);
        if (string2 != null) {
            return PropertiesUtil$TimeUnit.getDuration(string2);
        }
        return duration;
    }

    public Duration getDurationProperty(String[] stringArray, String string, Supplier<Duration> supplier) {
        for (String string2 : stringArray) {
            if (!this.hasProperty(string2 + string)) continue;
            return this.getDurationProperty(string2 + string, null);
        }
        return supplier != null ? supplier.get() : null;
    }

    public String getStringProperty(String[] stringArray, String string, Supplier<String> supplier) {
        for (String string2 : stringArray) {
            String string3 = this.getStringProperty(string2 + string);
            if (string3 == null) continue;
            return string3;
        }
        return supplier != null ? supplier.get() : null;
    }

    public String getStringProperty(String string) {
        return PropertiesUtil$Environment.access$200(this.environment, string);
    }

    public String getStringProperty(String string, String string2) {
        String string3 = this.getStringProperty(string);
        return string3 == null ? string2 : string3;
    }

    public static Properties getSystemProperties() {
        try {
            return new Properties(System.getProperties());
        }
        catch (SecurityException securityException) {
            LowLevelLogUtil.logException("Unable to access system properties.", securityException);
            return new Properties();
        }
    }

    public void reload() {
        PropertiesUtil$Environment.access$300(this.environment);
    }

    public static Properties extractSubset(Properties properties, String string) {
        Properties properties2 = new Properties();
        if (string == null || string.length() == 0) {
            return properties2;
        }
        String string2 = string.charAt(string.length() - 1) != '.' ? string + '.' : string;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string3 : properties.stringPropertyNames()) {
            if (!string3.startsWith(string2)) continue;
            properties2.setProperty(string3.substring(string2.length()), properties.getProperty(string3));
            arrayList.add(string3);
        }
        for (String string3 : arrayList) {
            properties.remove(string3);
        }
        return properties2;
    }

    static ResourceBundle getCharsetsResourceBundle() {
        return ResourceBundle.getBundle("Log4j-charsets");
    }

    public static Map<String, Properties> partitionOnCommonPrefixes(Properties properties) {
        return PropertiesUtil.partitionOnCommonPrefixes(properties, false);
    }

    public static Map<String, Properties> partitionOnCommonPrefixes(Properties properties, boolean bl) {
        ConcurrentHashMap<String, Properties> concurrentHashMap = new ConcurrentHashMap<String, Properties>();
        for (String string : properties.stringPropertyNames()) {
            int n = string.indexOf(46);
            if (n < 0) {
                if (!bl) continue;
                if (!concurrentHashMap.containsKey(string)) {
                    concurrentHashMap.put(string, new Properties());
                }
                ((Properties)concurrentHashMap.get(string)).setProperty("", properties.getProperty(string));
                continue;
            }
            String string2 = string.substring(0, n);
            if (!concurrentHashMap.containsKey(string2)) {
                concurrentHashMap.put(string2, new Properties());
            }
            ((Properties)concurrentHashMap.get(string2)).setProperty(string.substring(n + 1), properties.getProperty(string));
        }
        return concurrentHashMap;
    }

    public boolean isOsWindows() {
        return this.getStringProperty("os.name", "").startsWith("Windows");
    }
}

