/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.lang.invoke.MethodHandles;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import org.apache.logging.log4j.util.PropertiesUtil$1;
import org.apache.logging.log4j.util.PropertyFilePropertySource;
import org.apache.logging.log4j.util.PropertySource;
import org.apache.logging.log4j.util.PropertySource$Comparator;
import org.apache.logging.log4j.util.PropertySource$Util;
import org.apache.logging.log4j.util.ServiceLoaderUtil;

class PropertiesUtil$Environment {
    private final Set<PropertySource> sources = new ConcurrentSkipListSet<PropertySource>(new PropertySource$Comparator());
    private final Map<String, String> literal = new ConcurrentHashMap<String, String>();
    private final Map<List<CharSequence>, String> tokenized = new ConcurrentHashMap<List<CharSequence>, String>();

    private PropertiesUtil$Environment(PropertySource propertySource) {
        PropertyFilePropertySource propertyFilePropertySource = new PropertyFilePropertySource("log4j2.system.properties", false);
        try {
            propertyFilePropertySource.forEach((string, string2) -> {
                if (System.getProperty(string) == null) {
                    System.setProperty(string, string2);
                }
            });
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.sources.add(propertySource);
        ServiceLoaderUtil.loadServices(PropertySource.class, MethodHandles.lookup(), false, false).forEach(this.sources::add);
        this.reload();
    }

    public void addPropertySource(PropertySource propertySource) {
        this.sources.add(propertySource);
    }

    private synchronized void reload() {
        this.literal.clear();
        this.tokenized.clear();
        HashSet hashSet = new HashSet();
        this.sources.stream().map(PropertySource::getPropertyNames).reduce(hashSet, (collection, collection2) -> {
            collection.addAll(collection2);
            return collection;
        });
        hashSet.stream().filter(Objects::nonNull).forEach(string -> {
            List<CharSequence> list = PropertySource$Util.tokenize(string);
            boolean bl = !list.isEmpty();
            this.sources.forEach(propertySource -> {
                String string2;
                if (propertySource.containsProperty((String)string)) {
                    string2 = propertySource.getProperty((String)string);
                    if (bl) {
                        this.tokenized.putIfAbsent(list, string2);
                    }
                }
                if (bl) {
                    string2 = Objects.toString(propertySource.getNormalForm(list), null);
                    if (string2 != null && propertySource.containsProperty(string2)) {
                        this.literal.putIfAbsent((String)string, propertySource.getProperty(string2));
                    } else if (propertySource.containsProperty((String)string)) {
                        this.literal.putIfAbsent((String)string, propertySource.getProperty((String)string));
                    }
                }
            });
        });
    }

    private String get(String string) {
        if (this.literal.containsKey(string)) {
            return this.literal.get(string);
        }
        List<CharSequence> list = PropertySource$Util.tokenize(string);
        boolean bl = !list.isEmpty();
        for (PropertySource propertySource : this.sources) {
            String string2;
            if (bl && (string2 = Objects.toString(propertySource.getNormalForm(list), null)) != null && propertySource.containsProperty(string2)) {
                return propertySource.getProperty(string2);
            }
            if (!propertySource.containsProperty(string)) continue;
            return propertySource.getProperty(string);
        }
        return this.tokenized.get(list);
    }

    private boolean containsKey(String string) {
        List<CharSequence> list = PropertySource$Util.tokenize(string);
        return this.literal.containsKey(string) || this.tokenized.containsKey(list) || this.sources.stream().anyMatch(propertySource -> {
            CharSequence charSequence = propertySource.getNormalForm(list);
            return propertySource.containsProperty(string) || charSequence != null && propertySource.containsProperty(charSequence.toString());
        });
    }

    /* synthetic */ PropertiesUtil$Environment(PropertySource propertySource, PropertiesUtil$1 propertiesUtil$1) {
        this(propertySource);
    }

    static /* synthetic */ boolean access$100(PropertiesUtil$Environment propertiesUtil$Environment, String string) {
        return propertiesUtil$Environment.containsKey(string);
    }

    static /* synthetic */ String access$200(PropertiesUtil$Environment propertiesUtil$Environment, String string) {
        return propertiesUtil$Environment.get(string);
    }

    static /* synthetic */ void access$300(PropertiesUtil$Environment propertiesUtil$Environment) {
        propertiesUtil$Environment.reload();
    }
}

