/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import org.apache.logging.log4j.util.PrivateSecurityManagerStackTraceUtil$PrivateSecurityManager;

final class PrivateSecurityManagerStackTraceUtil {
    private static final PrivateSecurityManagerStackTraceUtil$PrivateSecurityManager SECURITY_MANAGER;

    private PrivateSecurityManagerStackTraceUtil() {
    }

    static boolean isEnabled() {
        return SECURITY_MANAGER != null;
    }

    static Deque<Class<?>> getCurrentStackTrace() {
        Class<?>[] classArray = SECURITY_MANAGER.getClassContext();
        ArrayDeque arrayDeque = new ArrayDeque(classArray.length);
        Collections.addAll(arrayDeque, classArray);
        return arrayDeque;
    }

    static {
        PrivateSecurityManagerStackTraceUtil$PrivateSecurityManager privateSecurityManagerStackTraceUtil$PrivateSecurityManager;
        try {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkPermission(new RuntimePermission("createSecurityManager"));
            }
            privateSecurityManagerStackTraceUtil$PrivateSecurityManager = new PrivateSecurityManagerStackTraceUtil$PrivateSecurityManager(null);
        }
        catch (SecurityException securityException) {
            privateSecurityManagerStackTraceUtil$PrivateSecurityManager = null;
        }
        SECURITY_MANAGER = privateSecurityManagerStackTraceUtil$PrivateSecurityManager;
    }
}

