/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.lang.invoke.MethodHandles;
import java.util.stream.Stream;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.LowLevelLogUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class OsgiServiceLocator {
    private static final boolean OSGI_AVAILABLE = OsgiServiceLocator.checkOsgiAvailable();

    private static boolean checkOsgiAvailable() {
        try {
            Class<?> clazz = Class.forName("org.osgi.framework.FrameworkUtil");
            return clazz.getMethod("getBundle", Class.class).invoke(null, OsgiServiceLocator.class) != null;
        }
        catch (ClassNotFoundException | LinkageError | NoSuchMethodException throwable) {
            return false;
        }
        catch (Throwable throwable) {
            LowLevelLogUtil.logException("Unknown error checking OSGI environment.", throwable);
            return false;
        }
    }

    public static boolean isAvailable() {
        return OSGI_AVAILABLE;
    }

    public static <T> Stream<T> loadServices(Class<T> clazz, MethodHandles.Lookup lookup) {
        return OsgiServiceLocator.loadServices(clazz, lookup, true);
    }

    public static <T> Stream<T> loadServices(Class<T> clazz, MethodHandles.Lookup lookup, boolean bl) {
        block3: {
            Bundle bundle = FrameworkUtil.getBundle(lookup.lookupClass());
            if (bundle != null) {
                BundleContext bundleContext = bundle.getBundleContext();
                try {
                    return bundleContext.getServiceReferences(clazz, null).stream().map(arg_0 -> ((BundleContext)bundleContext).getService(arg_0));
                }
                catch (Throwable throwable) {
                    if (!bl) break block3;
                    StatusLogger.getLogger().error("Unable to load OSGI services for service {}", (Object)clazz, (Object)throwable);
                }
            }
        }
        return Stream.empty();
    }
}

