/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.lang.reflect.Method;
import org.apache.logging.log4j.LoggingException;
import org.apache.logging.log4j.util.LoaderUtil;
import org.apache.logging.log4j.util.LowLevelLogUtil;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class Base64Util {
    private static Method encodeMethod = null;
    private static Object encoder = null;

    private Base64Util() {
    }

    public static String encode(String string) {
        if (string == null) {
            return null;
        }
        byte[] byArray = string.getBytes();
        if (encodeMethod != null) {
            try {
                return (String)encodeMethod.invoke(encoder, new Object[]{byArray});
            }
            catch (Exception exception) {
                throw new LoggingException("Unable to encode String", exception);
            }
        }
        throw new LoggingException("No Encoder, unable to encode string");
    }

    static {
        try {
            Class<?> clazz = LoaderUtil.loadClass("java.util.Base64");
            Class<?> clazz2 = LoaderUtil.loadClass("java.util.Base64$Encoder");
            Method method = clazz.getMethod("getEncoder", new Class[0]);
            encoder = method.invoke(null, new Object[0]);
            encodeMethod = clazz2.getMethod("encodeToString", byte[].class);
        }
        catch (Exception exception) {
            try {
                Class<?> clazz = LoaderUtil.loadClass("javax.xml.bind.DataTypeConverter");
                encodeMethod = clazz.getMethod("printBase64Binary", new Class[0]);
            }
            catch (Exception exception2) {
                LowLevelLogUtil.logException("Unable to create a Base64 Encoder", exception2);
            }
        }
    }
}

