/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.message;

import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.util.StringBuilders;

final class ParameterFormatter {
    static final String RECURSION_PREFIX = "[...";
    static final String RECURSION_SUFFIX = "...]";
    static final String ERROR_PREFIX = "[!!!";
    static final String ERROR_SEPARATOR = "=>";
    static final String ERROR_MSG_SEPARATOR = ":";
    static final String ERROR_SUFFIX = "!!!]";
    private static final char DELIM_START = '{';
    private static final char DELIM_STOP = '}';
    private static final char ESCAPE_CHAR = '\\';
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZ").withZone(ZoneId.systemDefault());

    private ParameterFormatter() {
    }

    static int countArgumentPlaceholders(String string) {
        if (string == null) {
            return 0;
        }
        int n = string.length();
        int n2 = 0;
        boolean bl = false;
        for (int i = 0; i < n - 1; ++i) {
            char c = string.charAt(i);
            if (c == '\\') {
                bl = !bl;
                continue;
            }
            if (c == '{') {
                if (!bl && string.charAt(i + 1) == '}') {
                    ++n2;
                    ++i;
                }
                bl = false;
                continue;
            }
            bl = false;
        }
        return n2;
    }

    static int countArgumentPlaceholders2(String string, int[] nArray) {
        if (string == null) {
            return 0;
        }
        int n = string.length();
        int n2 = 0;
        boolean bl = false;
        for (int i = 0; i < n - 1; ++i) {
            char c = string.charAt(i);
            if (c == '\\') {
                bl = !bl;
                nArray[0] = -1;
                ++n2;
                continue;
            }
            if (c == '{') {
                if (!bl && string.charAt(i + 1) == '}') {
                    nArray[n2] = i++;
                    ++n2;
                }
                bl = false;
                continue;
            }
            bl = false;
        }
        return n2;
    }

    static int countArgumentPlaceholders3(char[] cArray, int n, int[] nArray) {
        int n2 = 0;
        boolean bl = false;
        for (int i = 0; i < n - 1; ++i) {
            char c = cArray[i];
            if (c == '\\') {
                bl = !bl;
                continue;
            }
            if (c == '{') {
                if (!bl && cArray[i + 1] == '}') {
                    nArray[n2] = i++;
                    ++n2;
                }
                bl = false;
                continue;
            }
            bl = false;
        }
        return n2;
    }

    static String format(String string, Object[] objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = objectArray == null ? 0 : objectArray.length;
        ParameterFormatter.formatMessage(stringBuilder, string, objectArray, n);
        return stringBuilder.toString();
    }

    static void formatMessage2(StringBuilder stringBuilder, String string, Object[] objectArray, int n, int[] nArray) {
        if (string == null || objectArray == null || n == 0) {
            stringBuilder.append(string);
            return;
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(string, n2, nArray[i]);
            n2 = nArray[i] + 2;
            ParameterFormatter.recursiveDeepToString(objectArray[i], stringBuilder);
        }
        stringBuilder.append(string, n2, string.length());
    }

    static void formatMessage3(StringBuilder stringBuilder, char[] cArray, int n, Object[] objectArray, int n2, int[] nArray) {
        if (cArray == null) {
            return;
        }
        if (objectArray == null || n2 == 0) {
            stringBuilder.append(cArray);
            return;
        }
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            stringBuilder.append(cArray, n3, nArray[i]);
            n3 = nArray[i] + 2;
            ParameterFormatter.recursiveDeepToString(objectArray[i], stringBuilder);
        }
        stringBuilder.append(cArray, n3, n);
    }

    static void formatMessage(StringBuilder stringBuilder, String string, Object[] objectArray, int n) {
        int n2;
        if (string == null || objectArray == null || n == 0) {
            stringBuilder.append(string);
            return;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = string.length();
        for (n2 = 0; n2 < n5 - 1; ++n2) {
            char c = string.charAt(n2);
            if (c == '\\') {
                ++n3;
                continue;
            }
            if (ParameterFormatter.isDelimPair(c, string, n2)) {
                ++n2;
                ParameterFormatter.writeEscapedEscapeChars(n3, stringBuilder);
                if (ParameterFormatter.isOdd(n3)) {
                    ParameterFormatter.writeDelimPair(stringBuilder);
                } else {
                    ParameterFormatter.writeArgOrDelimPair(objectArray, n, n4, stringBuilder);
                    ++n4;
                }
            } else {
                ParameterFormatter.handleLiteralChar(stringBuilder, n3, c);
            }
            n3 = 0;
        }
        ParameterFormatter.handleRemainingCharIfAny(string, n5, stringBuilder, n3, n2);
    }

    private static boolean isDelimPair(char c, String string, int n) {
        return c == '{' && string.charAt(n + 1) == '}';
    }

    private static void handleRemainingCharIfAny(String string, int n, StringBuilder stringBuilder, int n2, int n3) {
        if (n3 == n - 1) {
            char c = string.charAt(n3);
            ParameterFormatter.handleLastChar(stringBuilder, n2, c);
        }
    }

    private static void handleLastChar(StringBuilder stringBuilder, int n, char c) {
        if (c == '\\') {
            ParameterFormatter.writeUnescapedEscapeChars(n + 1, stringBuilder);
        } else {
            ParameterFormatter.handleLiteralChar(stringBuilder, n, c);
        }
    }

    private static void handleLiteralChar(StringBuilder stringBuilder, int n, char c) {
        ParameterFormatter.writeUnescapedEscapeChars(n, stringBuilder);
        stringBuilder.append(c);
    }

    private static void writeDelimPair(StringBuilder stringBuilder) {
        stringBuilder.append('{');
        stringBuilder.append('}');
    }

    private static boolean isOdd(int n) {
        return (n & 1) == 1;
    }

    private static void writeEscapedEscapeChars(int n, StringBuilder stringBuilder) {
        int n2 = n >> 1;
        ParameterFormatter.writeUnescapedEscapeChars(n2, stringBuilder);
    }

    private static void writeUnescapedEscapeChars(int n, StringBuilder stringBuilder) {
        while (n > 0) {
            stringBuilder.append('\\');
            --n;
        }
    }

    private static void writeArgOrDelimPair(Object[] objectArray, int n, int n2, StringBuilder stringBuilder) {
        if (n2 < n) {
            ParameterFormatter.recursiveDeepToString(objectArray[n2], stringBuilder);
        } else {
            ParameterFormatter.writeDelimPair(stringBuilder);
        }
    }

    static String deepToString(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Integer) {
            return Integer.toString((Integer)object);
        }
        if (object instanceof Long) {
            return Long.toString((Long)object);
        }
        if (object instanceof Double) {
            return Double.toString((Double)object);
        }
        if (object instanceof Boolean) {
            return Boolean.toString((Boolean)object);
        }
        if (object instanceof Character) {
            return Character.toString(((Character)object).charValue());
        }
        if (object instanceof Short) {
            return Short.toString((Short)object);
        }
        if (object instanceof Float) {
            return Float.toString(((Float)object).floatValue());
        }
        if (object instanceof Byte) {
            return Byte.toString((Byte)object);
        }
        StringBuilder stringBuilder = new StringBuilder();
        ParameterFormatter.recursiveDeepToString(object, stringBuilder);
        return stringBuilder.toString();
    }

    static void recursiveDeepToString(Object object, StringBuilder stringBuilder) {
        ParameterFormatter.recursiveDeepToString(object, stringBuilder, null);
    }

    private static void recursiveDeepToString(Object object, StringBuilder stringBuilder, Set<Object> set) {
        if (ParameterFormatter.appendSpecialTypes(object, stringBuilder)) {
            return;
        }
        if (ParameterFormatter.isMaybeRecursive(object)) {
            ParameterFormatter.appendPotentiallyRecursiveValue(object, stringBuilder, set);
        } else {
            ParameterFormatter.tryObjectToString(object, stringBuilder);
        }
    }

    private static boolean appendSpecialTypes(Object object, StringBuilder stringBuilder) {
        return StringBuilders.appendSpecificTypes(stringBuilder, object) || ParameterFormatter.appendDate(object, stringBuilder);
    }

    private static boolean appendDate(Object object, StringBuilder stringBuilder) {
        if (!(object instanceof Date)) {
            return false;
        }
        stringBuilder.append(DATE_FORMATTER.format(((Date)object).toInstant()));
        return true;
    }

    private static boolean isMaybeRecursive(Object object) {
        return object.getClass().isArray() || object instanceof Map || object instanceof Collection;
    }

    private static void appendPotentiallyRecursiveValue(Object object, StringBuilder stringBuilder, Set<Object> set) {
        Class<?> clazz = object.getClass();
        if (clazz.isArray()) {
            ParameterFormatter.appendArray(object, stringBuilder, set, clazz);
        } else if (object instanceof Map) {
            ParameterFormatter.appendMap(object, stringBuilder, set);
        } else if (object instanceof Collection) {
            ParameterFormatter.appendCollection(object, stringBuilder, set);
        } else {
            throw new IllegalArgumentException("was expecting a container, found " + clazz);
        }
    }

    private static void appendArray(Object object, StringBuilder stringBuilder, Set<Object> set, Class<?> clazz) {
        if (clazz == byte[].class) {
            stringBuilder.append(Arrays.toString((byte[])object));
        } else if (clazz == short[].class) {
            stringBuilder.append(Arrays.toString((short[])object));
        } else if (clazz == int[].class) {
            stringBuilder.append(Arrays.toString((int[])object));
        } else if (clazz == long[].class) {
            stringBuilder.append(Arrays.toString((long[])object));
        } else if (clazz == float[].class) {
            stringBuilder.append(Arrays.toString((float[])object));
        } else if (clazz == double[].class) {
            stringBuilder.append(Arrays.toString((double[])object));
        } else if (clazz == boolean[].class) {
            stringBuilder.append(Arrays.toString((boolean[])object));
        } else if (clazz == char[].class) {
            stringBuilder.append(Arrays.toString((char[])object));
        } else {
            boolean bl;
            Set<Object> set2 = ParameterFormatter.getOrCreateDejaVu(set);
            boolean bl2 = bl = !set2.add(object);
            if (bl) {
                String string = ParameterFormatter.identityToString(object);
                stringBuilder.append(RECURSION_PREFIX).append(string).append(RECURSION_SUFFIX);
            } else {
                Object[] objectArray = (Object[])object;
                stringBuilder.append('[');
                boolean bl3 = true;
                for (Object object2 : objectArray) {
                    if (bl3) {
                        bl3 = false;
                    } else {
                        stringBuilder.append(", ");
                    }
                    ParameterFormatter.recursiveDeepToString(object2, stringBuilder, ParameterFormatter.cloneDejaVu(set2));
                }
                stringBuilder.append(']');
            }
        }
    }

    private static void appendMap(Object object, StringBuilder stringBuilder, Set<Object> set) {
        boolean bl;
        Set<Object> set2 = ParameterFormatter.getOrCreateDejaVu(set);
        boolean bl2 = bl = !set2.add(object);
        if (bl) {
            String string = ParameterFormatter.identityToString(object);
            stringBuilder.append(RECURSION_PREFIX).append(string).append(RECURSION_SUFFIX);
        } else {
            Map map = (Map)object;
            stringBuilder.append('{');
            boolean bl3 = true;
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry;
                Map.Entry entry2 = entry = iterator.next();
                if (bl3) {
                    bl3 = false;
                } else {
                    stringBuilder.append(", ");
                }
                Object k = entry2.getKey();
                Object v = entry2.getValue();
                ParameterFormatter.recursiveDeepToString(k, stringBuilder, ParameterFormatter.cloneDejaVu(set2));
                stringBuilder.append('=');
                ParameterFormatter.recursiveDeepToString(v, stringBuilder, ParameterFormatter.cloneDejaVu(set2));
            }
            stringBuilder.append('}');
        }
    }

    private static void appendCollection(Object object, StringBuilder stringBuilder, Set<Object> set) {
        boolean bl;
        Set<Object> set2 = ParameterFormatter.getOrCreateDejaVu(set);
        boolean bl2 = bl = !set2.add(object);
        if (bl) {
            String string = ParameterFormatter.identityToString(object);
            stringBuilder.append(RECURSION_PREFIX).append(string).append(RECURSION_SUFFIX);
        } else {
            Collection collection = (Collection)object;
            stringBuilder.append('[');
            boolean bl3 = true;
            for (Object e : collection) {
                if (bl3) {
                    bl3 = false;
                } else {
                    stringBuilder.append(", ");
                }
                ParameterFormatter.recursiveDeepToString(e, stringBuilder, ParameterFormatter.cloneDejaVu(set2));
            }
            stringBuilder.append(']');
        }
    }

    private static Set<Object> getOrCreateDejaVu(Set<Object> set) {
        return set == null ? ParameterFormatter.createDejaVu() : set;
    }

    private static Set<Object> createDejaVu() {
        return Collections.newSetFromMap(new IdentityHashMap());
    }

    private static Set<Object> cloneDejaVu(Set<Object> set) {
        Set<Object> set2 = ParameterFormatter.createDejaVu();
        set2.addAll(set);
        return set2;
    }

    private static void tryObjectToString(Object object, StringBuilder stringBuilder) {
        try {
            stringBuilder.append(object.toString());
        }
        catch (Throwable throwable) {
            ParameterFormatter.handleErrorInObjectToString(object, stringBuilder, throwable);
        }
    }

    private static void handleErrorInObjectToString(Object object, StringBuilder stringBuilder, Throwable throwable) {
        stringBuilder.append(ERROR_PREFIX);
        stringBuilder.append(ParameterFormatter.identityToString(object));
        stringBuilder.append(ERROR_SEPARATOR);
        String string = throwable.getMessage();
        String string2 = throwable.getClass().getName();
        stringBuilder.append(string2);
        if (!string2.equals(string)) {
            stringBuilder.append(ERROR_MSG_SEPARATOR);
            stringBuilder.append(string);
        }
        stringBuilder.append(ERROR_SUFFIX);
    }

    static String identityToString(Object object) {
        if (object == null) {
            return null;
        }
        return object.getClass().getName() + '@' + Integer.toHexString(System.identityHashCode(object));
    }
}

