/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.internal;

import java.util.Arrays;
import org.apache.logging.log4j.BridgeAware;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogBuilder;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.LambdaUtil;
import org.apache.logging.log4j.util.StackLocatorUtil;
import org.apache.logging.log4j.util.Supplier;

public class DefaultLogBuilder
implements BridgeAware,
LogBuilder {
    private static Message EMPTY_MESSAGE = new SimpleMessage("");
    private static final String FQCN = DefaultLogBuilder.class.getName();
    private static final Logger LOGGER = StatusLogger.getLogger();
    private ExtendedLogger logger;
    private Level level;
    private Marker marker;
    private Throwable throwable;
    private StackTraceElement location;
    private volatile boolean inUse;
    private long threadId;
    private String fqcn = FQCN;

    public DefaultLogBuilder(ExtendedLogger extendedLogger, Level level) {
        this.logger = extendedLogger;
        this.level = level;
        this.threadId = Thread.currentThread().getId();
        this.inUse = level != null;
    }

    public DefaultLogBuilder() {
        this(null, null);
    }

    @Override
    public void setEntryPoint(String string) {
        this.fqcn = string;
    }

    public LogBuilder reset(ExtendedLogger extendedLogger, Level level) {
        this.logger = extendedLogger;
        this.level = level;
        this.marker = null;
        this.throwable = null;
        this.location = null;
        this.inUse = true;
        return this;
    }

    @Override
    public LogBuilder withMarker(Marker marker) {
        this.marker = marker;
        return this;
    }

    @Override
    public LogBuilder withThrowable(Throwable throwable) {
        this.throwable = throwable;
        return this;
    }

    @Override
    public LogBuilder withLocation() {
        this.location = StackLocatorUtil.getStackTraceElement(2);
        return this;
    }

    @Override
    public LogBuilder withLocation(StackTraceElement stackTraceElement) {
        this.location = stackTraceElement;
        return this;
    }

    public boolean isInUse() {
        return this.inUse;
    }

    @Override
    public void log(Message message) {
        if (this.isValid() && this.isEnabled(message)) {
            this.logMessage(message);
        }
    }

    @Override
    public Message logAndGet(Supplier<Message> supplier) {
        Message message = null;
        if (this.isValid() && this.isEnabled(message = supplier.get())) {
            this.logMessage(message);
        }
        return message;
    }

    @Override
    public void log(CharSequence charSequence) {
        if (this.isValid() && this.isEnabled(charSequence)) {
            this.logMessage(this.logger.getMessageFactory().newMessage(charSequence));
        }
    }

    @Override
    public void log(String string) {
        if (this.isValid() && this.isEnabled(string)) {
            this.logMessage(this.logger.getMessageFactory().newMessage(string));
        }
    }

    @Override
    public void log(String string, Object ... objectArray) {
        if (this.isValid() && this.isEnabled(string, objectArray)) {
            this.logMessage(this.logger.getMessageFactory().newMessage(string, objectArray));
        }
    }

    @Override
    public void log(String string, Supplier<?> ... supplierArray) {
        Object[] objectArray;
        if (this.isValid() && this.isEnabled(string, objectArray = LambdaUtil.getAll(supplierArray))) {
            this.logMessage(this.logger.getMessageFactory().newMessage(string, objectArray));
        }
    }

    @Override
    public void log(Supplier<Message> supplier) {
        this.logAndGet(supplier);
    }

    @Override
    public void log(Object object) {
        if (this.isValid() && this.isEnabled(object)) {
            this.logMessage(this.logger.getMessageFactory().newMessage(object));
        }
    }

    @Override
    public void log(String string, Object object) {
        if (this.isValid() && this.isEnabled(string, object)) {
            this.logMessage(this.logger.getMessageFactory().newMessage(string, object));
        }
    }

    @Override
    public void log(String string, Object object, Object object2) {
        if (this.isValid() && this.isEnabled(string, object, object2)) {
            this.logMessage(this.logger.getMessageFactory().newMessage(string, object, object2));
        }
    }

    @Override
    public void log(String string, Object object, Object object2, Object object3) {
        if (this.isValid() && this.isEnabled(string, object, object2, object3)) {
            this.logMessage(this.logger.getMessageFactory().newMessage(string, object, object2, object3));
        }
    }

    @Override
    public void log(String string, Object object, Object object2, Object object3, Object object4) {
        if (this.isValid() && this.isEnabled(string, object, object2, object3, object4)) {
            this.logMessage(this.logger.getMessageFactory().newMessage(string, object, object2, object3, object4));
        }
    }

    @Override
    public void log(String string, Object object, Object object2, Object object3, Object object4, Object object5) {
        if (this.isValid() && this.isEnabled(string, object, object2, object3, object4, object5)) {
            this.logMessage(this.logger.getMessageFactory().newMessage(string, object, object2, object3, object4, object5));
        }
    }

    @Override
    public void log(String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        if (this.isValid() && this.isEnabled(string, object, object2, object3, object4, object5, object6)) {
            this.logMessage(this.logger.getMessageFactory().newMessage(string, object, object2, object3, object4, object5, object6));
        }
    }

    @Override
    public void log(String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7) {
        if (this.isValid() && this.isEnabled(string, object, object2, object3, object4, object5, object6, object7)) {
            this.logMessage(this.logger.getMessageFactory().newMessage(string, object, object2, object3, object4, object5, object6, object7));
        }
    }

    @Override
    public void log(String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8) {
        if (this.isValid() && this.isEnabled(string, object, object2, object3, object4, object5, object6, object7, object8)) {
            this.logMessage(this.logger.getMessageFactory().newMessage(string, object, object2, object3, object4, object5, object6, object7, object8));
        }
    }

    @Override
    public void log(String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9) {
        if (this.isValid() && this.isEnabled(string, object, object2, object3, object4, object5, object6, object7, object8, object9)) {
            this.logMessage(this.logger.getMessageFactory().newMessage(string, object, object2, object3, object4, object5, object6, object7, object8, object9));
        }
    }

    @Override
    public void log(String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10) {
        if (this.isValid() && this.isEnabled(string, object, object2, object3, object4, object5, object6, object7, object8, object9, object10)) {
            this.logMessage(this.logger.getMessageFactory().newMessage(string, object, object2, object3, object4, object5, object6, object7, object8, object9, object10));
        }
    }

    @Override
    public void log() {
        if (this.isValid() && this.isEnabled(EMPTY_MESSAGE)) {
            this.logMessage(EMPTY_MESSAGE);
        }
    }

    private void logMessage(Message message) {
        try {
            this.logger.logMessage(this.level, this.marker, this.fqcn, this.location, message, this.throwable);
        }
        finally {
            this.inUse = false;
        }
    }

    private boolean isValid() {
        if (!this.inUse) {
            LOGGER.warn("Attempt to reuse LogBuilder was ignored. {}", (Object)StackLocatorUtil.getCallerClass(2));
            return false;
        }
        if (this.threadId != Thread.currentThread().getId()) {
            LOGGER.warn("LogBuilder can only be used on the owning thread. {}", (Object)StackLocatorUtil.getCallerClass(2));
            return false;
        }
        return true;
    }

    protected boolean isEnabled(Message message) {
        return this.logger.isEnabled(this.level, this.marker, message, this.throwable);
    }

    protected boolean isEnabled(CharSequence charSequence) {
        return this.logger.isEnabled(this.level, this.marker, charSequence, this.throwable);
    }

    protected boolean isEnabled(String string) {
        return this.logger.isEnabled(this.level, this.marker, string, this.throwable);
    }

    protected boolean isEnabled(String string, Object ... objectArray) {
        Object[] objectArray2;
        if (this.throwable != null) {
            objectArray2 = Arrays.copyOf(objectArray, objectArray.length + 1);
            objectArray2[objectArray.length] = this.throwable;
        } else {
            objectArray2 = objectArray;
        }
        return this.logger.isEnabled(this.level, this.marker, string, objectArray2);
    }

    protected boolean isEnabled(Object object) {
        return this.logger.isEnabled(this.level, this.marker, object, this.throwable);
    }

    protected boolean isEnabled(String string, Object object) {
        return this.throwable != null ? this.logger.isEnabled(this.level, this.marker, string, object, (Object)this.throwable) : this.logger.isEnabled(this.level, this.marker, string, object);
    }

    protected boolean isEnabled(String string, Object object, Object object2) {
        return this.throwable != null ? this.logger.isEnabled(this.level, this.marker, string, object, object2, (Object)this.throwable) : this.logger.isEnabled(this.level, this.marker, string, object, object2);
    }

    protected boolean isEnabled(String string, Object object, Object object2, Object object3) {
        return this.throwable != null ? this.logger.isEnabled(this.level, this.marker, string, object, object2, object3, (Object)this.throwable) : this.logger.isEnabled(this.level, this.marker, string, object, object2, object3);
    }

    protected boolean isEnabled(String string, Object object, Object object2, Object object3, Object object4) {
        return this.throwable != null ? this.logger.isEnabled(this.level, this.marker, string, object, object2, object3, object4, (Object)this.throwable) : this.logger.isEnabled(this.level, this.marker, string, object, object2, object3, object4);
    }

    protected boolean isEnabled(String string, Object object, Object object2, Object object3, Object object4, Object object5) {
        return this.throwable != null ? this.logger.isEnabled(this.level, this.marker, string, object, object2, object3, object4, object5, (Object)this.throwable) : this.logger.isEnabled(this.level, this.marker, string, object, object2, object3, object4, object5);
    }

    protected boolean isEnabled(String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        return this.throwable != null ? this.logger.isEnabled(this.level, this.marker, string, object, object2, object3, object4, object5, object6, (Object)this.throwable) : this.logger.isEnabled(this.level, this.marker, string, object, object2, object3, object4, object5, object6);
    }

    protected boolean isEnabled(String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7) {
        return this.throwable != null ? this.logger.isEnabled(this.level, this.marker, string, object, object2, object3, object4, object5, object6, object7, (Object)this.throwable) : this.logger.isEnabled(this.level, this.marker, string, object, object2, object3, object4, object5, object6, object7);
    }

    protected boolean isEnabled(String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8) {
        return this.throwable != null ? this.logger.isEnabled(this.level, this.marker, string, object, object2, object3, object4, object5, object6, object7, object8, (Object)this.throwable) : this.logger.isEnabled(this.level, this.marker, string, object, object2, object3, object4, object5, object6, object7, object8);
    }

    protected boolean isEnabled(String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9) {
        return this.throwable != null ? this.logger.isEnabled(this.level, this.marker, string, object, object2, object3, object4, object5, object6, object7, object8, object9, (Object)this.throwable) : this.logger.isEnabled(this.level, this.marker, string, object, object2, object3, object4, object5, object6, object7, object8, object9);
    }

    protected boolean isEnabled(String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10) {
        return this.throwable != null ? this.logger.isEnabled(this.level, this.marker, string, object, object2, object3, object4, object5, object6, object7, object8, object9, object10, this.throwable) : this.logger.isEnabled(this.level, this.marker, string, object, object2, object3, object4, object5, object6, object7, object8, object9, object10);
    }
}

