/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util.datetime;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.core.util.datetime.Format;
import org.apache.logging.log4j.core.util.datetime.FormatCache$MultipartKey;

abstract class FormatCache<F extends Format> {
    static final int NONE = -1;
    private final ConcurrentMap<FormatCache$MultipartKey, F> cInstanceCache = new ConcurrentHashMap<FormatCache$MultipartKey, F>(7);
    private static final ConcurrentMap<FormatCache$MultipartKey, String> cDateTimeInstanceCache = new ConcurrentHashMap<FormatCache$MultipartKey, String>(7);

    FormatCache() {
    }

    public F getInstance() {
        return this.getDateTimeInstance(3, 3, TimeZone.getDefault(), Locale.getDefault());
    }

    public F getInstance(String string, TimeZone timeZone, Locale locale) {
        Format format;
        FormatCache$MultipartKey formatCache$MultipartKey;
        Format format2;
        if (string == null) {
            throw new NullPointerException("pattern must not be null");
        }
        if (timeZone == null) {
            timeZone = TimeZone.getDefault();
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((format2 = (Format)this.cInstanceCache.get(formatCache$MultipartKey = new FormatCache$MultipartKey(string, timeZone, locale))) == null && (format = this.cInstanceCache.putIfAbsent(formatCache$MultipartKey, format2 = this.createInstance(string, timeZone, locale))) != null) {
            format2 = format;
        }
        return (F)format2;
    }

    protected abstract F createInstance(String var1, TimeZone var2, Locale var3);

    private F getDateTimeInstance(Integer n, Integer n2, TimeZone timeZone, Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        String string = FormatCache.getPatternForStyle(n, n2, locale);
        return this.getInstance(string, timeZone, locale);
    }

    F getDateTimeInstance(int n, int n2, TimeZone timeZone, Locale locale) {
        return this.getDateTimeInstance((Integer)n, (Integer)n2, timeZone, locale);
    }

    F getDateInstance(int n, TimeZone timeZone, Locale locale) {
        return this.getDateTimeInstance((Integer)n, null, timeZone, locale);
    }

    F getTimeInstance(int n, TimeZone timeZone, Locale locale) {
        return this.getDateTimeInstance(null, (Integer)n, timeZone, locale);
    }

    static String getPatternForStyle(Integer n, Integer n2, Locale locale) {
        FormatCache$MultipartKey formatCache$MultipartKey = new FormatCache$MultipartKey(n, n2, locale);
        String string = (String)cDateTimeInstanceCache.get(formatCache$MultipartKey);
        if (string == null) {
            try {
                DateFormat dateFormat = n == null ? DateFormat.getTimeInstance(n2, locale) : (n2 == null ? DateFormat.getDateInstance(n, locale) : DateFormat.getDateTimeInstance(n, n2, locale));
                string = ((SimpleDateFormat)dateFormat).toPattern();
                String string2 = cDateTimeInstanceCache.putIfAbsent(formatCache$MultipartKey, string);
                if (string2 != null) {
                    string = string2;
                }
            }
            catch (ClassCastException classCastException) {
                throw new IllegalArgumentException("No date time pattern for locale: " + locale);
            }
        }
        return string;
    }
}

