/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util;

import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.AbstractLifeCycle;
import org.apache.logging.log4j.core.config.ConfigurationFileWatcher;
import org.apache.logging.log4j.core.config.ConfigurationScheduler;
import org.apache.logging.log4j.core.util.FileWatcher;
import org.apache.logging.log4j.core.util.Source;
import org.apache.logging.log4j.core.util.WatchEventService;
import org.apache.logging.log4j.core.util.WatchManager$ConfigurationMonitor;
import org.apache.logging.log4j.core.util.WatchManager$LocalUUID;
import org.apache.logging.log4j.core.util.WatchManager$WatchRunnable;
import org.apache.logging.log4j.core.util.Watcher;
import org.apache.logging.log4j.core.util.WrappedFileWatcher;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.ServiceLoaderUtil;

public class WatchManager
extends AbstractLifeCycle {
    private static Logger logger = StatusLogger.getLogger();
    private final ConcurrentMap<Source, WatchManager$ConfigurationMonitor> watchers = new ConcurrentHashMap<Source, WatchManager$ConfigurationMonitor>();
    private int intervalSeconds = 0;
    private ScheduledFuture<?> future;
    private final ConfigurationScheduler scheduler;
    private final List<WatchEventService> eventServiceList;
    private final UUID id = WatchManager$LocalUUID.get();

    public WatchManager(ConfigurationScheduler configurationScheduler) {
        this.scheduler = Objects.requireNonNull(configurationScheduler, "scheduler");
        this.eventServiceList = ServiceLoaderUtil.loadServices(WatchEventService.class, MethodHandles.lookup(), true).collect(Collectors.toList());
    }

    public void checkFiles() {
        new WatchManager$WatchRunnable(this, null).run();
    }

    public Map<Source, Watcher> getConfigurationWatchers() {
        HashMap<Source, Watcher> hashMap = new HashMap<Source, Watcher>(this.watchers.size());
        for (Map.Entry entry : this.watchers.entrySet()) {
            hashMap.put((Source)entry.getKey(), ((WatchManager$ConfigurationMonitor)entry.getValue()).getWatcher());
        }
        return hashMap;
    }

    public UUID getId() {
        return this.id;
    }

    public int getIntervalSeconds() {
        return this.intervalSeconds;
    }

    @Deprecated
    public Map<File, FileWatcher> getWatchers() {
        HashMap<File, FileWatcher> hashMap = new HashMap<File, FileWatcher>(this.watchers.size());
        for (Map.Entry entry : this.watchers.entrySet()) {
            if (((WatchManager$ConfigurationMonitor)entry.getValue()).getWatcher() instanceof ConfigurationFileWatcher) {
                hashMap.put(((Source)entry.getKey()).getFile(), (FileWatcher)((Object)((WatchManager$ConfigurationMonitor)entry.getValue()).getWatcher()));
                continue;
            }
            hashMap.put(((Source)entry.getKey()).getFile(), new WrappedFileWatcher((FileWatcher)((Object)((WatchManager$ConfigurationMonitor)entry.getValue()).getWatcher())));
        }
        return hashMap;
    }

    public boolean hasEventListeners() {
        return this.eventServiceList.size() > 0;
    }

    private String millisToString(long l) {
        return new Date(l).toString();
    }

    public void reset() {
        logger.debug("Resetting {}", (Object)this);
        for (Source source : this.watchers.keySet()) {
            this.reset(source);
        }
    }

    public void reset(File file) {
        if (file == null) {
            return;
        }
        Source source = new Source(file);
        this.reset(source);
    }

    public void reset(Source source) {
        Watcher watcher;
        if (source == null) {
            return;
        }
        WatchManager$ConfigurationMonitor watchManager$ConfigurationMonitor = (WatchManager$ConfigurationMonitor)this.watchers.get(source);
        if (watchManager$ConfigurationMonitor != null && (watcher = watchManager$ConfigurationMonitor.getWatcher()).isModified()) {
            long l = watcher.getLastModified();
            if (logger.isDebugEnabled()) {
                logger.debug("Resetting file monitor for '{}' from {} ({}) to {} ({})", (Object)source.getLocation(), (Object)this.millisToString(WatchManager$ConfigurationMonitor.access$300(watchManager$ConfigurationMonitor)), (Object)WatchManager$ConfigurationMonitor.access$300(watchManager$ConfigurationMonitor), (Object)this.millisToString(l), (Object)l);
            }
            WatchManager$ConfigurationMonitor.access$500(watchManager$ConfigurationMonitor, l);
        }
    }

    public void setIntervalSeconds(int n) {
        if (!this.isStarted()) {
            if (this.intervalSeconds > 0 && n == 0) {
                this.scheduler.decrementScheduledItems();
            } else if (this.intervalSeconds == 0 && n > 0) {
                this.scheduler.incrementScheduledItems();
            }
            this.intervalSeconds = n;
        }
    }

    @Override
    public void start() {
        super.start();
        if (this.intervalSeconds > 0) {
            this.future = this.scheduler.scheduleWithFixedDelay(new WatchManager$WatchRunnable(this, null), this.intervalSeconds, this.intervalSeconds, TimeUnit.SECONDS);
        }
        for (WatchEventService watchEventService : this.eventServiceList) {
            watchEventService.subscribe(this);
        }
    }

    @Override
    public boolean stop(long l, TimeUnit timeUnit) {
        this.setStopping();
        for (WatchEventService watchEventService : this.eventServiceList) {
            watchEventService.unsubscribe(this);
        }
        boolean bl = this.stop(this.future);
        this.setStopped();
        return bl;
    }

    public String toString() {
        return "WatchManager [intervalSeconds=" + this.intervalSeconds + ", watchers=" + this.watchers + ", scheduler=" + this.scheduler + ", future=" + this.future + "]";
    }

    public void unwatch(Source source) {
        logger.debug("Unwatching configuration {}", (Object)source);
        this.watchers.remove(source);
    }

    public void unwatchFile(File file) {
        Source source = new Source(file);
        this.unwatch(source);
    }

    public void watch(Source source, Watcher watcher) {
        watcher.watching(source);
        long l = watcher.getLastModified();
        if (logger.isDebugEnabled()) {
            logger.debug("Watching configuration '{}' for lastModified {} ({})", (Object)source, (Object)this.millisToString(l), (Object)l);
        }
        this.watchers.put(source, new WatchManager$ConfigurationMonitor(this, l, watcher));
    }

    public void watchFile(File file, FileWatcher fileWatcher) {
        Watcher watcher = fileWatcher instanceof Watcher ? (Watcher)((Object)fileWatcher) : new WrappedFileWatcher(fileWatcher);
        Source source = new Source(file);
        this.watch(source, watcher);
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }

    static /* synthetic */ ConcurrentMap access$100(WatchManager watchManager) {
        return watchManager.watchers;
    }

    static /* synthetic */ String access$200(WatchManager watchManager, long l) {
        return watchManager.millisToString(l);
    }
}

