/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.tools.picocli;

import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.Callable;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$Assert;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$DefaultExceptionHandler;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$DuplicateOptionAnnotationsException;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$ExecutionException;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$Help;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$Help$Ansi;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$Help$Ansi$Text;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$Help$ColorScheme;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$IExceptionHandler;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$IParseResultHandler;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$ITypeConverter;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$Interpreter;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$Option;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$ParameterException;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$ParameterIndexGapException;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$Parameters;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$Range;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$RunLast;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$Tracer;

public class CommandLine {
    public static final String VERSION = "2.0.3";
    private final CommandLine$Tracer tracer = new CommandLine$Tracer(null);
    private final CommandLine$Interpreter interpreter;
    private String commandName = "<main class>";
    private boolean overwrittenOptionsAllowed = false;
    private boolean unmatchedArgumentsAllowed = false;
    private final List<String> unmatchedArguments = new ArrayList<String>();
    private CommandLine parent;
    private boolean usageHelpRequested;
    private boolean versionHelpRequested;
    private final List<String> versionLines = new ArrayList<String>();

    public CommandLine(Object object) {
        this.interpreter = new CommandLine$Interpreter(this, object);
    }

    public CommandLine addSubcommand(String string, Object object) {
        CommandLine commandLine = CommandLine.toCommandLine(object);
        commandLine.parent = this;
        CommandLine$Interpreter.access$100(this.interpreter).put(string, commandLine);
        return this;
    }

    public Map<String, CommandLine> getSubcommands() {
        return new LinkedHashMap<String, CommandLine>(CommandLine$Interpreter.access$100(this.interpreter));
    }

    public CommandLine getParent() {
        return this.parent;
    }

    public <T> T getCommand() {
        return (T)CommandLine$Interpreter.access$200(this.interpreter);
    }

    public boolean isUsageHelpRequested() {
        return this.usageHelpRequested;
    }

    public boolean isVersionHelpRequested() {
        return this.versionHelpRequested;
    }

    public boolean isOverwrittenOptionsAllowed() {
        return this.overwrittenOptionsAllowed;
    }

    public CommandLine setOverwrittenOptionsAllowed(boolean bl) {
        this.overwrittenOptionsAllowed = bl;
        for (CommandLine commandLine : CommandLine$Interpreter.access$100(this.interpreter).values()) {
            commandLine.setOverwrittenOptionsAllowed(bl);
        }
        return this;
    }

    public boolean isUnmatchedArgumentsAllowed() {
        return this.unmatchedArgumentsAllowed;
    }

    public CommandLine setUnmatchedArgumentsAllowed(boolean bl) {
        this.unmatchedArgumentsAllowed = bl;
        for (CommandLine commandLine : CommandLine$Interpreter.access$100(this.interpreter).values()) {
            commandLine.setUnmatchedArgumentsAllowed(bl);
        }
        return this;
    }

    public List<String> getUnmatchedArguments() {
        return this.unmatchedArguments;
    }

    public static <T> T populateCommand(T t, String ... stringArray) {
        CommandLine commandLine = CommandLine.toCommandLine(t);
        commandLine.parse(stringArray);
        return t;
    }

    public List<CommandLine> parse(String ... stringArray) {
        return this.interpreter.parse(stringArray);
    }

    public static boolean printHelpIfRequested(List<CommandLine> list, PrintStream printStream, CommandLine$Help$Ansi commandLine$Help$Ansi) {
        for (CommandLine commandLine : list) {
            if (commandLine.isUsageHelpRequested()) {
                commandLine.usage(printStream, commandLine$Help$Ansi);
                return true;
            }
            if (!commandLine.isVersionHelpRequested()) continue;
            commandLine.printVersionHelp(printStream, commandLine$Help$Ansi);
            return true;
        }
        return false;
    }

    private static Object execute(CommandLine commandLine) {
        Object t = commandLine.getCommand();
        if (t instanceof Runnable) {
            try {
                ((Runnable)t).run();
                return null;
            }
            catch (Exception exception) {
                throw new CommandLine$ExecutionException(commandLine, "Error while running command (" + t + ")", exception);
            }
        }
        if (t instanceof Callable) {
            try {
                return ((Callable)t).call();
            }
            catch (Exception exception) {
                throw new CommandLine$ExecutionException(commandLine, "Error while calling command (" + t + ")", exception);
            }
        }
        throw new CommandLine$ExecutionException(commandLine, "Parsed command (" + t + ") is not Runnable or Callable");
    }

    public List<Object> parseWithHandler(CommandLine$IParseResultHandler commandLine$IParseResultHandler, PrintStream printStream, String ... stringArray) {
        return this.parseWithHandlers(commandLine$IParseResultHandler, printStream, CommandLine$Help$Ansi.AUTO, new CommandLine$DefaultExceptionHandler(), stringArray);
    }

    public List<Object> parseWithHandlers(CommandLine$IParseResultHandler commandLine$IParseResultHandler, PrintStream printStream, CommandLine$Help$Ansi commandLine$Help$Ansi, CommandLine$IExceptionHandler commandLine$IExceptionHandler, String ... stringArray) {
        try {
            List<CommandLine> list = this.parse(stringArray);
            return commandLine$IParseResultHandler.handleParseResult(list, printStream, commandLine$Help$Ansi);
        }
        catch (CommandLine$ParameterException commandLine$ParameterException) {
            return commandLine$IExceptionHandler.handleException(commandLine$ParameterException, printStream, commandLine$Help$Ansi, stringArray);
        }
    }

    public static void usage(Object object, PrintStream printStream) {
        CommandLine.toCommandLine(object).usage(printStream);
    }

    public static void usage(Object object, PrintStream printStream, CommandLine$Help$Ansi commandLine$Help$Ansi) {
        CommandLine.toCommandLine(object).usage(printStream, commandLine$Help$Ansi);
    }

    public static void usage(Object object, PrintStream printStream, CommandLine$Help$ColorScheme commandLine$Help$ColorScheme) {
        CommandLine.toCommandLine(object).usage(printStream, commandLine$Help$ColorScheme);
    }

    public void usage(PrintStream printStream) {
        this.usage(printStream, CommandLine$Help$Ansi.AUTO);
    }

    public void usage(PrintStream printStream, CommandLine$Help$Ansi commandLine$Help$Ansi) {
        this.usage(printStream, CommandLine$Help.defaultColorScheme(commandLine$Help$Ansi));
    }

    public void usage(PrintStream printStream, CommandLine$Help$ColorScheme commandLine$Help$ColorScheme) {
        CommandLine$Help commandLine$Help = new CommandLine$Help(CommandLine$Interpreter.access$200(this.interpreter), commandLine$Help$ColorScheme).addAllSubcommands(this.getSubcommands());
        if (!"=".equals(this.getSeparator())) {
            commandLine$Help.separator = this.getSeparator();
            commandLine$Help.parameterLabelRenderer = commandLine$Help.createDefaultParamLabelRenderer();
        }
        if (!"<main class>".equals(this.getCommandName())) {
            commandLine$Help.commandName = this.getCommandName();
        }
        StringBuilder stringBuilder = new StringBuilder().append(commandLine$Help.headerHeading(new Object[0])).append(commandLine$Help.header(new Object[0])).append(commandLine$Help.synopsisHeading(new Object[0])).append(commandLine$Help.synopsis(commandLine$Help.synopsisHeadingLength())).append(commandLine$Help.descriptionHeading(new Object[0])).append(commandLine$Help.description(new Object[0])).append(commandLine$Help.parameterListHeading(new Object[0])).append(commandLine$Help.parameterList()).append(commandLine$Help.optionListHeading(new Object[0])).append(commandLine$Help.optionList()).append(commandLine$Help.commandListHeading(new Object[0])).append(commandLine$Help.commandList()).append(commandLine$Help.footerHeading(new Object[0])).append(commandLine$Help.footer(new Object[0]));
        printStream.print(stringBuilder);
    }

    public void printVersionHelp(PrintStream printStream) {
        this.printVersionHelp(printStream, CommandLine$Help$Ansi.AUTO);
    }

    public void printVersionHelp(PrintStream printStream, CommandLine$Help$Ansi commandLine$Help$Ansi) {
        for (String string : this.versionLines) {
            CommandLine$Help$Ansi commandLine$Help$Ansi2 = commandLine$Help$Ansi;
            ((Object)((Object)commandLine$Help$Ansi2)).getClass();
            printStream.println(new CommandLine$Help$Ansi$Text(commandLine$Help$Ansi2, string));
        }
    }

    public void printVersionHelp(PrintStream printStream, CommandLine$Help$Ansi commandLine$Help$Ansi, Object ... objectArray) {
        for (String string : this.versionLines) {
            CommandLine$Help$Ansi commandLine$Help$Ansi2 = commandLine$Help$Ansi;
            ((Object)((Object)commandLine$Help$Ansi2)).getClass();
            printStream.println(new CommandLine$Help$Ansi$Text(commandLine$Help$Ansi2, String.format(string, objectArray)));
        }
    }

    public static <C extends Callable<T>, T> T call(C c, PrintStream printStream, String ... stringArray) {
        return CommandLine.call(c, printStream, CommandLine$Help$Ansi.AUTO, stringArray);
    }

    public static <C extends Callable<T>, T> T call(C c, PrintStream printStream, CommandLine$Help$Ansi commandLine$Help$Ansi, String ... stringArray) {
        CommandLine commandLine = new CommandLine(c);
        List<Object> list = commandLine.parseWithHandlers(new CommandLine$RunLast(), printStream, commandLine$Help$Ansi, new CommandLine$DefaultExceptionHandler(), stringArray);
        return (T)(list == null || list.isEmpty() ? null : list.get(0));
    }

    public static <R extends Runnable> void run(R r, PrintStream printStream, String ... stringArray) {
        CommandLine.run(r, printStream, CommandLine$Help$Ansi.AUTO, stringArray);
    }

    public static <R extends Runnable> void run(R r, PrintStream printStream, CommandLine$Help$Ansi commandLine$Help$Ansi, String ... stringArray) {
        CommandLine commandLine = new CommandLine(r);
        commandLine.parseWithHandlers(new CommandLine$RunLast(), printStream, commandLine$Help$Ansi, new CommandLine$DefaultExceptionHandler(), stringArray);
    }

    public <K> CommandLine registerConverter(Class<K> clazz, CommandLine$ITypeConverter<K> commandLine$ITypeConverter) {
        CommandLine$Interpreter.access$400(this.interpreter).put(CommandLine$Assert.notNull(clazz, "class"), CommandLine$Assert.notNull(commandLine$ITypeConverter, "converter"));
        for (CommandLine commandLine : CommandLine$Interpreter.access$100(this.interpreter).values()) {
            commandLine.registerConverter(clazz, commandLine$ITypeConverter);
        }
        return this;
    }

    public String getSeparator() {
        return CommandLine$Interpreter.access$500(this.interpreter);
    }

    public CommandLine setSeparator(String string) {
        CommandLine$Interpreter.access$502(this.interpreter, CommandLine$Assert.notNull(string, "separator"));
        return this;
    }

    public String getCommandName() {
        return this.commandName;
    }

    public CommandLine setCommandName(String string) {
        this.commandName = CommandLine$Assert.notNull(string, "commandName");
        return this;
    }

    private static boolean empty(String string) {
        return string == null || string.trim().length() == 0;
    }

    private static boolean empty(Object[] objectArray) {
        return objectArray == null || objectArray.length == 0;
    }

    private static boolean empty(CommandLine$Help$Ansi$Text commandLine$Help$Ansi$Text) {
        return commandLine$Help$Ansi$Text == null || CommandLine$Help$Ansi$Text.access$600(commandLine$Help$Ansi$Text).toString().trim().length() == 0;
    }

    private static String str(String[] stringArray, int n) {
        return stringArray == null || stringArray.length == 0 ? "" : stringArray[n];
    }

    private static boolean isBoolean(Class<?> clazz) {
        return clazz == Boolean.class || clazz == Boolean.TYPE;
    }

    private static CommandLine toCommandLine(Object object) {
        return object instanceof CommandLine ? (CommandLine)object : new CommandLine(object);
    }

    private static boolean isMultiValue(Field field) {
        return CommandLine.isMultiValue(field.getType());
    }

    private static boolean isMultiValue(Class<?> clazz) {
        return clazz.isArray() || Collection.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz);
    }

    private static Class<?>[] getTypeAttribute(Field field) {
        Class<?>[] classArray;
        Class<?>[] classArray2 = classArray = field.isAnnotationPresent(CommandLine$Parameters.class) ? field.getAnnotation(CommandLine$Parameters.class).type() : field.getAnnotation(CommandLine$Option.class).type();
        if (classArray.length > 0) {
            return classArray;
        }
        if (field.getType().isArray()) {
            return new Class[]{field.getType().getComponentType()};
        }
        if (CommandLine.isMultiValue(field)) {
            Type type = field.getGenericType();
            if (type instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                Type[] typeArray = parameterizedType.getActualTypeArguments();
                Object[] objectArray = new Class[typeArray.length];
                for (int i = 0; i < typeArray.length; ++i) {
                    if (typeArray[i] instanceof Class) {
                        objectArray[i] = (Class)typeArray[i];
                        continue;
                    }
                    if (typeArray[i] instanceof WildcardType) {
                        WildcardType wildcardType = (WildcardType)typeArray[i];
                        Type[] typeArray2 = wildcardType.getLowerBounds();
                        if (typeArray2.length > 0 && typeArray2[0] instanceof Class) {
                            objectArray[i] = (Class)typeArray2[0];
                            continue;
                        }
                        Type[] typeArray3 = wildcardType.getUpperBounds();
                        if (typeArray3.length > 0 && typeArray3[0] instanceof Class) {
                            objectArray[i] = (Class)typeArray3[0];
                            continue;
                        }
                    }
                    Arrays.fill(objectArray, String.class);
                    return objectArray;
                }
                return objectArray;
            }
            return new Class[]{String.class, String.class};
        }
        return new Class[]{field.getType()};
    }

    static void init(Class<?> clazz, List<Field> list, Map<String, Field> map, Map<Character, Field> map2, List<Field> list2) {
        Field[] fieldArray;
        for (Field field : fieldArray = clazz.getDeclaredFields()) {
            Object object;
            field.setAccessible(true);
            if (field.isAnnotationPresent(CommandLine$Option.class)) {
                object = field.getAnnotation(CommandLine$Option.class);
                if (object.required()) {
                    list.add(field);
                }
                for (String string : object.names()) {
                    char c;
                    Field field2;
                    Field field3 = map.put(string, field);
                    if (field3 != null && field3 != field) {
                        throw CommandLine$DuplicateOptionAnnotationsException.access$1000(string, field, field3);
                    }
                    if (string.length() != 2 || !string.startsWith("-") || (field2 = map2.put(Character.valueOf(c = string.charAt(1)), field)) == null || field2 == field) continue;
                    throw CommandLine$DuplicateOptionAnnotationsException.access$1000(string, field, field2);
                }
            }
            if (!field.isAnnotationPresent(CommandLine$Parameters.class)) continue;
            if (field.isAnnotationPresent(CommandLine$Option.class)) {
                throw new CommandLine$DuplicateOptionAnnotationsException("A field can be either @Option or @Parameters, but '" + field.getName() + "' is both.");
            }
            list2.add(field);
            object = CommandLine$Range.parameterArity(field);
            if (((CommandLine$Range)object).min <= 0) continue;
            list.add(field);
        }
    }

    static void validatePositionalParameters(List<Field> list) {
        int n = 0;
        for (Field field : list) {
            CommandLine$Range commandLine$Range = CommandLine$Range.parameterIndex(field);
            if (commandLine$Range.min > n) {
                throw new CommandLine$ParameterIndexGapException("Missing field annotated with @Parameter(index=" + n + "). Nearest field '" + field.getName() + "' has index=" + commandLine$Range.min);
            }
            n = (n = Math.max(n, commandLine$Range.max)) == Integer.MAX_VALUE ? n : n + 1;
        }
    }

    private static <T> Stack<T> reverse(Stack<T> stack) {
        Collections.reverse(stack);
        return stack;
    }

    static /* synthetic */ Object access$300(CommandLine commandLine) {
        return CommandLine.execute(commandLine);
    }

    static /* synthetic */ boolean access$700(Class clazz) {
        return CommandLine.isMultiValue(clazz);
    }

    static /* synthetic */ boolean access$800(Class clazz) {
        return CommandLine.isBoolean(clazz);
    }

    static /* synthetic */ boolean access$900(Field field) {
        return CommandLine.isMultiValue(field);
    }

    static /* synthetic */ List access$1100(CommandLine commandLine) {
        return commandLine.versionLines;
    }

    static /* synthetic */ CommandLine access$1200(Object object) {
        return CommandLine.toCommandLine(object);
    }

    static /* synthetic */ CommandLine access$1302(CommandLine commandLine, CommandLine commandLine2) {
        commandLine.parent = commandLine2;
        return commandLine.parent;
    }

    static /* synthetic */ String access$1402(CommandLine commandLine, String string) {
        commandLine.commandName = string;
        return commandLine.commandName;
    }

    static /* synthetic */ String access$1400(CommandLine commandLine) {
        return commandLine.commandName;
    }

    static /* synthetic */ CommandLine$Tracer access$1600(CommandLine commandLine) {
        return commandLine.tracer;
    }

    static /* synthetic */ boolean access$1702(CommandLine commandLine, boolean bl) {
        commandLine.versionHelpRequested = bl;
        return commandLine.versionHelpRequested;
    }

    static /* synthetic */ boolean access$1802(CommandLine commandLine, boolean bl) {
        commandLine.usageHelpRequested = bl;
        return commandLine.usageHelpRequested;
    }

    static /* synthetic */ List access$2100(CommandLine commandLine) {
        return commandLine.unmatchedArguments;
    }

    static /* synthetic */ Stack access$2200(Stack stack) {
        return CommandLine.reverse(stack);
    }

    static /* synthetic */ CommandLine$Interpreter access$2300(CommandLine commandLine) {
        return commandLine.interpreter;
    }

    static /* synthetic */ boolean access$2400(String string) {
        return CommandLine.empty(string);
    }

    static /* synthetic */ Class[] access$2500(Field field) {
        return CommandLine.getTypeAttribute(field);
    }

    static /* synthetic */ boolean access$1700(CommandLine commandLine) {
        return commandLine.versionHelpRequested;
    }

    static /* synthetic */ boolean access$1800(CommandLine commandLine) {
        return commandLine.usageHelpRequested;
    }

    static /* synthetic */ boolean access$2700(Object[] objectArray) {
        return CommandLine.empty(objectArray);
    }

    static /* synthetic */ String access$3200(String[] stringArray, int n) {
        return CommandLine.str(stringArray, n);
    }
}

