/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.tools.picocli;

import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.logging.log4j.core.tools.picocli.CommandLine;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$Assert;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$BuiltIn$BigDecimalConverter;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$BuiltIn$BigIntegerConverter;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$BuiltIn$BooleanConverter;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$BuiltIn$ByteConverter;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$BuiltIn$CharSequenceConverter;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$BuiltIn$CharacterConverter;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$BuiltIn$CharsetConverter;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$BuiltIn$DoubleConverter;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$BuiltIn$FileConverter;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$BuiltIn$FloatConverter;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$BuiltIn$ISO8601DateConverter;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$BuiltIn$ISO8601TimeConverter;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$BuiltIn$InetAddressConverter;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$BuiltIn$IntegerConverter;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$BuiltIn$LongConverter;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$BuiltIn$PathConverter;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$BuiltIn$PatternConverter;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$BuiltIn$ShortConverter;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$BuiltIn$StringBuilderConverter;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$BuiltIn$StringConverter;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$BuiltIn$URIConverter;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$BuiltIn$URLConverter;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$BuiltIn$UUIDConverter;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$Command;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$Help;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$Help$Ansi;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$Help$Ansi$Text;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$Help$IParamLabelRenderer;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$ITypeConverter;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$InitializationException;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$Interpreter$1;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$MaxValuesforFieldExceededException;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$MissingParameterException;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$MissingTypeConverterException;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$Option;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$OverwrittenOptionException;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$ParameterException;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$Parameters;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$PositionalParametersSorter;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$Range;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$TraceLevel;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$TypeConversionException;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$UnmatchedArgumentException;

class CommandLine$Interpreter {
    private final Map<String, CommandLine> commands = new LinkedHashMap<String, CommandLine>();
    private final Map<Class<?>, CommandLine$ITypeConverter<?>> converterRegistry = new HashMap();
    private final Map<String, Field> optionName2Field = new HashMap<String, Field>();
    private final Map<Character, Field> singleCharOption2Field = new HashMap<Character, Field>();
    private final List<Field> requiredFields = new ArrayList<Field>();
    private final List<Field> positionalParametersFields = new ArrayList<Field>();
    private final Object command;
    private boolean isHelpRequested;
    private String separator = "=";
    private int position;
    final /* synthetic */ CommandLine this$0;

    CommandLine$Interpreter(CommandLine commandLine, Object object) {
        this.this$0 = commandLine;
        this.converterRegistry.put(Path.class, new CommandLine$BuiltIn$PathConverter());
        this.converterRegistry.put(Object.class, new CommandLine$BuiltIn$StringConverter());
        this.converterRegistry.put(String.class, new CommandLine$BuiltIn$StringConverter());
        this.converterRegistry.put(StringBuilder.class, new CommandLine$BuiltIn$StringBuilderConverter());
        this.converterRegistry.put(CharSequence.class, new CommandLine$BuiltIn$CharSequenceConverter());
        this.converterRegistry.put(Byte.class, new CommandLine$BuiltIn$ByteConverter());
        this.converterRegistry.put(Byte.TYPE, new CommandLine$BuiltIn$ByteConverter());
        this.converterRegistry.put(Boolean.class, new CommandLine$BuiltIn$BooleanConverter());
        this.converterRegistry.put(Boolean.TYPE, new CommandLine$BuiltIn$BooleanConverter());
        this.converterRegistry.put(Character.class, new CommandLine$BuiltIn$CharacterConverter());
        this.converterRegistry.put(Character.TYPE, new CommandLine$BuiltIn$CharacterConverter());
        this.converterRegistry.put(Short.class, new CommandLine$BuiltIn$ShortConverter());
        this.converterRegistry.put(Short.TYPE, new CommandLine$BuiltIn$ShortConverter());
        this.converterRegistry.put(Integer.class, new CommandLine$BuiltIn$IntegerConverter());
        this.converterRegistry.put(Integer.TYPE, new CommandLine$BuiltIn$IntegerConverter());
        this.converterRegistry.put(Long.class, new CommandLine$BuiltIn$LongConverter());
        this.converterRegistry.put(Long.TYPE, new CommandLine$BuiltIn$LongConverter());
        this.converterRegistry.put(Float.class, new CommandLine$BuiltIn$FloatConverter());
        this.converterRegistry.put(Float.TYPE, new CommandLine$BuiltIn$FloatConverter());
        this.converterRegistry.put(Double.class, new CommandLine$BuiltIn$DoubleConverter());
        this.converterRegistry.put(Double.TYPE, new CommandLine$BuiltIn$DoubleConverter());
        this.converterRegistry.put(File.class, new CommandLine$BuiltIn$FileConverter());
        this.converterRegistry.put(URI.class, new CommandLine$BuiltIn$URIConverter());
        this.converterRegistry.put(URL.class, new CommandLine$BuiltIn$URLConverter());
        this.converterRegistry.put(Date.class, new CommandLine$BuiltIn$ISO8601DateConverter());
        this.converterRegistry.put(Time.class, new CommandLine$BuiltIn$ISO8601TimeConverter());
        this.converterRegistry.put(BigDecimal.class, new CommandLine$BuiltIn$BigDecimalConverter());
        this.converterRegistry.put(BigInteger.class, new CommandLine$BuiltIn$BigIntegerConverter());
        this.converterRegistry.put(Charset.class, new CommandLine$BuiltIn$CharsetConverter());
        this.converterRegistry.put(InetAddress.class, new CommandLine$BuiltIn$InetAddressConverter());
        this.converterRegistry.put(Pattern.class, new CommandLine$BuiltIn$PatternConverter());
        this.converterRegistry.put(UUID.class, new CommandLine$BuiltIn$UUIDConverter());
        this.command = CommandLine$Assert.notNull(object, "command");
        String string = null;
        String string2 = null;
        boolean bl = false;
        for (Class<?> clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            CommandLine.init(clazz, this.requiredFields, this.optionName2Field, this.singleCharOption2Field, this.positionalParametersFields);
            if (!clazz.isAnnotationPresent(CommandLine$Command.class)) continue;
            bl = true;
            CommandLine$Command commandLine$Command = clazz.getAnnotation(CommandLine$Command.class);
            string2 = string2 == null ? commandLine$Command.separator() : string2;
            string = string == null ? commandLine$Command.name() : string;
            CommandLine.access$1100(commandLine).addAll(Arrays.asList(commandLine$Command.version()));
            for (Class<?> clazz2 : commandLine$Command.subcommands()) {
                CommandLine$Command commandLine$Command2 = clazz2.getAnnotation(CommandLine$Command.class);
                if (commandLine$Command2 == null || "<main class>".equals(commandLine$Command2.name())) {
                    throw new CommandLine$InitializationException("Subcommand " + clazz2.getName() + " is missing the mandatory @Command annotation with a 'name' attribute");
                }
                try {
                    Constructor<?> constructor = clazz2.getDeclaredConstructor(new Class[0]);
                    constructor.setAccessible(true);
                    CommandLine commandLine2 = CommandLine.access$1200(constructor.newInstance(new Object[0]));
                    CommandLine.access$1302(commandLine2, commandLine);
                    this.commands.put(commandLine$Command2.name(), commandLine2);
                }
                catch (CommandLine$InitializationException commandLine$InitializationException) {
                    throw commandLine$InitializationException;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new CommandLine$InitializationException("Cannot instantiate subcommand " + clazz2.getName() + ": the class has no constructor", noSuchMethodException);
                }
                catch (Exception exception) {
                    throw new CommandLine$InitializationException("Could not instantiate and add subcommand " + clazz2.getName() + ": " + exception, exception);
                }
            }
        }
        this.separator = string2 != null ? string2 : this.separator;
        CommandLine.access$1402(commandLine, string != null ? string : CommandLine.access$1400(commandLine));
        Collections.sort(this.positionalParametersFields, new CommandLine$PositionalParametersSorter(null));
        CommandLine.validatePositionalParameters(this.positionalParametersFields);
        if (this.positionalParametersFields.isEmpty() && this.optionName2Field.isEmpty() && !bl) {
            throw new CommandLine$InitializationException(object + " (" + object.getClass() + ") is not a command: it has no @Command, @Option or @Parameters annotations");
        }
    }

    List<CommandLine> parse(String ... stringArray) {
        CommandLine$Assert.notNull(stringArray, "argument array");
        if (CommandLine.access$1600(this.this$0).isInfo()) {
            CommandLine.access$1600(this.this$0).info("Parsing %d command line args %s%n", stringArray.length, Arrays.toString(stringArray));
        }
        Stack<String> stack = new Stack<String>();
        for (int i = stringArray.length - 1; i >= 0; --i) {
            stack.push(stringArray[i]);
        }
        ArrayList<CommandLine> arrayList = new ArrayList<CommandLine>();
        this.parse(arrayList, stack, stringArray);
        return arrayList;
    }

    private void parse(List<CommandLine> list, Stack<String> stack, String[] stringArray) {
        this.isHelpRequested = false;
        CommandLine.access$1702(this.this$0, false);
        CommandLine.access$1802(this.this$0, false);
        Class<?> clazz = this.command.getClass();
        if (CommandLine.access$1600(this.this$0).isDebug()) {
            CommandLine.access$1600(this.this$0).debug("Initializing %s: %d options, %d positional parameters, %d required, %d subcommands.%n", clazz.getName(), new HashSet<Field>(this.optionName2Field.values()).size(), this.positionalParametersFields.size(), this.requiredFields.size(), this.commands.size());
        }
        list.add(this.this$0);
        ArrayList<Field> arrayList = new ArrayList<Field>(this.requiredFields);
        HashSet<Field> hashSet = new HashSet<Field>();
        Collections.sort(arrayList, new CommandLine$PositionalParametersSorter(null));
        try {
            this.processArguments(list, stack, arrayList, hashSet, stringArray);
        }
        catch (CommandLine$ParameterException commandLine$ParameterException) {
            throw commandLine$ParameterException;
        }
        catch (Exception exception) {
            int n = stringArray.length - stack.size() - 1;
            String string = n >= 0 && n < stringArray.length ? stringArray[n] : "?";
            throw CommandLine$ParameterException.access$1900(this.this$0, exception, string, n, stringArray);
        }
        if (!this.isAnyHelpRequested() && !arrayList.isEmpty()) {
            for (Field field : arrayList) {
                if (field.isAnnotationPresent(CommandLine$Option.class)) {
                    throw CommandLine$MissingParameterException.access$2000(this.this$0, arrayList, this.separator);
                }
                this.assertNoMissingParameters(field, CommandLine$Range.parameterArity((Field)field).min, stack);
            }
        }
        if (!CommandLine.access$2100(this.this$0).isEmpty()) {
            if (!this.this$0.isUnmatchedArgumentsAllowed()) {
                throw new CommandLine$UnmatchedArgumentException(this.this$0, CommandLine.access$2100(this.this$0));
            }
            if (CommandLine.access$1600(this.this$0).isWarn()) {
                CommandLine.access$1600(this.this$0).warn("Unmatched arguments: %s%n", CommandLine.access$2100(this.this$0));
            }
        }
    }

    private void processArguments(List<CommandLine> list, Stack<String> stack, Collection<Field> collection, Set<Field> set, String[] stringArray) {
        while (!stack.isEmpty()) {
            String string = stack.pop();
            if (CommandLine.access$1600(this.this$0).isDebug()) {
                CommandLine.access$1600(this.this$0).debug("Processing argument '%s'. Remainder=%s%n", string, CommandLine.access$2200((Stack)stack.clone()));
            }
            if ("--".equals(string)) {
                CommandLine.access$1600(this.this$0).info("Found end-of-options delimiter '--'. Treating remainder as positional parameters.%n", new Object[0]);
                this.processRemainderAsPositionalParameters(collection, set, stack);
                return;
            }
            if (this.commands.containsKey(string)) {
                if (!this.isHelpRequested && !collection.isEmpty()) {
                    throw CommandLine$MissingParameterException.access$2000(this.this$0, collection, this.separator);
                }
                if (CommandLine.access$1600(this.this$0).isDebug()) {
                    CommandLine.access$1600(this.this$0).debug("Found subcommand '%s' (%s)%n", string, CommandLine.access$2300((CommandLine)this.commands.get((Object)string)).command.getClass().getName());
                }
                CommandLine.access$2300(this.commands.get(string)).parse(list, stack, stringArray);
                return;
            }
            boolean bl = false;
            int n = string.indexOf(this.separator);
            if (n > 0) {
                String string2 = string.substring(0, n);
                if (this.optionName2Field.containsKey(string2) && !this.optionName2Field.containsKey(string)) {
                    bl = true;
                    String string3 = string.substring(n + this.separator.length());
                    stack.push(string3);
                    string = string2;
                    if (CommandLine.access$1600(this.this$0).isDebug()) {
                        CommandLine.access$1600(this.this$0).debug("Separated '%s' option from '%s' option parameter%n", string2, string3);
                    }
                } else if (CommandLine.access$1600(this.this$0).isDebug()) {
                    CommandLine.access$1600(this.this$0).debug("'%s' contains separator '%s' but '%s' is not a known option%n", string, this.separator, string2);
                }
            } else if (CommandLine.access$1600(this.this$0).isDebug()) {
                CommandLine.access$1600(this.this$0).debug("'%s' cannot be separated into <option>%s<option-parameter>%n", string, this.separator);
            }
            if (this.optionName2Field.containsKey(string)) {
                this.processStandaloneOption(collection, set, string, stack, bl);
                continue;
            }
            if (string.length() > 2 && string.startsWith("-")) {
                if (CommandLine.access$1600(this.this$0).isDebug()) {
                    CommandLine.access$1600(this.this$0).debug("Trying to process '%s' as clustered short options%n", string, stack);
                }
                this.processClusteredShortOptions(collection, set, string, stack);
                continue;
            }
            stack.push(string);
            if (CommandLine.access$1600(this.this$0).isDebug()) {
                CommandLine.access$1600(this.this$0).debug("Could not find option '%s', deciding whether to treat as unmatched option or positional parameter...%n", string);
            }
            if (this.resemblesOption(string)) {
                this.handleUnmatchedArguments(stack.pop());
                continue;
            }
            if (CommandLine.access$1600(this.this$0).isDebug()) {
                CommandLine.access$1600(this.this$0).debug("No option named '%s' found. Processing remainder as positional parameters%n", string);
            }
            this.processPositionalParameter(collection, set, stack);
        }
    }

    private boolean resemblesOption(String string) {
        boolean bl;
        int n = 0;
        for (String string2 : this.optionName2Field.keySet()) {
            for (int i = 0; i < string.length() && string2.length() > i && string.charAt(i) == string2.charAt(i); ++i) {
                ++n;
            }
        }
        boolean bl2 = bl = n > 0 && n * 10 >= this.optionName2Field.size() * 9;
        if (CommandLine.access$1600(this.this$0).isDebug()) {
            CommandLine.access$1600(this.this$0).debug("%s %s an option: %d matching prefix chars out of %d option names%n", string, bl ? "resembles" : "doesn't resemble", n, this.optionName2Field.size());
        }
        return bl;
    }

    private void handleUnmatchedArguments(String string) {
        Stack<String> stack = new Stack<String>();
        stack.add(string);
        this.handleUnmatchedArguments(stack);
    }

    private void handleUnmatchedArguments(Stack<String> stack) {
        while (!stack.isEmpty()) {
            CommandLine.access$2100(this.this$0).add(stack.pop());
        }
    }

    private void processRemainderAsPositionalParameters(Collection<Field> collection, Set<Field> set, Stack<String> stack) {
        while (!stack.empty()) {
            this.processPositionalParameter(collection, set, stack);
        }
    }

    private void processPositionalParameter(Collection<Field> collection, Set<Field> set, Stack<String> stack) {
        if (CommandLine.access$1600(this.this$0).isDebug()) {
            CommandLine.access$1600(this.this$0).debug("Processing next arg as a positional parameter at index=%d. Remainder=%s%n", this.position, CommandLine.access$2200((Stack)stack.clone()));
        }
        int n = 0;
        for (Field field : this.positionalParametersFields) {
            CommandLine$Range commandLine$Range = CommandLine$Range.parameterIndex(field);
            if (!commandLine$Range.contains(this.position)) continue;
            Stack stack2 = (Stack)stack.clone();
            CommandLine$Range commandLine$Range2 = CommandLine$Range.parameterArity(field);
            if (CommandLine.access$1600(this.this$0).isDebug()) {
                CommandLine.access$1600(this.this$0).debug("Position %d is in index range %s. Trying to assign args to %s, arity=%s%n", this.position, commandLine$Range, field, commandLine$Range2);
            }
            this.assertNoMissingParameters(field, commandLine$Range2.min, stack2);
            int n2 = stack2.size();
            this.applyOption(field, CommandLine$Parameters.class, commandLine$Range2, false, stack2, set, "args[" + commandLine$Range + "] at position " + this.position);
            int n3 = n2 - stack2.size();
            if (n3 > 0) {
                collection.remove(field);
            }
            n = Math.max(n, n3);
        }
        for (int i = 0; i < n; ++i) {
            stack.pop();
        }
        this.position += n;
        if (CommandLine.access$1600(this.this$0).isDebug()) {
            CommandLine.access$1600(this.this$0).debug("Consumed %d arguments, moving position to index %d.%n", n, this.position);
        }
        if (n == 0 && !stack.isEmpty()) {
            this.handleUnmatchedArguments(stack.pop());
        }
    }

    private void processStandaloneOption(Collection<Field> collection, Set<Field> set, String string, Stack<String> stack, boolean bl) {
        Field field = this.optionName2Field.get(string);
        collection.remove(field);
        CommandLine$Range commandLine$Range = CommandLine$Range.optionArity(field);
        if (bl) {
            commandLine$Range = commandLine$Range.min(Math.max(1, commandLine$Range.min));
        }
        if (CommandLine.access$1600(this.this$0).isDebug()) {
            CommandLine.access$1600(this.this$0).debug("Found option named '%s': field %s, arity=%s%n", string, field, commandLine$Range);
        }
        this.applyOption(field, CommandLine$Option.class, commandLine$Range, bl, stack, set, "option " + string);
    }

    private void processClusteredShortOptions(Collection<Field> collection, Set<Field> set, String string, Stack<String> stack) {
        String string2 = string.substring(0, 1);
        String string3 = string.substring(1);
        boolean bl = true;
        while (string3.length() > 0 && this.singleCharOption2Field.containsKey(Character.valueOf(string3.charAt(0)))) {
            Field field = this.singleCharOption2Field.get(Character.valueOf(string3.charAt(0)));
            CommandLine$Range commandLine$Range = CommandLine$Range.optionArity(field);
            String string4 = "option " + string2 + string3.charAt(0);
            if (CommandLine.access$1600(this.this$0).isDebug()) {
                CommandLine.access$1600(this.this$0).debug("Found option '%s%s' in %s: field %s, arity=%s%n", string2, Character.valueOf(string3.charAt(0)), string, field, commandLine$Range);
            }
            collection.remove(field);
            string3 = string3.length() > 0 ? string3.substring(1) : "";
            boolean bl2 = bl = string3.length() > 0;
            if (string3.startsWith(this.separator)) {
                string3 = string3.substring(this.separator.length());
                commandLine$Range = commandLine$Range.min(Math.max(1, commandLine$Range.min));
            }
            if (commandLine$Range.min > 0 && !CommandLine.access$2400(string3) && CommandLine.access$1600(this.this$0).isDebug()) {
                CommandLine.access$1600(this.this$0).debug("Trying to process '%s' as option parameter%n", string3);
            }
            if (!CommandLine.access$2400(string3)) {
                stack.push(string3);
            }
            int n = this.applyOption(field, CommandLine$Option.class, commandLine$Range, bl, stack, set, string4);
            if (CommandLine.access$2400(string3) || n > 0 || stack.isEmpty()) {
                return;
            }
            string3 = stack.pop();
        }
        if (string3.length() == 0) {
            return;
        }
        if (string.endsWith(string3)) {
            stack.push(bl ? string2 + string3 : string3);
            if (stack.peek().equals(string)) {
                if (CommandLine.access$1600(this.this$0).isDebug()) {
                    CommandLine.access$1600(this.this$0).debug("Could not match any short options in %s, deciding whether to treat as unmatched option or positional parameter...%n", string);
                }
                if (this.resemblesOption(string)) {
                    this.handleUnmatchedArguments(stack.pop());
                    return;
                }
                this.processPositionalParameter(collection, set, stack);
                return;
            }
            if (CommandLine.access$1600(this.this$0).isDebug()) {
                CommandLine.access$1600(this.this$0).debug("No option found for %s in %s%n", string3, string);
            }
            this.handleUnmatchedArguments(stack.pop());
        } else {
            stack.push(string3);
            if (CommandLine.access$1600(this.this$0).isDebug()) {
                CommandLine.access$1600(this.this$0).debug("%s is not an option parameter for %s%n", string3, string);
            }
            this.processPositionalParameter(collection, set, stack);
        }
    }

    private int applyOption(Field field, Class<?> clazz, CommandLine$Range commandLine$Range, boolean bl, Stack<String> stack, Set<Field> set, String string) {
        this.updateHelpRequested(field);
        int n = stack.size();
        this.assertNoMissingParameters(field, commandLine$Range.min, stack);
        Class clazz2 = field.getType();
        if (clazz2.isArray()) {
            return this.applyValuesToArrayField(field, clazz, commandLine$Range, stack, clazz2, string);
        }
        if (Collection.class.isAssignableFrom(clazz2)) {
            return this.applyValuesToCollectionField(field, clazz, commandLine$Range, stack, clazz2, string);
        }
        if (Map.class.isAssignableFrom(clazz2)) {
            return this.applyValuesToMapField(field, clazz, commandLine$Range, stack, clazz2, string);
        }
        clazz2 = CommandLine.access$2500(field)[0];
        return this.applyValueToSingleValuedField(field, commandLine$Range, stack, clazz2, set, string);
    }

    private int applyValueToSingleValuedField(Field field, CommandLine$Range commandLine$Range, Stack<String> stack, Class<?> clazz, Set<Field> set, String string) {
        Object object;
        boolean bl = stack.isEmpty();
        String string2 = stack.isEmpty() ? null : this.trim(stack.pop());
        int n = commandLine$Range.min;
        if ((clazz == Boolean.class || clazz == Boolean.TYPE) && commandLine$Range.min <= 0) {
            if (commandLine$Range.max > 0 && ("true".equalsIgnoreCase(string2) || "false".equalsIgnoreCase(string2))) {
                n = 1;
            } else {
                if (string2 != null) {
                    stack.push(string2);
                }
                string2 = String.valueOf((object = (Boolean)field.get(this.command)) == null ? true : !((Boolean)object).booleanValue());
            }
        }
        if (bl && string2 == null) {
            return 0;
        }
        object = this.getTypeConverter(clazz, field);
        Object object2 = this.tryConvert(field, -1, (CommandLine$ITypeConverter<?>)object, string2, clazz);
        Object object3 = field.get(this.command);
        CommandLine$TraceLevel commandLine$TraceLevel = CommandLine$TraceLevel.INFO;
        String string3 = "Setting %s field '%s.%s' to '%5$s' (was '%4$s') for %6$s%n";
        if (set != null) {
            if (set.contains(field)) {
                if (!this.this$0.isOverwrittenOptionsAllowed()) {
                    throw new CommandLine$OverwrittenOptionException(this.this$0, this.optionDescription("", field, 0) + " should be specified only once");
                }
                commandLine$TraceLevel = CommandLine$TraceLevel.WARN;
                string3 = "Overwriting %s field '%s.%s' value '%s' with '%s' for %s%n";
            }
            set.add(field);
        }
        if (CommandLine.access$1600((CommandLine)this.this$0).level.isEnabled(commandLine$TraceLevel)) {
            CommandLine$TraceLevel.access$2600(commandLine$TraceLevel, CommandLine.access$1600(this.this$0), string3, new Object[]{field.getType().getSimpleName(), field.getDeclaringClass().getSimpleName(), field.getName(), String.valueOf(object3), String.valueOf(object2), string});
        }
        field.set(this.command, object2);
        return n;
    }

    private int applyValuesToMapField(Field field, Class<?> clazz, CommandLine$Range commandLine$Range, Stack<String> stack, Class<?> clazz2, String string) {
        Class[] classArray = CommandLine.access$2500(field);
        if (classArray.length < 2) {
            throw new CommandLine$ParameterException(this.this$0, "Field " + field + " needs two types (one for the map key, one for the value) but only has " + classArray.length + " types configured.");
        }
        CommandLine$ITypeConverter<?> commandLine$ITypeConverter = this.getTypeConverter(classArray[0], field);
        CommandLine$ITypeConverter<?> commandLine$ITypeConverter2 = this.getTypeConverter(classArray[1], field);
        Map<Object, Object> map = (Map<Object, Object>)field.get(this.command);
        if (map == null) {
            map = this.createMap(clazz2);
            field.set(this.command, map);
        }
        int n = map.size();
        this.consumeMapArguments(field, commandLine$Range, stack, classArray, commandLine$ITypeConverter, commandLine$ITypeConverter2, map, string);
        return map.size() - n;
    }

    private void consumeMapArguments(Field field, CommandLine$Range commandLine$Range, Stack<String> stack, Class<?>[] classArray, CommandLine$ITypeConverter<?> commandLine$ITypeConverter, CommandLine$ITypeConverter<?> commandLine$ITypeConverter2, Map<Object, Object> map, String string) {
        int n;
        for (n = 0; n < commandLine$Range.min; ++n) {
            this.consumeOneMapArgument(field, commandLine$Range, stack, classArray, commandLine$ITypeConverter, commandLine$ITypeConverter2, map, n, string);
        }
        for (n = commandLine$Range.min; n < commandLine$Range.max && !stack.isEmpty(); ++n) {
            if (!field.isAnnotationPresent(CommandLine$Parameters.class) && (this.commands.containsKey(stack.peek()) || this.isOption(stack.peek()))) {
                return;
            }
            this.consumeOneMapArgument(field, commandLine$Range, stack, classArray, commandLine$ITypeConverter, commandLine$ITypeConverter2, map, n, string);
        }
    }

    private void consumeOneMapArgument(Field field, CommandLine$Range commandLine$Range, Stack<String> stack, Class<?>[] classArray, CommandLine$ITypeConverter<?> commandLine$ITypeConverter, CommandLine$ITypeConverter<?> commandLine$ITypeConverter2, Map<Object, Object> map, int n, String string) {
        String[] stringArray;
        for (String string2 : stringArray = this.split(this.trim(stack.pop()), field)) {
            Object object;
            String[] stringArray2 = string2.split("=");
            if (stringArray2.length < 2) {
                object = this.splitRegex(field);
                if (((String)object).length() == 0) {
                    throw new CommandLine$ParameterException(this.this$0, "Value for option " + this.optionDescription("", field, 0) + " should be in KEY=VALUE format but was " + string2);
                }
                throw new CommandLine$ParameterException(this.this$0, "Value for option " + this.optionDescription("", field, 0) + " should be in KEY=VALUE[" + (String)object + "KEY=VALUE]... format but was " + string2);
            }
            object = this.tryConvert(field, n, commandLine$ITypeConverter, stringArray2[0], classArray[0]);
            Object object2 = this.tryConvert(field, n, commandLine$ITypeConverter2, stringArray2[1], classArray[1]);
            map.put(object, object2);
            if (!CommandLine.access$1600(this.this$0).isInfo()) continue;
            CommandLine.access$1600(this.this$0).info("Putting [%s : %s] in %s<%s, %s> field '%s.%s' for %s%n", String.valueOf(object), String.valueOf(object2), map.getClass().getSimpleName(), classArray[0].getSimpleName(), classArray[1].getSimpleName(), field.getDeclaringClass().getSimpleName(), field.getName(), string);
        }
    }

    private void checkMaxArityExceeded(CommandLine$Range commandLine$Range, int n, Field field, String[] stringArray) {
        if (stringArray.length <= n) {
            return;
        }
        String string = commandLine$Range.max == n ? "" + n : commandLine$Range + ", remainder=" + n;
        throw new CommandLine$MaxValuesforFieldExceededException(this.this$0, this.optionDescription("", field, -1) + " max number of values (" + commandLine$Range.max + ") exceeded: remainder is " + n + " but " + stringArray.length + " values were specified: " + Arrays.toString(stringArray));
    }

    private int applyValuesToArrayField(Field field, Class<?> clazz, CommandLine$Range commandLine$Range, Stack<String> stack, Class<?> clazz2, String string) {
        Object object = field.get(this.command);
        int n = object == null ? 0 : Array.getLength(object);
        Class clazz3 = CommandLine.access$2500(field)[0];
        List<Object> list = this.consumeArguments(field, clazz, commandLine$Range, stack, clazz3, n, string);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < n; ++i) {
            arrayList.add(Array.get(object, i));
        }
        for (Object object2 : list) {
            if (object2 instanceof Collection) {
                arrayList.addAll((Collection)object2);
                continue;
            }
            arrayList.add(object2);
        }
        Object object3 = Array.newInstance(clazz3, arrayList.size());
        field.set(this.command, object3);
        for (int i = 0; i < arrayList.size(); ++i) {
            Array.set(object3, i, arrayList.get(i));
        }
        return list.size();
    }

    private int applyValuesToCollectionField(Field field, Class<?> clazz, CommandLine$Range commandLine$Range, Stack<String> stack, Class<?> clazz2, String string) {
        Collection<Object> collection = (Collection<Object>)field.get(this.command);
        Class clazz3 = CommandLine.access$2500(field)[0];
        int n = collection == null ? 0 : collection.size();
        List<Object> list = this.consumeArguments(field, clazz, commandLine$Range, stack, clazz3, n, string);
        if (collection == null) {
            collection = this.createCollection(clazz2);
            field.set(this.command, collection);
        }
        for (Object object : list) {
            if (object instanceof Collection) {
                collection.addAll((Collection)object);
                continue;
            }
            collection.add(object);
        }
        return list.size();
    }

    private List<Object> consumeArguments(Field field, Class<?> clazz, CommandLine$Range commandLine$Range, Stack<String> stack, Class<?> clazz2, int n, String string) {
        int n2;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (n2 = 0; n2 < commandLine$Range.min; ++n2) {
            this.consumeOneArgument(field, commandLine$Range, stack, clazz2, arrayList, n2, n, string);
        }
        for (n2 = commandLine$Range.min; n2 < commandLine$Range.max && !stack.isEmpty(); ++n2) {
            if (clazz != CommandLine$Parameters.class && (this.commands.containsKey(stack.peek()) || this.isOption(stack.peek()))) {
                return arrayList;
            }
            this.consumeOneArgument(field, commandLine$Range, stack, clazz2, arrayList, n2, n, string);
        }
        return arrayList;
    }

    private int consumeOneArgument(Field field, CommandLine$Range commandLine$Range, Stack<String> stack, Class<?> clazz, List<Object> list, int n, int n2, String string) {
        String[] stringArray = this.split(this.trim(stack.pop()), field);
        CommandLine$ITypeConverter<?> commandLine$ITypeConverter = this.getTypeConverter(clazz, field);
        for (int i = 0; i < stringArray.length; ++i) {
            list.add(this.tryConvert(field, n, commandLine$ITypeConverter, stringArray[i], clazz));
            if (!CommandLine.access$1600(this.this$0).isInfo()) continue;
            if (field.getType().isArray()) {
                CommandLine.access$1600(this.this$0).info("Adding [%s] to %s[] field '%s.%s' for %s%n", String.valueOf(list.get(list.size() - 1)), clazz.getSimpleName(), field.getDeclaringClass().getSimpleName(), field.getName(), string);
                continue;
            }
            CommandLine.access$1600(this.this$0).info("Adding [%s] to %s<%s> field '%s.%s' for %s%n", String.valueOf(list.get(list.size() - 1)), field.getType().getSimpleName(), clazz.getSimpleName(), field.getDeclaringClass().getSimpleName(), field.getName(), string);
        }
        return ++n;
    }

    private String splitRegex(Field field) {
        if (field.isAnnotationPresent(CommandLine$Option.class)) {
            return field.getAnnotation(CommandLine$Option.class).split();
        }
        if (field.isAnnotationPresent(CommandLine$Parameters.class)) {
            return field.getAnnotation(CommandLine$Parameters.class).split();
        }
        return "";
    }

    private String[] split(String string, Field field) {
        String[] stringArray;
        String string2 = this.splitRegex(field);
        if (string2.length() == 0) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = string;
        } else {
            stringArray = string.split(string2);
        }
        return stringArray;
    }

    private boolean isOption(String string) {
        if ("--".equals(string)) {
            return true;
        }
        if (this.optionName2Field.containsKey(string)) {
            return true;
        }
        int n = string.indexOf(this.separator);
        if (n > 0 && this.optionName2Field.containsKey(string.substring(0, n))) {
            return true;
        }
        return string.length() > 2 && string.startsWith("-") && this.singleCharOption2Field.containsKey(Character.valueOf(string.charAt(1)));
    }

    private Object tryConvert(Field field, int n, CommandLine$ITypeConverter<?> commandLine$ITypeConverter, String string, Class<?> clazz) {
        try {
            return commandLine$ITypeConverter.convert(string);
        }
        catch (CommandLine$TypeConversionException commandLine$TypeConversionException) {
            throw new CommandLine$ParameterException(this.this$0, commandLine$TypeConversionException.getMessage() + this.optionDescription(" for ", field, n));
        }
        catch (Exception exception) {
            String string2 = this.optionDescription(" for ", field, n) + ": " + exception;
            throw new CommandLine$ParameterException(this.this$0, "Could not convert '" + string + "' to " + clazz.getSimpleName() + string2, exception);
        }
    }

    private String optionDescription(String string, Field field, int n) {
        CommandLine$Help$IParamLabelRenderer commandLine$Help$IParamLabelRenderer = CommandLine$Help.createMinimalParamLabelRenderer();
        String string2 = "";
        if (field.isAnnotationPresent(CommandLine$Option.class)) {
            string2 = string + "option '" + field.getAnnotation(CommandLine$Option.class).names()[0] + "'";
            if (n >= 0) {
                CommandLine$Range commandLine$Range = CommandLine$Range.optionArity(field);
                if (commandLine$Range.max > 1) {
                    string2 = string2 + " at index " + n;
                }
                string2 = string2 + " (" + commandLine$Help$IParamLabelRenderer.renderParameterLabel(field, CommandLine$Help$Ansi.OFF, Collections.emptyList()) + ")";
            }
        } else if (field.isAnnotationPresent(CommandLine$Parameters.class)) {
            CommandLine$Range commandLine$Range = CommandLine$Range.parameterIndex(field);
            CommandLine$Help$Ansi$Text commandLine$Help$Ansi$Text = commandLine$Help$IParamLabelRenderer.renderParameterLabel(field, CommandLine$Help$Ansi.OFF, Collections.emptyList());
            string2 = string + "positional parameter at index " + commandLine$Range + " (" + commandLine$Help$Ansi$Text + ")";
        }
        return string2;
    }

    private boolean isAnyHelpRequested() {
        return this.isHelpRequested || CommandLine.access$1700(this.this$0) || CommandLine.access$1800(this.this$0);
    }

    private void updateHelpRequested(Field field) {
        if (field.isAnnotationPresent(CommandLine$Option.class)) {
            this.isHelpRequested |= this.is(field, "help", field.getAnnotation(CommandLine$Option.class).help());
            CommandLine commandLine = this.this$0;
            CommandLine.access$1702(commandLine, CommandLine.access$1700(commandLine) | this.is(field, "versionHelp", field.getAnnotation(CommandLine$Option.class).versionHelp()));
            commandLine = this.this$0;
            CommandLine.access$1802(commandLine, CommandLine.access$1800(commandLine) | this.is(field, "usageHelp", field.getAnnotation(CommandLine$Option.class).usageHelp()));
        }
    }

    private boolean is(Field field, String string, boolean bl) {
        if (bl && CommandLine.access$1600(this.this$0).isInfo()) {
            CommandLine.access$1600(this.this$0).info("Field '%s.%s' has '%s' annotation: not validating required fields%n", field.getDeclaringClass().getSimpleName(), field.getName(), string);
        }
        return bl;
    }

    private Collection<Object> createCollection(Class<?> clazz) {
        if (clazz.isInterface()) {
            if (SortedSet.class.isAssignableFrom(clazz)) {
                return new TreeSet<Object>();
            }
            if (Set.class.isAssignableFrom(clazz)) {
                return new LinkedHashSet<Object>();
            }
            if (Queue.class.isAssignableFrom(clazz)) {
                return new LinkedList<Object>();
            }
            return new ArrayList<Object>();
        }
        return (Collection)clazz.newInstance();
    }

    private Map<Object, Object> createMap(Class<?> clazz) {
        try {
            return (Map)clazz.newInstance();
        }
        catch (Exception exception) {
            return new LinkedHashMap<Object, Object>();
        }
    }

    private CommandLine$ITypeConverter<?> getTypeConverter(Class<?> clazz, Field field) {
        CommandLine$ITypeConverter<?> commandLine$ITypeConverter = this.converterRegistry.get(clazz);
        if (commandLine$ITypeConverter != null) {
            return commandLine$ITypeConverter;
        }
        if (clazz.isEnum()) {
            return new CommandLine$Interpreter$1(this, clazz);
        }
        throw new CommandLine$MissingTypeConverterException(this.this$0, "No TypeConverter registered for " + clazz.getName() + " of field " + field);
    }

    private void assertNoMissingParameters(Field field, int n, Stack<String> stack) {
        if (n > stack.size()) {
            if (n == 1) {
                if (field.isAnnotationPresent(CommandLine$Option.class)) {
                    throw new CommandLine$MissingParameterException(this.this$0, "Missing required parameter for " + this.optionDescription("", field, 0));
                }
                CommandLine$Range commandLine$Range = CommandLine$Range.parameterIndex(field);
                CommandLine$Help$IParamLabelRenderer commandLine$Help$IParamLabelRenderer = CommandLine$Help.createMinimalParamLabelRenderer();
                String string = "";
                String string2 = "";
                int n2 = 0;
                for (int i = commandLine$Range.min; i < this.positionalParametersFields.size(); ++i) {
                    if (CommandLine$Range.parameterArity((Field)this.positionalParametersFields.get((int)i)).min <= 0) continue;
                    string2 = string2 + string + commandLine$Help$IParamLabelRenderer.renderParameterLabel(this.positionalParametersFields.get(i), CommandLine$Help$Ansi.OFF, Collections.emptyList());
                    string = ", ";
                    ++n2;
                }
                String string3 = "Missing required parameter";
                CommandLine$Range commandLine$Range2 = CommandLine$Range.parameterArity(field);
                string3 = commandLine$Range2.isVariable ? string3 + "s at positions " + commandLine$Range + ": " : string3 + (n2 > 1 ? "s: " : ": ");
                throw new CommandLine$MissingParameterException(this.this$0, string3 + string2);
            }
            if (stack.isEmpty()) {
                throw new CommandLine$MissingParameterException(this.this$0, this.optionDescription("", field, 0) + " requires at least " + n + " values, but none were specified.");
            }
            throw new CommandLine$MissingParameterException(this.this$0, this.optionDescription("", field, 0) + " requires at least " + n + " values, but only " + stack.size() + " were specified: " + CommandLine.access$2200(stack));
        }
    }

    private String trim(String string) {
        return this.unquote(string);
    }

    private String unquote(String string) {
        return string == null ? null : (string.length() > 1 && string.startsWith("\"") && string.endsWith("\"") ? string.substring(1, string.length() - 1) : string);
    }

    static /* synthetic */ Map access$100(CommandLine$Interpreter commandLine$Interpreter) {
        return commandLine$Interpreter.commands;
    }

    static /* synthetic */ Object access$200(CommandLine$Interpreter commandLine$Interpreter) {
        return commandLine$Interpreter.command;
    }

    static /* synthetic */ Map access$400(CommandLine$Interpreter commandLine$Interpreter) {
        return commandLine$Interpreter.converterRegistry;
    }

    static /* synthetic */ String access$500(CommandLine$Interpreter commandLine$Interpreter) {
        return commandLine$Interpreter.separator;
    }

    static /* synthetic */ String access$502(CommandLine$Interpreter commandLine$Interpreter, String string) {
        commandLine$Interpreter.separator = string;
        return commandLine$Interpreter.separator;
    }
}

