/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.tools.picocli;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.core.tools.picocli.CommandLine;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$Assert;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$Command;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$Help$1;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$Help$Ansi;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$Help$Ansi$Style;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$Help$Ansi$Text;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$Help$ColorScheme;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$Help$Column;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$Help$Column$Overflow;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$Help$DefaultOptionRenderer;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$Help$DefaultParamLabelRenderer;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$Help$DefaultParameterRenderer;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$Help$IOptionRenderer;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$Help$IParamLabelRenderer;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$Help$IParameterRenderer;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$Help$Layout;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$Help$MinimalOptionRenderer;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$Help$MinimalParameterRenderer;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$Help$ShortestFirst;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$Help$SortByOptionArityAndNameAlphabetically;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$Help$SortByShortestOptionNameAlphabetically;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$Help$TextTable;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$Option;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$Parameters;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$PositionalParametersSorter;

public class CommandLine$Help {
    protected static final String DEFAULT_COMMAND_NAME = "<main class>";
    protected static final String DEFAULT_SEPARATOR = "=";
    private static final int usageHelpWidth = 80;
    private static final int optionsColumnWidth = 29;
    private final Object command;
    private final Map<String, CommandLine$Help> commands = new LinkedHashMap<String, CommandLine$Help>();
    final CommandLine$Help$ColorScheme colorScheme;
    public final List<Field> optionFields;
    public final List<Field> positionalParametersFields;
    public String separator;
    public String commandName = "<main class>";
    public String[] description = new String[0];
    public String[] customSynopsis = new String[0];
    public String[] header = new String[0];
    public String[] footer = new String[0];
    public CommandLine$Help$IParamLabelRenderer parameterLabelRenderer;
    public Boolean abbreviateSynopsis;
    public Boolean sortOptions;
    public Boolean showDefaultValues;
    public Character requiredOptionMarker;
    public String headerHeading;
    public String synopsisHeading;
    public String descriptionHeading;
    public String parameterListHeading;
    public String optionListHeading;
    public String commandListHeading;
    public String footerHeading;

    public CommandLine$Help(Object object) {
        this(object, CommandLine$Help$Ansi.AUTO);
    }

    public CommandLine$Help(Object object, CommandLine$Help$Ansi commandLine$Help$Ansi) {
        this(object, CommandLine$Help.defaultColorScheme(commandLine$Help$Ansi));
    }

    public CommandLine$Help(Object object, CommandLine$Help$ColorScheme commandLine$Help$ColorScheme) {
        this.command = CommandLine$Assert.notNull(object, "command");
        this.colorScheme = CommandLine$Assert.notNull(commandLine$Help$ColorScheme, "colorScheme").applySystemProperties();
        ArrayList<Field> arrayList = new ArrayList<Field>();
        ArrayList<Field> arrayList2 = new ArrayList<Field>();
        for (Class<?> clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            for (Field field : clazz.getDeclaredFields()) {
                CommandLine$Option commandLine$Option;
                field.setAccessible(true);
                if (field.isAnnotationPresent(CommandLine$Option.class) && !(commandLine$Option = field.getAnnotation(CommandLine$Option.class)).hidden()) {
                    arrayList.add(field);
                }
                if (!field.isAnnotationPresent(CommandLine$Parameters.class)) continue;
                arrayList2.add(field);
            }
            if (!clazz.isAnnotationPresent(CommandLine$Command.class)) continue;
            CommandLine$Command commandLine$Command = clazz.getAnnotation(CommandLine$Command.class);
            if (DEFAULT_COMMAND_NAME.equals(this.commandName)) {
                this.commandName = commandLine$Command.name();
            }
            this.separator = this.separator == null ? commandLine$Command.separator() : this.separator;
            this.abbreviateSynopsis = this.abbreviateSynopsis == null ? commandLine$Command.abbreviateSynopsis() : this.abbreviateSynopsis.booleanValue();
            this.sortOptions = this.sortOptions == null ? commandLine$Command.sortOptions() : this.sortOptions.booleanValue();
            this.requiredOptionMarker = Character.valueOf(this.requiredOptionMarker == null ? commandLine$Command.requiredOptionMarker() : this.requiredOptionMarker.charValue());
            this.showDefaultValues = this.showDefaultValues == null ? commandLine$Command.showDefaultValues() : this.showDefaultValues.booleanValue();
            this.customSynopsis = CommandLine.access$2700(this.customSynopsis) ? commandLine$Command.customSynopsis() : this.customSynopsis;
            this.description = CommandLine.access$2700(this.description) ? commandLine$Command.description() : this.description;
            this.header = CommandLine.access$2700(this.header) ? commandLine$Command.header() : this.header;
            this.footer = CommandLine.access$2700(this.footer) ? commandLine$Command.footer() : this.footer;
            this.headerHeading = CommandLine.access$2400(this.headerHeading) ? commandLine$Command.headerHeading() : this.headerHeading;
            this.synopsisHeading = CommandLine.access$2400(this.synopsisHeading) || "Usage: ".equals(this.synopsisHeading) ? commandLine$Command.synopsisHeading() : this.synopsisHeading;
            this.descriptionHeading = CommandLine.access$2400(this.descriptionHeading) ? commandLine$Command.descriptionHeading() : this.descriptionHeading;
            this.parameterListHeading = CommandLine.access$2400(this.parameterListHeading) ? commandLine$Command.parameterListHeading() : this.parameterListHeading;
            this.optionListHeading = CommandLine.access$2400(this.optionListHeading) ? commandLine$Command.optionListHeading() : this.optionListHeading;
            this.commandListHeading = CommandLine.access$2400(this.commandListHeading) || "Commands:%n".equals(this.commandListHeading) ? commandLine$Command.commandListHeading() : this.commandListHeading;
            this.footerHeading = CommandLine.access$2400(this.footerHeading) ? commandLine$Command.footerHeading() : this.footerHeading;
        }
        this.sortOptions = this.sortOptions == null ? true : this.sortOptions;
        this.abbreviateSynopsis = this.abbreviateSynopsis == null ? false : this.abbreviateSynopsis;
        this.requiredOptionMarker = Character.valueOf(this.requiredOptionMarker == null ? (char)' ' : this.requiredOptionMarker.charValue());
        this.showDefaultValues = this.showDefaultValues == null ? false : this.showDefaultValues;
        this.synopsisHeading = this.synopsisHeading == null ? "Usage: " : this.synopsisHeading;
        this.commandListHeading = this.commandListHeading == null ? "Commands:%n" : this.commandListHeading;
        this.separator = this.separator == null ? DEFAULT_SEPARATOR : this.separator;
        this.parameterLabelRenderer = this.createDefaultParamLabelRenderer();
        Collections.sort(arrayList2, new CommandLine$PositionalParametersSorter(null));
        this.positionalParametersFields = Collections.unmodifiableList(arrayList2);
        this.optionFields = Collections.unmodifiableList(arrayList);
    }

    public CommandLine$Help addAllSubcommands(Map<String, CommandLine> map) {
        if (map != null) {
            for (Map.Entry<String, CommandLine> entry : map.entrySet()) {
                this.addSubcommand(entry.getKey(), entry.getValue().getCommand());
            }
        }
        return this;
    }

    public CommandLine$Help addSubcommand(String string, Object object) {
        this.commands.put(string, new CommandLine$Help(object));
        return this;
    }

    @Deprecated
    public String synopsis() {
        return this.synopsis(0);
    }

    public String synopsis(int n) {
        if (!CommandLine.access$2700(this.customSynopsis)) {
            return this.customSynopsis(new Object[0]);
        }
        return this.abbreviateSynopsis != false ? this.abbreviatedSynopsis() : this.detailedSynopsis(n, CommandLine$Help.createShortOptionArityAndNameComparator(), true);
    }

    public String abbreviatedSynopsis() {
        StringBuilder stringBuilder = new StringBuilder();
        if (!this.optionFields.isEmpty()) {
            stringBuilder.append(" [OPTIONS]");
        }
        for (Field field : this.positionalParametersFields) {
            if (field.getAnnotation(CommandLine$Parameters.class).hidden()) continue;
            stringBuilder.append(' ').append(this.parameterLabelRenderer.renderParameterLabel(field, this.ansi(), this.colorScheme.parameterStyles));
        }
        return this.colorScheme.commandText(this.commandName).toString() + stringBuilder.toString() + System.getProperty("line.separator");
    }

    @Deprecated
    public String detailedSynopsis(Comparator<Field> comparator, boolean bl) {
        return this.detailedSynopsis(0, comparator, bl);
    }

    public String detailedSynopsis(int n, Comparator<Field> comparator, boolean bl) {
        Object object;
        CommandLine$Help$Ansi commandLine$Help$Ansi = this.ansi();
        ((Object)((Object)commandLine$Help$Ansi)).getClass();
        CommandLine$Help$Ansi$Text commandLine$Help$Ansi$Text = new CommandLine$Help$Ansi$Text(commandLine$Help$Ansi, 0);
        ArrayList<Field> arrayList = new ArrayList<Field>(this.optionFields);
        if (comparator != null) {
            Collections.sort(arrayList, comparator);
        }
        if (bl) {
            Iterator<Field> iterator = new ArrayList();
            StringBuilder object22 = new StringBuilder("-");
            object = new StringBuilder("-");
            for (Field field : arrayList) {
                CommandLine$Option commandLine$Option;
                String string;
                if (field.getType() != Boolean.TYPE && field.getType() != Boolean.class || (string = CommandLine$Help$ShortestFirst.sort((commandLine$Option = field.getAnnotation(CommandLine$Option.class)).names())[0]).length() != 2 || !string.startsWith("-")) continue;
                iterator.add(field);
                if (commandLine$Option.required()) {
                    object22.append(string.substring(1));
                    continue;
                }
                ((StringBuilder)object).append(string.substring(1));
            }
            arrayList.removeAll((Collection<?>)((Object)iterator));
            if (object22.length() > 1) {
                commandLine$Help$Ansi$Text = commandLine$Help$Ansi$Text.append(" ").append(this.colorScheme.optionText(object22.toString()));
            }
            if (((StringBuilder)object).length() > 1) {
                commandLine$Help$Ansi$Text = commandLine$Help$Ansi$Text.append(" [").append(this.colorScheme.optionText(((StringBuilder)object).toString())).append("]");
            }
        }
        for (Field field : arrayList) {
            object = field.getAnnotation(CommandLine$Option.class);
            if (object.hidden()) continue;
            if (object.required()) {
                commandLine$Help$Ansi$Text = this.appendOptionSynopsis(commandLine$Help$Ansi$Text, field, CommandLine$Help$ShortestFirst.sort(object.names())[0], " ", "");
                if (!CommandLine.access$900(field)) continue;
                commandLine$Help$Ansi$Text = this.appendOptionSynopsis(commandLine$Help$Ansi$Text, field, CommandLine$Help$ShortestFirst.sort(object.names())[0], " [", "]...");
                continue;
            }
            commandLine$Help$Ansi$Text = this.appendOptionSynopsis(commandLine$Help$Ansi$Text, field, CommandLine$Help$ShortestFirst.sort(object.names())[0], " [", "]");
            if (!CommandLine.access$900(field)) continue;
            commandLine$Help$Ansi$Text = commandLine$Help$Ansi$Text.append("...");
        }
        for (Field field : this.positionalParametersFields) {
            if (field.getAnnotation(CommandLine$Parameters.class).hidden()) continue;
            commandLine$Help$Ansi$Text = commandLine$Help$Ansi$Text.append(" ");
            object = this.parameterLabelRenderer.renderParameterLabel(field, this.colorScheme.ansi(), this.colorScheme.parameterStyles);
            commandLine$Help$Ansi$Text = commandLine$Help$Ansi$Text.append((CommandLine$Help$Ansi$Text)object);
        }
        int n2 = this.commandName.length() + n;
        CommandLine$Help$TextTable commandLine$Help$TextTable = new CommandLine$Help$TextTable(this.ansi(), n2, 80 - n2);
        commandLine$Help$TextTable.indentWrappedLines = 1;
        CommandLine$Help$Ansi commandLine$Help$Ansi2 = CommandLine$Help$Ansi.OFF;
        ((Object)((Object)commandLine$Help$Ansi2)).getClass();
        object = new CommandLine$Help$Ansi$Text(commandLine$Help$Ansi2, CommandLine$Help.stringOf('X', n));
        commandLine$Help$TextTable.addRowValues(((CommandLine$Help$Ansi$Text)object).append(this.colorScheme.commandText(this.commandName)), commandLine$Help$Ansi$Text);
        return commandLine$Help$TextTable.toString().substring(n);
    }

    private CommandLine$Help$Ansi$Text appendOptionSynopsis(CommandLine$Help$Ansi$Text commandLine$Help$Ansi$Text, Field field, String string, String string2, String string3) {
        CommandLine$Help$Ansi$Text commandLine$Help$Ansi$Text2 = this.parameterLabelRenderer.renderParameterLabel(field, this.colorScheme.ansi(), this.colorScheme.optionParamStyles);
        return commandLine$Help$Ansi$Text.append(string2).append(this.colorScheme.optionText(string)).append(commandLine$Help$Ansi$Text2).append(string3);
    }

    public int synopsisHeadingLength() {
        CommandLine$Help$Ansi commandLine$Help$Ansi = CommandLine$Help$Ansi.OFF;
        ((Object)((Object)commandLine$Help$Ansi)).getClass();
        String[] stringArray = new CommandLine$Help$Ansi$Text(commandLine$Help$Ansi, this.synopsisHeading).toString().split("\\r?\\n|\\r|%n", -1);
        return stringArray[stringArray.length - 1].length();
    }

    public String optionList() {
        Comparator<Field> comparator = this.sortOptions == null || this.sortOptions != false ? CommandLine$Help.createShortOptionNameComparator() : null;
        return this.optionList(this.createDefaultLayout(), comparator, this.parameterLabelRenderer);
    }

    public String optionList(CommandLine$Help$Layout commandLine$Help$Layout, Comparator<Field> comparator, CommandLine$Help$IParamLabelRenderer commandLine$Help$IParamLabelRenderer) {
        ArrayList<Field> arrayList = new ArrayList<Field>(this.optionFields);
        if (comparator != null) {
            Collections.sort(arrayList, comparator);
        }
        commandLine$Help$Layout.addOptions(arrayList, commandLine$Help$IParamLabelRenderer);
        return commandLine$Help$Layout.toString();
    }

    public String parameterList() {
        return this.parameterList(this.createDefaultLayout(), this.parameterLabelRenderer);
    }

    public String parameterList(CommandLine$Help$Layout commandLine$Help$Layout, CommandLine$Help$IParamLabelRenderer commandLine$Help$IParamLabelRenderer) {
        commandLine$Help$Layout.addPositionalParameters(this.positionalParametersFields, commandLine$Help$IParamLabelRenderer);
        return commandLine$Help$Layout.toString();
    }

    private static String heading(CommandLine$Help$Ansi commandLine$Help$Ansi, String string, Object ... objectArray) {
        StringBuilder stringBuilder = CommandLine$Help.join(commandLine$Help$Ansi, new String[]{string}, new StringBuilder(), objectArray);
        String string2 = stringBuilder.toString();
        string2 = string2.endsWith(System.getProperty("line.separator")) ? string2.substring(0, string2.length() - System.getProperty("line.separator").length()) : string2;
        return string2 + new String(CommandLine$Help.spaces(CommandLine$Help.countTrailingSpaces(string)));
    }

    private static char[] spaces(int n) {
        char[] cArray = new char[n];
        Arrays.fill(cArray, ' ');
        return cArray;
    }

    private static int countTrailingSpaces(String string) {
        if (string == null) {
            return 0;
        }
        int n = 0;
        for (int i = string.length() - 1; i >= 0 && string.charAt(i) == ' '; --i) {
            ++n;
        }
        return n;
    }

    public static StringBuilder join(CommandLine$Help$Ansi commandLine$Help$Ansi, String[] stringArray, StringBuilder stringBuilder, Object ... objectArray) {
        if (stringArray != null) {
            CommandLine$Help$TextTable commandLine$Help$TextTable = new CommandLine$Help$TextTable(commandLine$Help$Ansi, 80);
            commandLine$Help$TextTable.indentWrappedLines = 0;
            for (String string : stringArray) {
                CommandLine$Help$Ansi$Text[] commandLine$Help$Ansi$TextArray;
                CommandLine$Help$Ansi commandLine$Help$Ansi2 = commandLine$Help$Ansi;
                ((Object)((Object)commandLine$Help$Ansi2)).getClass();
                for (CommandLine$Help$Ansi$Text commandLine$Help$Ansi$Text : commandLine$Help$Ansi$TextArray = new CommandLine$Help$Ansi$Text(commandLine$Help$Ansi2, CommandLine$Help.format(string, objectArray)).splitLines()) {
                    commandLine$Help$TextTable.addRowValues(commandLine$Help$Ansi$Text);
                }
            }
            commandLine$Help$TextTable.toString(stringBuilder);
        }
        return stringBuilder;
    }

    private static String format(String string, Object ... objectArray) {
        return string == null ? "" : String.format(string, objectArray);
    }

    public String customSynopsis(Object ... objectArray) {
        return CommandLine$Help.join(this.ansi(), this.customSynopsis, new StringBuilder(), objectArray).toString();
    }

    public String description(Object ... objectArray) {
        return CommandLine$Help.join(this.ansi(), this.description, new StringBuilder(), objectArray).toString();
    }

    public String header(Object ... objectArray) {
        return CommandLine$Help.join(this.ansi(), this.header, new StringBuilder(), objectArray).toString();
    }

    public String footer(Object ... objectArray) {
        return CommandLine$Help.join(this.ansi(), this.footer, new StringBuilder(), objectArray).toString();
    }

    public String headerHeading(Object ... objectArray) {
        return CommandLine$Help.heading(this.ansi(), this.headerHeading, objectArray);
    }

    public String synopsisHeading(Object ... objectArray) {
        return CommandLine$Help.heading(this.ansi(), this.synopsisHeading, objectArray);
    }

    public String descriptionHeading(Object ... objectArray) {
        return CommandLine.access$2400(this.descriptionHeading) ? "" : CommandLine$Help.heading(this.ansi(), this.descriptionHeading, objectArray);
    }

    public String parameterListHeading(Object ... objectArray) {
        return this.positionalParametersFields.isEmpty() ? "" : CommandLine$Help.heading(this.ansi(), this.parameterListHeading, objectArray);
    }

    public String optionListHeading(Object ... objectArray) {
        return this.optionFields.isEmpty() ? "" : CommandLine$Help.heading(this.ansi(), this.optionListHeading, objectArray);
    }

    public String commandListHeading(Object ... objectArray) {
        return this.commands.isEmpty() ? "" : CommandLine$Help.heading(this.ansi(), this.commandListHeading, objectArray);
    }

    public String footerHeading(Object ... objectArray) {
        return CommandLine$Help.heading(this.ansi(), this.footerHeading, objectArray);
    }

    public String commandList() {
        if (this.commands.isEmpty()) {
            return "";
        }
        int n = CommandLine$Help.maxLength(this.commands.keySet());
        CommandLine$Help$TextTable commandLine$Help$TextTable = new CommandLine$Help$TextTable(this.ansi(), new CommandLine$Help$Column(n + 2, 2, CommandLine$Help$Column$Overflow.SPAN), new CommandLine$Help$Column(80 - (n + 2), 2, CommandLine$Help$Column$Overflow.WRAP));
        for (Map.Entry<String, CommandLine$Help> entry : this.commands.entrySet()) {
            CommandLine$Help commandLine$Help = entry.getValue();
            String string = commandLine$Help.header != null && commandLine$Help.header.length > 0 ? commandLine$Help.header[0] : (commandLine$Help.description != null && commandLine$Help.description.length > 0 ? commandLine$Help.description[0] : "");
            CommandLine$Help$Ansi$Text[] commandLine$Help$Ansi$TextArray = new CommandLine$Help$Ansi$Text[2];
            commandLine$Help$Ansi$TextArray[0] = this.colorScheme.commandText(entry.getKey());
            CommandLine$Help$Ansi commandLine$Help$Ansi = this.ansi();
            ((Object)((Object)commandLine$Help$Ansi)).getClass();
            commandLine$Help$Ansi$TextArray[1] = new CommandLine$Help$Ansi$Text(commandLine$Help$Ansi, string);
            commandLine$Help$TextTable.addRowValues(commandLine$Help$Ansi$TextArray);
        }
        return commandLine$Help$TextTable.toString();
    }

    private static int maxLength(Collection<String> collection) {
        ArrayList<String> arrayList = new ArrayList<String>(collection);
        Collections.sort(arrayList, Collections.reverseOrder(CommandLine$Help.shortestFirst()));
        return ((String)arrayList.get(0)).length();
    }

    private static String join(String[] stringArray, int n, int n2, String string) {
        if (stringArray == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = n; i < n + n2; ++i) {
            stringBuilder.append(i > n ? string : "").append(stringArray[i]);
        }
        return stringBuilder.toString();
    }

    private static String stringOf(char c, int n) {
        char[] cArray = new char[n];
        Arrays.fill(cArray, c);
        return new String(cArray);
    }

    public CommandLine$Help$Layout createDefaultLayout() {
        return new CommandLine$Help$Layout(this.colorScheme, new CommandLine$Help$TextTable(this.colorScheme.ansi()), this.createDefaultOptionRenderer(), this.createDefaultParameterRenderer());
    }

    public CommandLine$Help$IOptionRenderer createDefaultOptionRenderer() {
        CommandLine$Help$DefaultOptionRenderer commandLine$Help$DefaultOptionRenderer = new CommandLine$Help$DefaultOptionRenderer();
        commandLine$Help$DefaultOptionRenderer.requiredMarker = String.valueOf(this.requiredOptionMarker);
        if (this.showDefaultValues != null && this.showDefaultValues.booleanValue()) {
            commandLine$Help$DefaultOptionRenderer.command = this.command;
        }
        return commandLine$Help$DefaultOptionRenderer;
    }

    public static CommandLine$Help$IOptionRenderer createMinimalOptionRenderer() {
        return new CommandLine$Help$MinimalOptionRenderer();
    }

    public CommandLine$Help$IParameterRenderer createDefaultParameterRenderer() {
        CommandLine$Help$DefaultParameterRenderer commandLine$Help$DefaultParameterRenderer = new CommandLine$Help$DefaultParameterRenderer();
        commandLine$Help$DefaultParameterRenderer.requiredMarker = String.valueOf(this.requiredOptionMarker);
        return commandLine$Help$DefaultParameterRenderer;
    }

    public static CommandLine$Help$IParameterRenderer createMinimalParameterRenderer() {
        return new CommandLine$Help$MinimalParameterRenderer();
    }

    public static CommandLine$Help$IParamLabelRenderer createMinimalParamLabelRenderer() {
        return new CommandLine$Help$1();
    }

    public CommandLine$Help$IParamLabelRenderer createDefaultParamLabelRenderer() {
        return new CommandLine$Help$DefaultParamLabelRenderer(this.separator);
    }

    public static Comparator<Field> createShortOptionNameComparator() {
        return new CommandLine$Help$SortByShortestOptionNameAlphabetically();
    }

    public static Comparator<Field> createShortOptionArityAndNameComparator() {
        return new CommandLine$Help$SortByOptionArityAndNameAlphabetically();
    }

    public static Comparator<String> shortestFirst() {
        return new CommandLine$Help$ShortestFirst();
    }

    public CommandLine$Help$Ansi ansi() {
        return CommandLine$Help$ColorScheme.access$2900(this.colorScheme);
    }

    public static CommandLine$Help$ColorScheme defaultColorScheme(CommandLine$Help$Ansi commandLine$Help$Ansi) {
        return new CommandLine$Help$ColorScheme(commandLine$Help$Ansi).commands(CommandLine$Help$Ansi$Style.bold).options(CommandLine$Help$Ansi$Style.fg_yellow).parameters(CommandLine$Help$Ansi$Style.fg_yellow).optionParams(CommandLine$Help$Ansi$Style.italic);
    }

    static /* synthetic */ String access$3000(String[] stringArray, int n, int n2, String string) {
        return CommandLine$Help.join(stringArray, n, n2, string);
    }

    static /* synthetic */ char[] access$3500(int n) {
        return CommandLine$Help.spaces(n);
    }
}

