/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.tools.picocli;

import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$Assert;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$Help;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$Help$Ansi;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$Help$Ansi$Text;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$Help$Column;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$Help$Column$Overflow;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$Help$TextTable$Cell;

public class CommandLine$Help$TextTable {
    public final CommandLine$Help$Column[] columns;
    protected final List<CommandLine$Help$Ansi$Text> columnValues = new ArrayList<CommandLine$Help$Ansi$Text>();
    public int indentWrappedLines = 2;
    private final CommandLine$Help$Ansi ansi;

    public CommandLine$Help$TextTable(CommandLine$Help$Ansi commandLine$Help$Ansi) {
        this(commandLine$Help$Ansi, new CommandLine$Help$Column(2, 0, CommandLine$Help$Column$Overflow.TRUNCATE), new CommandLine$Help$Column(2, 0, CommandLine$Help$Column$Overflow.TRUNCATE), new CommandLine$Help$Column(1, 0, CommandLine$Help$Column$Overflow.TRUNCATE), new CommandLine$Help$Column(24, 1, CommandLine$Help$Column$Overflow.SPAN), new CommandLine$Help$Column(51, 1, CommandLine$Help$Column$Overflow.WRAP));
    }

    public CommandLine$Help$TextTable(CommandLine$Help$Ansi commandLine$Help$Ansi, int ... nArray) {
        this.ansi = CommandLine$Assert.notNull(commandLine$Help$Ansi, "ansi");
        this.columns = new CommandLine$Help$Column[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            this.columns[i] = new CommandLine$Help$Column(nArray[i], 0, i == nArray.length - 1 ? CommandLine$Help$Column$Overflow.SPAN : CommandLine$Help$Column$Overflow.WRAP);
        }
    }

    public CommandLine$Help$TextTable(CommandLine$Help$Ansi commandLine$Help$Ansi, CommandLine$Help$Column ... commandLine$Help$ColumnArray) {
        this.ansi = CommandLine$Assert.notNull(commandLine$Help$Ansi, "ansi");
        this.columns = CommandLine$Assert.notNull(commandLine$Help$ColumnArray, "columns");
        if (commandLine$Help$ColumnArray.length == 0) {
            throw new IllegalArgumentException("At least one column is required");
        }
    }

    public CommandLine$Help$Ansi$Text textAt(int n, int n2) {
        return this.columnValues.get(n2 + n * this.columns.length);
    }

    @Deprecated
    public CommandLine$Help$Ansi$Text cellAt(int n, int n2) {
        return this.textAt(n, n2);
    }

    public int rowCount() {
        return this.columnValues.size() / this.columns.length;
    }

    public void addEmptyRow() {
        for (int i = 0; i < this.columns.length; ++i) {
            CommandLine$Help$Ansi commandLine$Help$Ansi = this.ansi;
            ((Object)((Object)commandLine$Help$Ansi)).getClass();
            this.columnValues.add(new CommandLine$Help$Ansi$Text(commandLine$Help$Ansi, this.columns[i].width));
        }
    }

    public void addRowValues(String ... stringArray) {
        CommandLine$Help$Ansi$Text[] commandLine$Help$Ansi$TextArray = new CommandLine$Help$Ansi$Text[stringArray.length];
        for (int i = 0; i < commandLine$Help$Ansi$TextArray.length; ++i) {
            CommandLine$Help$Ansi$Text commandLine$Help$Ansi$Text;
            if (stringArray[i] == null) {
                commandLine$Help$Ansi$Text = CommandLine$Help$Ansi.EMPTY_TEXT;
            } else {
                CommandLine$Help$Ansi commandLine$Help$Ansi = this.ansi;
                ((Object)((Object)commandLine$Help$Ansi)).getClass();
                commandLine$Help$Ansi$Text = new CommandLine$Help$Ansi$Text(commandLine$Help$Ansi, stringArray[i]);
            }
            commandLine$Help$Ansi$TextArray[i] = commandLine$Help$Ansi$Text;
        }
        this.addRowValues(commandLine$Help$Ansi$TextArray);
    }

    public void addRowValues(CommandLine$Help$Ansi$Text ... commandLine$Help$Ansi$TextArray) {
        if (commandLine$Help$Ansi$TextArray.length > this.columns.length) {
            throw new IllegalArgumentException(commandLine$Help$Ansi$TextArray.length + " values don't fit in " + this.columns.length + " columns");
        }
        this.addEmptyRow();
        for (int i = 0; i < commandLine$Help$Ansi$TextArray.length; ++i) {
            int n = this.rowCount() - 1;
            CommandLine$Help$TextTable$Cell commandLine$Help$TextTable$Cell = this.putValue(n, i, commandLine$Help$Ansi$TextArray[i]);
            if (commandLine$Help$TextTable$Cell.row == n && commandLine$Help$TextTable$Cell.column == i || i == commandLine$Help$Ansi$TextArray.length - 1) continue;
            this.addEmptyRow();
        }
    }

    public CommandLine$Help$TextTable$Cell putValue(int n, int n2, CommandLine$Help$Ansi$Text commandLine$Help$Ansi$Text) {
        if (n > this.rowCount() - 1) {
            throw new IllegalArgumentException("Cannot write to row " + n + ": rowCount=" + this.rowCount());
        }
        if (commandLine$Help$Ansi$Text == null || CommandLine$Help$Ansi$Text.access$600(commandLine$Help$Ansi$Text).length() == 0) {
            return new CommandLine$Help$TextTable$Cell(n2, n);
        }
        CommandLine$Help$Column commandLine$Help$Column = this.columns[n2];
        int n3 = commandLine$Help$Column.indent;
        switch (commandLine$Help$Column.overflow) {
            case TRUNCATE: {
                CommandLine$Help$TextTable.copy(commandLine$Help$Ansi$Text, this.textAt(n, n2), n3);
                return new CommandLine$Help$TextTable$Cell(n2, n);
            }
            case SPAN: {
                int n4 = n2;
                do {
                    boolean bl = n2 == this.columns.length - 1;
                    int n5 = bl ? this.copy(BreakIterator.getLineInstance(), commandLine$Help$Ansi$Text, this.textAt(n, n2), n3) : CommandLine$Help$TextTable.copy(commandLine$Help$Ansi$Text, this.textAt(n, n2), n3);
                    commandLine$Help$Ansi$Text = commandLine$Help$Ansi$Text.substring(n5);
                    n3 = 0;
                    if (CommandLine$Help$Ansi$Text.access$3100(commandLine$Help$Ansi$Text) > 0) {
                        ++n2;
                    }
                    if (CommandLine$Help$Ansi$Text.access$3100(commandLine$Help$Ansi$Text) <= 0 || n2 < this.columns.length) continue;
                    this.addEmptyRow();
                    ++n;
                    n2 = n4;
                    n3 = commandLine$Help$Column.indent + this.indentWrappedLines;
                } while (CommandLine$Help$Ansi$Text.access$3100(commandLine$Help$Ansi$Text) > 0);
                return new CommandLine$Help$TextTable$Cell(n2, n);
            }
            case WRAP: {
                BreakIterator breakIterator = BreakIterator.getLineInstance();
                do {
                    int n6 = this.copy(breakIterator, commandLine$Help$Ansi$Text, this.textAt(n, n2), n3);
                    commandLine$Help$Ansi$Text = commandLine$Help$Ansi$Text.substring(n6);
                    n3 = commandLine$Help$Column.indent + this.indentWrappedLines;
                    if (CommandLine$Help$Ansi$Text.access$3100(commandLine$Help$Ansi$Text) <= 0) continue;
                    ++n;
                    this.addEmptyRow();
                } while (CommandLine$Help$Ansi$Text.access$3100(commandLine$Help$Ansi$Text) > 0);
                return new CommandLine$Help$TextTable$Cell(n2, n);
            }
        }
        throw new IllegalStateException(commandLine$Help$Column.overflow.toString());
    }

    private static int length(CommandLine$Help$Ansi$Text commandLine$Help$Ansi$Text) {
        return CommandLine$Help$Ansi$Text.access$3100(commandLine$Help$Ansi$Text);
    }

    private int copy(BreakIterator breakIterator, CommandLine$Help$Ansi$Text commandLine$Help$Ansi$Text, CommandLine$Help$Ansi$Text commandLine$Help$Ansi$Text2, int n) {
        breakIterator.setText(commandLine$Help$Ansi$Text.plainString().replace("-", "\u00ff"));
        int n2 = 0;
        int n3 = breakIterator.first();
        int n4 = breakIterator.next();
        while (n4 != -1) {
            CommandLine$Help$Ansi$Text commandLine$Help$Ansi$Text3 = commandLine$Help$Ansi$Text.substring(n3, n4);
            if (CommandLine$Help$Ansi$Text.access$3300(commandLine$Help$Ansi$Text2) < n + n2 + CommandLine$Help$TextTable.length(commandLine$Help$Ansi$Text3)) break;
            n2 += CommandLine$Help$TextTable.copy(commandLine$Help$Ansi$Text3, commandLine$Help$Ansi$Text2, n + n2);
            n3 = n4;
            n4 = breakIterator.next();
        }
        if (n2 == 0 && CommandLine$Help$TextTable.length(commandLine$Help$Ansi$Text) > CommandLine$Help$Ansi$Text.access$3300(commandLine$Help$Ansi$Text2)) {
            n2 = CommandLine$Help$TextTable.copy(commandLine$Help$Ansi$Text, commandLine$Help$Ansi$Text2, n);
        }
        return n2;
    }

    private static int copy(CommandLine$Help$Ansi$Text commandLine$Help$Ansi$Text, CommandLine$Help$Ansi$Text commandLine$Help$Ansi$Text2, int n) {
        int n2 = Math.min(CommandLine$Help$Ansi$Text.access$3100(commandLine$Help$Ansi$Text), CommandLine$Help$Ansi$Text.access$3300(commandLine$Help$Ansi$Text2) - n);
        commandLine$Help$Ansi$Text.getStyledChars(CommandLine$Help$Ansi$Text.access$3400(commandLine$Help$Ansi$Text), n2, commandLine$Help$Ansi$Text2, n);
        return n2;
    }

    public StringBuilder toString(StringBuilder stringBuilder) {
        int n = this.columns.length;
        StringBuilder stringBuilder2 = new StringBuilder(80);
        for (int i = 0; i < this.columnValues.size(); ++i) {
            int n2;
            CommandLine$Help$Ansi$Text commandLine$Help$Ansi$Text = this.columnValues.get(i);
            stringBuilder2.append(commandLine$Help$Ansi$Text.toString());
            stringBuilder2.append(new String(CommandLine$Help.access$3500(this.columns[i % n].width - CommandLine$Help$Ansi$Text.access$3100(commandLine$Help$Ansi$Text))));
            if (i % n != n - 1) continue;
            for (n2 = stringBuilder2.length() - 1; n2 >= 0 && stringBuilder2.charAt(n2) == ' '; --n2) {
            }
            stringBuilder2.setLength(n2 + 1);
            stringBuilder.append(stringBuilder2.toString()).append(System.getProperty("line.separator"));
            stringBuilder2.setLength(0);
        }
        return stringBuilder;
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }
}

