/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.tools.picocli;

import java.util.List;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$Help$Ansi$IStyle;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$Help$Ansi$Style;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$Help$Ansi$StyledSection;
import org.apache.logging.log4j.core.tools.picocli.CommandLine$Help$Ansi$Text;

public enum CommandLine$Help$Ansi {
    AUTO,
    ON,
    OFF;

    static CommandLine$Help$Ansi$Text EMPTY_TEXT;
    static final boolean isWindows;
    static final boolean isXterm;
    static final boolean ISATTY;

    static final boolean calcTTY() {
        if (isWindows && isXterm) {
            return true;
        }
        try {
            return System.class.getDeclaredMethod("console", new Class[0]).invoke(null, new Object[0]) != null;
        }
        catch (Throwable throwable) {
            return true;
        }
    }

    private static boolean ansiPossible() {
        return ISATTY && (!isWindows || isXterm);
    }

    public boolean enabled() {
        if (this == ON) {
            return true;
        }
        if (this == OFF) {
            return false;
        }
        return System.getProperty("picocli.ansi") == null ? CommandLine$Help$Ansi.ansiPossible() : Boolean.getBoolean("picocli.ansi");
    }

    public CommandLine$Help$Ansi$Text apply(String string, List<CommandLine$Help$Ansi$IStyle> list) {
        if (string.length() == 0) {
            return new CommandLine$Help$Ansi$Text(this, 0);
        }
        CommandLine$Help$Ansi$Text commandLine$Help$Ansi$Text = new CommandLine$Help$Ansi$Text(this, string.length());
        CommandLine$Help$Ansi$IStyle[] commandLine$Help$Ansi$IStyleArray = list.toArray(new CommandLine$Help$Ansi$IStyle[list.size()]);
        CommandLine$Help$Ansi$Text.access$3600(commandLine$Help$Ansi$Text).add(new CommandLine$Help$Ansi$StyledSection(0, string.length(), CommandLine$Help$Ansi$Style.on(commandLine$Help$Ansi$IStyleArray), CommandLine$Help$Ansi$Style.off(CommandLine$Help$Ansi.reverse(commandLine$Help$Ansi$IStyleArray)) + CommandLine$Help$Ansi$Style.reset.off()));
        CommandLine$Help$Ansi$Text.access$600(commandLine$Help$Ansi$Text).append(string);
        CommandLine$Help$Ansi$Text.access$3102(commandLine$Help$Ansi$Text, CommandLine$Help$Ansi$Text.access$600(commandLine$Help$Ansi$Text).length());
        return commandLine$Help$Ansi$Text;
    }

    private static <T> T[] reverse(T[] TArray) {
        for (int i = 0; i < TArray.length / 2; ++i) {
            T t = TArray[i];
            TArray[i] = TArray[TArray.length - i - 1];
            TArray[TArray.length - i - 1] = t;
        }
        return TArray;
    }

    static /* synthetic */ Object[] access$3700(Object[] objectArray) {
        return CommandLine$Help$Ansi.reverse(objectArray);
    }

    static {
        CommandLine$Help$Ansi commandLine$Help$Ansi = OFF;
        ((Object)((Object)commandLine$Help$Ansi)).getClass();
        EMPTY_TEXT = new CommandLine$Help$Ansi$Text(commandLine$Help$Ansi, 0);
        isWindows = System.getProperty("os.name").startsWith("Windows");
        isXterm = System.getenv("TERM") != null && System.getenv("TERM").startsWith("xterm");
        ISATTY = CommandLine$Help$Ansi.calcTTY();
    }
}

