/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.script;

import java.io.File;
import java.nio.file.Path;
import java.security.AccessController;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.script.AbstractScript;
import org.apache.logging.log4j.core.script.ScriptFile;
import org.apache.logging.log4j.core.script.ScriptManager$MainScriptRunner;
import org.apache.logging.log4j.core.script.ScriptManager$ScriptRunner;
import org.apache.logging.log4j.core.script.ScriptManager$ThreadLocalScriptRunner;
import org.apache.logging.log4j.core.util.FileWatcher;
import org.apache.logging.log4j.core.util.WatchManager;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.Strings;

public class ScriptManager
implements FileWatcher {
    private static final String KEY_THREADING = "THREADING";
    private static final Logger logger = StatusLogger.getLogger();
    private final Configuration configuration;
    private final ScriptEngineManager manager = new ScriptEngineManager();
    private final ConcurrentMap<String, ScriptManager$ScriptRunner> scriptRunners = new ConcurrentHashMap<String, ScriptManager$ScriptRunner>();
    private final String languages;
    private final Set<String> allowedLanguages;
    private final WatchManager watchManager;

    public ScriptManager(Configuration configuration, WatchManager watchManager, String string) {
        this.configuration = configuration;
        this.watchManager = watchManager;
        List<ScriptEngineFactory> list = this.manager.getEngineFactories();
        this.allowedLanguages = Arrays.stream(Strings.splitList(string)).map(String::toLowerCase).collect(Collectors.toSet());
        if (logger.isDebugEnabled()) {
            StringBuilder stringBuilder = new StringBuilder();
            int n = list.size();
            logger.debug("Installed {} script engine{}", (Object)n, (Object)(n != 1 ? "s" : ""));
            for (ScriptEngineFactory scriptEngineFactory : list) {
                String string2 = Objects.toString(scriptEngineFactory.getParameter(KEY_THREADING), null);
                if (string2 == null) {
                    string2 = "Not Thread Safe";
                }
                StringBuilder stringBuilder2 = new StringBuilder();
                List<String> list2 = scriptEngineFactory.getNames();
                for (String string3 : list2) {
                    if (!this.allowedLanguages.contains(string3.toLowerCase(Locale.ROOT))) continue;
                    if (stringBuilder2.length() > 0) {
                        stringBuilder2.append(", ");
                    }
                    stringBuilder2.append(string3);
                }
                if (stringBuilder2.length() <= 0) continue;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append((CharSequence)stringBuilder2);
                boolean bl = scriptEngineFactory.getScriptEngine() instanceof Compilable;
                logger.debug("{} version: {}, language: {}, threading: {}, compile: {}, names: {}, factory class: {}", (Object)scriptEngineFactory.getEngineName(), (Object)scriptEngineFactory.getEngineVersion(), (Object)scriptEngineFactory.getLanguageName(), (Object)string2, (Object)bl, (Object)list2, (Object)scriptEngineFactory.getClass().getName());
            }
            this.languages = stringBuilder.toString();
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            for (ScriptEngineFactory scriptEngineFactory : list) {
                for (String string4 : scriptEngineFactory.getNames()) {
                    if (!this.allowedLanguages.contains(string4.toLowerCase(Locale.ROOT))) continue;
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(string4);
                }
            }
            this.languages = stringBuilder.toString();
        }
    }

    public Set<String> getAllowedLanguages() {
        return this.allowedLanguages;
    }

    public boolean addScript(AbstractScript abstractScript) {
        if (this.allowedLanguages.contains(abstractScript.getLanguage().toLowerCase(Locale.ROOT))) {
            ScriptEngine scriptEngine = this.manager.getEngineByName(abstractScript.getLanguage());
            if (scriptEngine == null) {
                logger.error("No ScriptEngine found for language " + abstractScript.getLanguage() + ". Available languages are: " + this.languages);
                return false;
            }
            if (scriptEngine.getFactory().getParameter(KEY_THREADING) == null) {
                this.scriptRunners.put(abstractScript.getName(), new ScriptManager$ThreadLocalScriptRunner(this, abstractScript));
            } else {
                this.scriptRunners.put(abstractScript.getName(), new ScriptManager$MainScriptRunner(this, scriptEngine, abstractScript));
            }
            if (abstractScript instanceof ScriptFile) {
                ScriptFile scriptFile = (ScriptFile)abstractScript;
                Path path = scriptFile.getPath();
                if (scriptFile.isWatched() && path != null) {
                    this.watchManager.watchFile(path.toFile(), this);
                }
            }
        } else {
            logger.error("Unable to add script {}, {} has not been configured as an allowed language", (Object)abstractScript.getName(), (Object)abstractScript.getLanguage());
            return false;
        }
        return true;
    }

    public Bindings createBindings(AbstractScript abstractScript) {
        return this.getScriptRunner(abstractScript).createBindings();
    }

    public AbstractScript getScript(String string) {
        ScriptManager$ScriptRunner scriptManager$ScriptRunner = (ScriptManager$ScriptRunner)this.scriptRunners.get(string);
        return scriptManager$ScriptRunner != null ? scriptManager$ScriptRunner.getScript() : null;
    }

    @Override
    public void fileModified(File file) {
        ScriptManager$ScriptRunner scriptManager$ScriptRunner = (ScriptManager$ScriptRunner)this.scriptRunners.get(file.toString());
        if (scriptManager$ScriptRunner == null) {
            logger.info("{} is not a running script", (Object)file.getName());
            return;
        }
        ScriptEngine scriptEngine = scriptManager$ScriptRunner.getScriptEngine();
        AbstractScript abstractScript = scriptManager$ScriptRunner.getScript();
        if (scriptEngine.getFactory().getParameter(KEY_THREADING) == null) {
            this.scriptRunners.put(abstractScript.getName(), new ScriptManager$ThreadLocalScriptRunner(this, abstractScript));
        } else {
            this.scriptRunners.put(abstractScript.getName(), new ScriptManager$MainScriptRunner(this, scriptEngine, abstractScript));
        }
    }

    public Object execute(String string, Bindings bindings) {
        ScriptManager$ScriptRunner scriptManager$ScriptRunner = (ScriptManager$ScriptRunner)this.scriptRunners.get(string);
        if (scriptManager$ScriptRunner == null) {
            logger.warn("No script named {} could be found", (Object)string);
            return null;
        }
        return AccessController.doPrivileged(() -> scriptManager$ScriptRunner.execute(bindings));
    }

    private ScriptManager$ScriptRunner getScriptRunner(AbstractScript abstractScript) {
        return (ScriptManager$ScriptRunner)this.scriptRunners.get(abstractScript.getName());
    }

    static /* synthetic */ Configuration access$000(ScriptManager scriptManager) {
        return scriptManager.configuration;
    }

    static /* synthetic */ Logger access$100() {
        return logger;
    }

    static /* synthetic */ ScriptEngineManager access$400(ScriptManager scriptManager) {
        return scriptManager.manager;
    }
}

