/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import java.util.ArrayList;
import java.util.Locale;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.HtmlTextRenderer;
import org.apache.logging.log4j.core.pattern.JAnsiTextRenderer;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.core.pattern.MessagePatternConverter$1;
import org.apache.logging.log4j.core.pattern.MessagePatternConverter$FormattedMessagePatternConverter;
import org.apache.logging.log4j.core.pattern.MessagePatternConverter$RenderingPatternConverter;
import org.apache.logging.log4j.core.pattern.MessagePatternConverter$SimpleMessagePatternConverter;
import org.apache.logging.log4j.core.pattern.TextRenderer;
import org.apache.logging.log4j.core.util.Loader;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.PerformanceSensitive;
import org.apache.logging.log4j.util.Strings;

@Plugin(name="MessagePatternConverter", category="Converter")
@ConverterKeys(value={"m", "msg", "message"})
@PerformanceSensitive(value={"allocation"})
public class MessagePatternConverter
extends LogEventPatternConverter {
    private static final String LOOKUPS = "lookups";
    private static final String NOLOOKUPS = "nolookups";

    private MessagePatternConverter() {
        super("Message", "message");
    }

    private static TextRenderer loadMessageRenderer(String[] stringArray) {
        if (stringArray != null) {
            for (String string : stringArray) {
                switch (string.toUpperCase(Locale.ROOT)) {
                    case "ANSI": {
                        if (Loader.isJansiAvailable()) {
                            return new JAnsiTextRenderer(stringArray, JAnsiTextRenderer.DefaultMessageStyleMap);
                        }
                        StatusLogger.getLogger().warn("You requested ANSI message rendering but JANSI is not on the classpath.");
                        return null;
                    }
                    case "HTML": {
                        return new HtmlTextRenderer(stringArray);
                    }
                }
            }
        }
        return null;
    }

    public static MessagePatternConverter newInstance(Configuration configuration, String[] stringArray) {
        MessagePatternConverter messagePatternConverter;
        String[] stringArray2 = MessagePatternConverter.withoutLookupOptions(stringArray);
        TextRenderer textRenderer = MessagePatternConverter.loadMessageRenderer(stringArray2);
        MessagePatternConverter messagePatternConverter2 = messagePatternConverter = stringArray2 == null || stringArray2.length == 0 ? MessagePatternConverter$SimpleMessagePatternConverter.access$000() : new MessagePatternConverter$FormattedMessagePatternConverter(stringArray2);
        if (textRenderer != null) {
            messagePatternConverter = new MessagePatternConverter$RenderingPatternConverter(messagePatternConverter, textRenderer);
        }
        return messagePatternConverter;
    }

    private static String[] withoutLookupOptions(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return stringArray;
        }
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (String string : stringArray) {
            if (LOOKUPS.equalsIgnoreCase(string) || NOLOOKUPS.equalsIgnoreCase(string)) {
                LOGGER.info("The {} option will be ignored. Message Lookups are no longer supported.", (Object)string);
                continue;
            }
            arrayList.add(string);
        }
        return arrayList.toArray(Strings.EMPTY_ARRAY);
    }

    @Override
    public void format(LogEvent logEvent, StringBuilder stringBuilder) {
        throw new UnsupportedOperationException();
    }

    /* synthetic */ MessagePatternConverter(MessagePatternConverter$1 messagePatternConverter$1) {
        this();
    }
}

