/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import java.util.Objects;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.message.MapMessage;
import org.apache.logging.log4j.message.MapMessage$MapFormat;

@Plugin(name="MapPatternConverter", category="Converter")
@ConverterKeys(value={"K", "map", "MAP"})
public final class MapPatternConverter
extends LogEventPatternConverter {
    private static final String JAVA_UNQUOTED = MapMessage$MapFormat.JAVA_UNQUOTED.name();
    private final String key;
    private final String[] format;

    private MapPatternConverter(String[] stringArray, String ... stringArray2) {
        super(stringArray != null && stringArray.length > 0 ? "MAP{" + stringArray[0] + '}' : "MAP", "map");
        this.key = stringArray != null && stringArray.length > 0 ? stringArray[0] : null;
        this.format = stringArray2;
    }

    public static MapPatternConverter newInstance(String[] stringArray) {
        return new MapPatternConverter(stringArray, JAVA_UNQUOTED);
    }

    public static MapPatternConverter newInstance(String[] stringArray, MapMessage$MapFormat mapMessage$MapFormat) {
        return new MapPatternConverter(stringArray, Objects.toString((Object)mapMessage$MapFormat, JAVA_UNQUOTED));
    }

    @Override
    public void format(LogEvent logEvent, StringBuilder stringBuilder) {
        if (!(logEvent.getMessage() instanceof MapMessage)) {
            return;
        }
        MapMessage mapMessage = (MapMessage)logEvent.getMessage();
        if (this.key == null) {
            mapMessage.formatTo(this.format, stringBuilder);
        } else {
            String string = mapMessage.get(this.key);
            if (string != null) {
                stringBuilder.append(string);
            }
        }
    }
}

