/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import java.util.List;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.EncodingPatternConverter$EscapeFormat;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.core.pattern.PatternFormatter;
import org.apache.logging.log4j.core.pattern.PatternParser;
import org.apache.logging.log4j.util.EnglishEnums;
import org.apache.logging.log4j.util.PerformanceSensitive;

@Plugin(name="encode", category="Converter")
@ConverterKeys(value={"enc", "encode"})
@PerformanceSensitive(value={"allocation"})
public final class EncodingPatternConverter
extends LogEventPatternConverter {
    private final List<PatternFormatter> formatters;
    private final EncodingPatternConverter$EscapeFormat escapeFormat;

    private EncodingPatternConverter(List<PatternFormatter> list, EncodingPatternConverter$EscapeFormat encodingPatternConverter$EscapeFormat) {
        super("encode", "encode");
        this.formatters = list;
        this.escapeFormat = encodingPatternConverter$EscapeFormat;
    }

    @Override
    public boolean handlesThrowable() {
        return this.formatters != null && this.formatters.stream().map(PatternFormatter::getConverter).anyMatch(LogEventPatternConverter::handlesThrowable);
    }

    public static EncodingPatternConverter newInstance(Configuration configuration, String[] stringArray) {
        if (stringArray.length > 2 || stringArray.length == 0) {
            LOGGER.error("Incorrect number of options on escape. Expected 1 or 2, but received {}", (Object)stringArray.length);
            return null;
        }
        if (stringArray[0] == null) {
            LOGGER.error("No pattern supplied on escape");
            return null;
        }
        EncodingPatternConverter$EscapeFormat encodingPatternConverter$EscapeFormat = stringArray.length < 2 ? EncodingPatternConverter$EscapeFormat.HTML : EnglishEnums.valueOf(EncodingPatternConverter$EscapeFormat.class, stringArray[1], EncodingPatternConverter$EscapeFormat.HTML);
        PatternParser patternParser = PatternLayout.createPatternParser(configuration);
        List<PatternFormatter> list = patternParser.parse(stringArray[0]);
        return new EncodingPatternConverter(list, encodingPatternConverter$EscapeFormat);
    }

    @Override
    public void format(LogEvent logEvent, StringBuilder stringBuilder) {
        int n = stringBuilder.length();
        for (int i = 0; i < this.formatters.size(); ++i) {
            this.formatters.get(i).format(logEvent, stringBuilder);
        }
        this.escapeFormat.escape(stringBuilder, n);
    }
}

