/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.core.pattern.NameAbbreviator;

class DynamicWordAbbreviator
extends NameAbbreviator {
    private final int rightWordCount;

    static DynamicWordAbbreviator create(String string) {
        Matcher matcher;
        if (string != null && (matcher = Pattern.compile("1\\.([1-9][0-9]*)\\*").matcher(string)).matches()) {
            return new DynamicWordAbbreviator(Integer.parseInt(matcher.group(1)));
        }
        return null;
    }

    private DynamicWordAbbreviator(int n) {
        this.rightWordCount = n;
    }

    @Override
    public void abbreviate(String string, StringBuilder stringBuilder) {
        if (string == null || stringBuilder == null) {
            return;
        }
        String[] stringArray = DynamicWordAbbreviator.split(string, '.');
        int n = stringArray.length;
        if (this.rightWordCount >= n) {
            stringBuilder.append(string);
            return;
        }
        int n2 = n - this.rightWordCount;
        for (int i = 0; i < n; ++i) {
            if (i >= n2) {
                stringBuilder.append(stringArray[i]);
                if (i >= n - 1) continue;
                stringBuilder.append(".");
                continue;
            }
            if (stringArray[i].length() <= 0) continue;
            stringBuilder.append(stringArray[i].charAt(0)).append(".");
        }
    }

    static String[] split(String string, char c) {
        if (string == null) {
            return null;
        }
        if (string.isEmpty()) {
            return new String[0];
        }
        int n2 = string.chars().filter(n -> n == c).map(n -> 1).sum();
        String[] stringArray = new String[n2 + 1];
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while ((n5 = string.indexOf(c, n4)) > -1) {
            if (n4 < n5) {
                stringArray[n3++] = string.substring(n4, n5);
            }
            n4 = n5 + 1;
        }
        if (n4 < string.length()) {
            stringArray[n3++] = string.substring(n4);
        }
        if (n3 < stringArray.length) {
            return Arrays.copyOf(stringArray, n3);
        }
        return stringArray;
    }
}

