/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.net.ssl;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.net.ssl.KeyStoreConfiguration;
import org.apache.logging.log4j.core.net.ssl.SslConfiguration;
import org.apache.logging.log4j.core.net.ssl.TrustStoreConfiguration;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.PropertiesUtil;
import org.apache.logging.log4j.util.Strings;

public class SslConfigurationFactory {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static SslConfiguration sslConfiguration = SslConfigurationFactory.createSslConfiguration(PropertiesUtil.getProperties());
    private static final String trustStorelocation = "log4j2.trustStoreLocation";
    private static final String trustStorePassword = "log4j2.trustStorePassword";
    private static final String trustStorePasswordFile = "log4j2.trustStorePasswordFile";
    private static final String trustStorePasswordEnvVar = "log4j2.trustStorePasswordEnvironmentVariable";
    private static final String trustStoreKeyStoreType = "log4j2.trustStoreKeyStoreType";
    private static final String trustStoreKeyManagerFactoryAlgorithm = "log4j2.trustStoreKeyManagerFactoryAlgorithm";
    private static final String keyStoreLocation = "log4j2.keyStoreLocation";
    private static final String keyStorePassword = "log4j2.keyStorePassword";
    private static final String keyStorePasswordFile = "log4j2.keyStorePasswordFile";
    private static final String keyStorePasswordEnvVar = "log4j2.keyStorePasswordEnvironmentVariable";
    private static final String keyStoreType = "log4j2.keyStoreType";
    private static final String keyStoreKeyManagerFactoryAlgorithm = "log4j2.keyStoreKeyManagerFactoryAlgorithm";
    private static final String verifyHostName = "log4j2.sslVerifyHostName";

    static SslConfiguration createSslConfiguration(PropertiesUtil propertiesUtil) {
        char[] cArray;
        String string;
        KeyStoreConfiguration keyStoreConfiguration = null;
        TrustStoreConfiguration trustStoreConfiguration = null;
        String string2 = propertiesUtil.getStringProperty(trustStorelocation);
        String string3 = propertiesUtil.getStringProperty(trustStoreKeyStoreType);
        if (Strings.isNotEmpty(string2) || string3 != null) {
            string = propertiesUtil.getStringProperty(trustStorePassword);
            cArray = SslConfigurationFactory.getPassword(string, string3);
            try {
                trustStoreConfiguration = TrustStoreConfiguration.createKeyStoreConfiguration(Strings.trimToNull(string2), cArray, propertiesUtil.getStringProperty(trustStorePasswordEnvVar), propertiesUtil.getStringProperty(trustStorePasswordFile), string3, propertiesUtil.getStringProperty(trustStoreKeyManagerFactoryAlgorithm));
            }
            catch (Exception exception) {
                LOGGER.warn("Unable to create trust store configuration due to: {} {}", (Object)exception.getClass().getName(), (Object)exception.getMessage());
            }
        }
        string2 = propertiesUtil.getStringProperty(keyStoreLocation);
        string3 = propertiesUtil.getStringProperty(keyStoreType);
        if (Strings.isNotEmpty(string2) || string3 != null) {
            string = propertiesUtil.getStringProperty(keyStorePassword);
            cArray = SslConfigurationFactory.getPassword(string, string3);
            try {
                keyStoreConfiguration = KeyStoreConfiguration.createKeyStoreConfiguration(Strings.trimToNull(string2), cArray, propertiesUtil.getStringProperty(keyStorePasswordEnvVar), propertiesUtil.getStringProperty(keyStorePasswordFile), string3, propertiesUtil.getStringProperty(keyStoreKeyManagerFactoryAlgorithm));
            }
            catch (Exception exception) {
                LOGGER.warn("Unable to create key store configuration due to: {} {}", (Object)exception.getClass().getName(), (Object)exception.getMessage());
            }
        }
        if (trustStoreConfiguration != null || keyStoreConfiguration != null) {
            boolean bl = propertiesUtil.getBooleanProperty(verifyHostName, false);
            return SslConfiguration.createSSLConfiguration(null, keyStoreConfiguration, trustStoreConfiguration, bl);
        }
        return null;
    }

    private static char[] getPassword(String string, String string2) {
        if (string2.equals("JKS") || string2.equals("PKCS12")) {
            return string != null ? string.toCharArray() : null;
        }
        return Strings.isEmpty(string) ? null : string.toCharArray();
    }

    public static SslConfiguration getSslConfiguration() {
        return sslConfiguration;
    }
}

