/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.net;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.appender.AppenderLoggingException;
import org.apache.logging.log4j.core.net.AbstractSocketManager;
import org.apache.logging.log4j.core.net.SocketOptions;
import org.apache.logging.log4j.core.net.TcpSocketManager$FactoryData;
import org.apache.logging.log4j.core.net.TcpSocketManager$HostResolver;
import org.apache.logging.log4j.core.net.TcpSocketManager$Reconnector;
import org.apache.logging.log4j.core.net.TcpSocketManager$TcpSocketManagerFactory;
import org.apache.logging.log4j.util.Strings;

public class TcpSocketManager
extends AbstractSocketManager {
    public static final int DEFAULT_RECONNECTION_DELAY_MILLIS = 30000;
    private static final int DEFAULT_PORT = 4560;
    private static final TcpSocketManager$TcpSocketManagerFactory<TcpSocketManager, TcpSocketManager$FactoryData> FACTORY = new TcpSocketManager$TcpSocketManagerFactory();
    private final int reconnectionDelayMillis;
    private TcpSocketManager$Reconnector reconnector;
    private Socket socket;
    private final SocketOptions socketOptions;
    private final boolean retry;
    private final boolean immediateFail;
    private final int connectTimeoutMillis;

    @Deprecated
    public TcpSocketManager(String string, OutputStream outputStream, Socket socket, InetAddress inetAddress, String string2, int n, int n2, int n3, boolean bl, Layout<? extends Serializable> layout, int n4) {
        this(string, outputStream, socket, inetAddress, string2, n, n2, n3, bl, layout, n4, null);
    }

    public TcpSocketManager(String string, OutputStream outputStream, Socket socket, InetAddress inetAddress, String string2, int n, int n2, int n3, boolean bl, Layout<? extends Serializable> layout, int n4, SocketOptions socketOptions) {
        super(string, outputStream, inetAddress, string2, n, layout, true, n4);
        this.connectTimeoutMillis = n2;
        this.reconnectionDelayMillis = n3;
        this.socket = socket;
        this.immediateFail = bl;
        boolean bl2 = this.retry = n3 > 0;
        if (socket == null) {
            this.reconnector = this.createReconnector();
            this.reconnector.start();
        }
        this.socketOptions = socketOptions;
    }

    @Deprecated
    public static TcpSocketManager getSocketManager(String string, int n, int n2, int n3, boolean bl, Layout<? extends Serializable> layout, int n4) {
        return TcpSocketManager.getSocketManager(string, n, n2, n3, bl, layout, n4, null);
    }

    public static TcpSocketManager getSocketManager(String string, int n, int n2, int n3, boolean bl, Layout<? extends Serializable> layout, int n4, SocketOptions socketOptions) {
        if (Strings.isEmpty(string)) {
            throw new IllegalArgumentException("A host name is required");
        }
        if (n <= 0) {
            n = 4560;
        }
        if (n3 == 0) {
            n3 = 30000;
        }
        return (TcpSocketManager)TcpSocketManager.getManager("TCP:" + string + ':' + n, new TcpSocketManager$FactoryData(string, n, n2, n3, bl, layout, n4, socketOptions), FACTORY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void write(byte[] byArray, int n, int n2, boolean bl) {
        if (this.socket == null) {
            if (this.reconnector != null && !this.immediateFail) {
                this.reconnector.latch();
            }
            if (this.socket == null) {
                throw new AppenderLoggingException("Error writing to " + this.getName() + ": socket not available");
            }
        }
        TcpSocketManager tcpSocketManager = this;
        synchronized (tcpSocketManager) {
            try {
                this.writeAndFlush(byArray, n, n2, bl);
            }
            catch (IOException iOException) {
                String string = this.inetAddress + ":" + this.port;
                if (this.retry && this.reconnector == null) {
                    this.reconnector = this.createReconnector();
                    try {
                        this.reconnector.reconnect();
                    }
                    catch (IOException iOException2) {
                        LOGGER.debug("Cannot reestablish socket connection to {}: {}; starting reconnector thread {}", (Object)string, (Object)iOException2.getLocalizedMessage(), (Object)this.reconnector.getName(), (Object)iOException2);
                        this.reconnector.start();
                        throw new AppenderLoggingException(String.format("Error sending to %s for %s", this.getName(), string), iOException);
                    }
                    try {
                        this.writeAndFlush(byArray, n, n2, bl);
                    }
                    catch (IOException iOException3) {
                        throw new AppenderLoggingException(String.format("Error writing to %s after reestablishing connection for %s", this.getName(), string), iOException);
                    }
                    return;
                }
                String string2 = String.format("Error writing to %s for connection %s", this.getName(), string);
                throw new AppenderLoggingException(string2, iOException);
            }
        }
    }

    private void writeAndFlush(byte[] byArray, int n, int n2, boolean bl) {
        OutputStream outputStream = this.getOutputStream();
        outputStream.write(byArray, n, n2);
        if (bl) {
            outputStream.flush();
        }
    }

    @Override
    protected synchronized boolean closeOutputStream() {
        boolean bl = super.closeOutputStream();
        if (this.reconnector != null) {
            this.reconnector.shutdown();
            this.reconnector.interrupt();
            this.reconnector = null;
        }
        Socket socket = this.socket;
        this.socket = null;
        if (socket != null) {
            try {
                socket.close();
            }
            catch (IOException iOException) {
                LOGGER.error("Could not close socket {}", (Object)this.socket);
                return false;
            }
        }
        return bl;
    }

    public int getConnectTimeoutMillis() {
        return this.connectTimeoutMillis;
    }

    @Override
    public Map<String, String> getContentFormat() {
        HashMap<String, String> hashMap = new HashMap<String, String>(super.getContentFormat());
        hashMap.put("protocol", "tcp");
        hashMap.put("direction", "out");
        return hashMap;
    }

    private TcpSocketManager$Reconnector createReconnector() {
        TcpSocketManager$Reconnector tcpSocketManager$Reconnector = new TcpSocketManager$Reconnector(this, this);
        tcpSocketManager$Reconnector.setDaemon(true);
        tcpSocketManager$Reconnector.setPriority(1);
        return tcpSocketManager$Reconnector;
    }

    protected Socket createSocket(InetSocketAddress inetSocketAddress) {
        return TcpSocketManager.createSocket(inetSocketAddress, this.socketOptions, this.connectTimeoutMillis);
    }

    protected static Socket createSocket(InetSocketAddress inetSocketAddress, SocketOptions socketOptions, int n) {
        LOGGER.debug("Creating socket {}", (Object)inetSocketAddress.toString());
        Socket socket = new Socket();
        if (socketOptions != null) {
            socketOptions.apply(socket);
        }
        socket.connect(inetSocketAddress, n);
        if (socketOptions != null) {
            socketOptions.apply(socket);
        }
        return socket;
    }

    public static void setHostResolver(TcpSocketManager$HostResolver tcpSocketManager$HostResolver) {
        TcpSocketManager$TcpSocketManagerFactory.RESOLVER = tcpSocketManager$HostResolver;
    }

    public SocketOptions getSocketOptions() {
        return this.socketOptions;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public int getReconnectionDelayMillis() {
        return this.reconnectionDelayMillis;
    }

    public String toString() {
        return "TcpSocketManager [reconnectionDelayMillis=" + this.reconnectionDelayMillis + ", reconnector=" + this.reconnector + ", socket=" + this.socket + ", socketOptions=" + this.socketOptions + ", retry=" + this.retry + ", immediateFail=" + this.immediateFail + ", connectTimeoutMillis=" + this.connectTimeoutMillis + ", inetAddress=" + this.inetAddress + ", host=" + this.host + ", port=" + this.port + ", layout=" + this.layout + ", byteBuffer=" + this.byteBuffer + ", count=" + this.count + "]";
    }

    static /* synthetic */ int access$000(TcpSocketManager tcpSocketManager) {
        return tcpSocketManager.reconnectionDelayMillis;
    }

    static /* synthetic */ Logger access$100() {
        return LOGGER;
    }

    static /* synthetic */ Logger access$200() {
        return LOGGER;
    }

    static /* synthetic */ Logger access$300() {
        return LOGGER;
    }

    static /* synthetic */ Logger access$400() {
        return LOGGER;
    }

    static /* synthetic */ Logger access$500() {
        return LOGGER;
    }

    static /* synthetic */ Socket access$600(TcpSocketManager tcpSocketManager) {
        return tcpSocketManager.socket;
    }

    static /* synthetic */ OutputStream access$700(TcpSocketManager tcpSocketManager) {
        return tcpSocketManager.getOutputStream();
    }

    static /* synthetic */ void access$800(TcpSocketManager tcpSocketManager, OutputStream outputStream) {
        tcpSocketManager.setOutputStream(outputStream);
    }

    static /* synthetic */ Socket access$602(TcpSocketManager tcpSocketManager, Socket socket) {
        tcpSocketManager.socket = socket;
        return tcpSocketManager.socket;
    }

    static /* synthetic */ TcpSocketManager$Reconnector access$902(TcpSocketManager tcpSocketManager, TcpSocketManager$Reconnector tcpSocketManager$Reconnector) {
        tcpSocketManager.reconnector = tcpSocketManager$Reconnector;
        return tcpSocketManager.reconnector;
    }

    static /* synthetic */ Logger access$1000() {
        return LOGGER;
    }

    static /* synthetic */ Logger access$1100() {
        return LOGGER;
    }

    static /* synthetic */ Logger access$1200() {
        return LOGGER;
    }
}

