/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.net;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import javax.mail.util.ByteArrayDataSource;
import org.apache.logging.log4j.LoggingException;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.layout.AbstractStringLayout$Serializer;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.net.MailManager;
import org.apache.logging.log4j.core.net.MailManager$FactoryData;
import org.apache.logging.log4j.core.net.MimeMessageBuilder;
import org.apache.logging.log4j.core.net.SmtpManager$SMTPManagerFactory;
import org.apache.logging.log4j.core.net.ssl.SslConfiguration;
import org.apache.logging.log4j.core.util.CyclicBuffer;

public class SmtpManager
extends MailManager {
    public static final SmtpManager$SMTPManagerFactory FACTORY = new SmtpManager$SMTPManagerFactory();
    private final Session session;
    private final CyclicBuffer<LogEvent> buffer;
    private volatile MimeMessage message;
    private final MailManager$FactoryData data;

    private static MimeMessage createMimeMessage(MailManager$FactoryData mailManager$FactoryData, Session session, LogEvent logEvent) {
        return new MimeMessageBuilder(session).setFrom(mailManager$FactoryData.getFrom()).setReplyTo(mailManager$FactoryData.getReplyTo()).setRecipients(Message.RecipientType.TO, mailManager$FactoryData.getTo()).setRecipients(Message.RecipientType.CC, mailManager$FactoryData.getCc()).setRecipients(Message.RecipientType.BCC, mailManager$FactoryData.getBcc()).setSubject(mailManager$FactoryData.getSubjectSerializer().toSerializable(logEvent)).build();
    }

    protected SmtpManager(String string, Session session, MimeMessage mimeMessage, MailManager$FactoryData mailManager$FactoryData) {
        super(null, string);
        this.session = session;
        this.message = mimeMessage;
        this.data = mailManager$FactoryData;
        this.buffer = new CyclicBuffer<LogEvent>(LogEvent.class, mailManager$FactoryData.getBufferSize());
    }

    @Override
    public void add(LogEvent logEvent) {
        this.buffer.add(logEvent.toImmutable());
    }

    @Deprecated
    public static SmtpManager getSmtpManager(Configuration configuration, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, int n, String string9, String string10, boolean bl, String string11, int n2, SslConfiguration sslConfiguration) {
        AbstractStringLayout$Serializer abstractStringLayout$Serializer = PatternLayout.newSerializerBuilder().setConfiguration(configuration).setPattern(string6).build();
        MailManager$FactoryData mailManager$FactoryData = new MailManager$FactoryData(string, string2, string3, string4, string5, string6, abstractStringLayout$Serializer, string7, string8, n, string9, string10, bl, n2, sslConfiguration, string11);
        return (SmtpManager)SmtpManager.getManager(mailManager$FactoryData.getManagerName(), FACTORY, mailManager$FactoryData);
    }

    @Override
    public void sendEvents(Layout<?> layout, LogEvent logEvent) {
        if (this.message == null) {
            this.connect(logEvent);
        }
        try {
            LogEvent[] logEventArray = this.removeAllBufferedEvents();
            byte[] byArray = this.formatContentToBytes(logEventArray, logEvent, layout);
            String string = layout.getContentType();
            String string2 = this.getEncoding(byArray, string);
            byte[] byArray2 = this.encodeContentToBytes(byArray, string2);
            InternetHeaders internetHeaders = this.getHeaders(string, string2);
            MimeMultipart mimeMultipart = this.getMimeMultipart(byArray2, internetHeaders);
            String string3 = this.data.getSubjectSerializer().toSerializable(logEvent);
            this.sendMultipartMessage(this.message, mimeMultipart, string3);
        }
        catch (IOException | RuntimeException | MessagingException throwable) {
            this.logError("Caught exception while sending e-mail notification.", throwable);
            throw new LoggingException("Error occurred while sending email", throwable);
        }
    }

    LogEvent[] removeAllBufferedEvents() {
        return this.buffer.removeAll();
    }

    protected byte[] formatContentToBytes(LogEvent[] logEventArray, LogEvent logEvent, Layout<?> layout) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.writeContent(logEventArray, logEvent, layout, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    private void writeContent(LogEvent[] logEventArray, LogEvent logEvent, Layout<?> layout, ByteArrayOutputStream byteArrayOutputStream) {
        this.writeHeader(layout, byteArrayOutputStream);
        this.writeBuffer(logEventArray, logEvent, layout, byteArrayOutputStream);
        this.writeFooter(layout, byteArrayOutputStream);
    }

    protected void writeHeader(Layout<?> layout, OutputStream outputStream) {
        byte[] byArray = layout.getHeader();
        if (byArray != null) {
            outputStream.write(byArray);
        }
    }

    protected void writeBuffer(LogEvent[] logEventArray, LogEvent logEvent, Layout<?> layout, OutputStream outputStream) {
        for (LogEvent logEvent2 : logEventArray) {
            byte[] byArray = layout.toByteArray(logEvent2);
            outputStream.write(byArray);
        }
        byte[] byArray = layout.toByteArray(logEvent);
        outputStream.write(byArray);
    }

    protected void writeFooter(Layout<?> layout, OutputStream outputStream) {
        byte[] byArray = layout.getFooter();
        if (byArray != null) {
            outputStream.write(byArray);
        }
    }

    protected String getEncoding(byte[] byArray, String string) {
        ByteArrayDataSource byteArrayDataSource = new ByteArrayDataSource(byArray, string);
        return MimeUtility.getEncoding((DataSource)byteArrayDataSource);
    }

    protected byte[] encodeContentToBytes(byte[] byArray, String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.encodeContent(byArray, string, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    protected void encodeContent(byte[] byArray, String string, ByteArrayOutputStream byteArrayOutputStream) {
        try (OutputStream outputStream = MimeUtility.encode((OutputStream)byteArrayOutputStream, (String)string);){
            outputStream.write(byArray);
        }
    }

    protected InternetHeaders getHeaders(String string, String string2) {
        InternetHeaders internetHeaders = new InternetHeaders();
        internetHeaders.setHeader("Content-Type", string + "; charset=UTF-8");
        internetHeaders.setHeader("Content-Transfer-Encoding", string2);
        return internetHeaders;
    }

    protected MimeMultipart getMimeMultipart(byte[] byArray, InternetHeaders internetHeaders) {
        MimeMultipart mimeMultipart = new MimeMultipart();
        MimeBodyPart mimeBodyPart = new MimeBodyPart(internetHeaders, byArray);
        mimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
        return mimeMultipart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    protected void sendMultipartMessage(MimeMessage mimeMessage, MimeMultipart mimeMultipart) {
        MimeMessage mimeMessage2 = mimeMessage;
        synchronized (mimeMessage2) {
            mimeMessage.setContent((Multipart)mimeMultipart);
            mimeMessage.setSentDate(new Date());
            Transport.send((Message)mimeMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendMultipartMessage(MimeMessage mimeMessage, MimeMultipart mimeMultipart, String string) {
        MimeMessage mimeMessage2 = mimeMessage;
        synchronized (mimeMessage2) {
            mimeMessage.setContent((Multipart)mimeMultipart);
            mimeMessage.setSentDate(new Date());
            mimeMessage.setSubject(string);
            Transport.send((Message)mimeMessage);
        }
    }

    private synchronized void connect(LogEvent logEvent) {
        if (this.message != null) {
            return;
        }
        try {
            this.message = SmtpManager.createMimeMessage(this.data, this.session, logEvent);
        }
        catch (MessagingException messagingException) {
            this.logError("Could not set SmtpAppender message options", messagingException);
            this.message = null;
        }
    }
}

