/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.lookup;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.lookup.LookupResult;
import org.apache.logging.log4j.core.lookup.PropertiesLookup$ConfigurationPropertyResult;
import org.apache.logging.log4j.core.lookup.PropertiesLookup$ContextPropertyResult;
import org.apache.logging.log4j.core.lookup.StrLookup;

public final class PropertiesLookup
implements StrLookup {
    private final Map<String, String> contextProperties;
    private final Map<String, PropertiesLookup$ConfigurationPropertyResult> configurationProperties;

    public PropertiesLookup(Property[] propertyArray, Map<String, String> map) {
        this.contextProperties = map == null ? Collections.emptyMap() : map;
        this.configurationProperties = propertyArray == null ? Collections.emptyMap() : PropertiesLookup.createConfigurationPropertyMap(propertyArray);
    }

    public PropertiesLookup(Map<String, String> map) {
        this(Property.EMPTY_ARRAY, map);
    }

    @Override
    public String lookup(LogEvent logEvent, String string) {
        return this.lookup(string);
    }

    @Override
    public String lookup(String string) {
        LookupResult lookupResult = this.evaluate(string);
        return lookupResult == null ? null : lookupResult.value();
    }

    @Override
    public LookupResult evaluate(String string) {
        if (string == null) {
            return null;
        }
        LookupResult lookupResult = this.configurationProperties.get(string);
        if (lookupResult != null) {
            return lookupResult;
        }
        String string2 = this.contextProperties.get(string);
        return string2 == null ? null : new PropertiesLookup$ContextPropertyResult(string2);
    }

    @Override
    public LookupResult evaluate(LogEvent logEvent, String string) {
        return this.evaluate(string);
    }

    public String toString() {
        return "PropertiesLookup{contextProperties=" + this.contextProperties + ", configurationProperties=" + this.configurationProperties + '}';
    }

    private static Map<String, PropertiesLookup$ConfigurationPropertyResult> createConfigurationPropertyMap(Property[] propertyArray) {
        HashMap<String, PropertiesLookup$ConfigurationPropertyResult> hashMap = new HashMap<String, PropertiesLookup$ConfigurationPropertyResult>(propertyArray.length);
        for (Property property : propertyArray) {
            hashMap.put(property.getName(), new PropertiesLookup$ConfigurationPropertyResult(property.getRawValue()));
        }
        return hashMap;
    }
}

