/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.SimpleBindings;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.impl.LocationAware;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.layout.PatternMatch;
import org.apache.logging.log4j.core.layout.PatternSelector;
import org.apache.logging.log4j.core.layout.ScriptPatternSelector$1;
import org.apache.logging.log4j.core.layout.ScriptPatternSelector$Builder;
import org.apache.logging.log4j.core.pattern.PatternFormatter;
import org.apache.logging.log4j.core.pattern.PatternParser;
import org.apache.logging.log4j.core.script.AbstractScript;
import org.apache.logging.log4j.core.script.ScriptRef;
import org.apache.logging.log4j.status.StatusLogger;

@Plugin(name="ScriptPatternSelector", category="Core", elementType="patternSelector", printObject=true)
public class ScriptPatternSelector
implements LocationAware,
PatternSelector {
    private final Map<String, PatternFormatter[]> formatterMap = new HashMap<String, PatternFormatter[]>();
    private final Map<String, String> patternMap = new HashMap<String, String>();
    private final PatternFormatter[] defaultFormatters;
    private final String defaultPattern;
    private static Logger LOGGER = StatusLogger.getLogger();
    private final AbstractScript script;
    private final Configuration configuration;
    private final boolean requiresLocation;

    private ScriptPatternSelector(Configuration configuration, AbstractScript abstractScript, PatternMatch[] patternMatchArray, String string, boolean bl, boolean bl2, boolean bl3) {
        this.script = abstractScript;
        this.configuration = configuration;
        PatternParser patternParser = PatternLayout.createPatternParser(configuration);
        boolean bl4 = false;
        for (PatternMatch patternMatch : patternMatchArray) {
            try {
                List<PatternFormatter> list = patternParser.parse(patternMatch.getPattern(), bl, bl2, bl3);
                PatternFormatter[] patternFormatterArray = list.toArray(PatternFormatter.EMPTY_ARRAY);
                this.formatterMap.put(patternMatch.getKey(), patternFormatterArray);
                this.patternMap.put(patternMatch.getKey(), patternMatch.getPattern());
                for (int i = 0; !bl4 && i < patternFormatterArray.length; ++i) {
                    bl4 = patternFormatterArray[i].requiresLocation();
                }
            }
            catch (RuntimeException runtimeException) {
                throw new IllegalArgumentException("Cannot parse pattern '" + patternMatch.getPattern() + "'", runtimeException);
            }
        }
        try {
            List<PatternFormatter> list = patternParser.parse(string, bl, bl2, bl3);
            this.defaultFormatters = list.toArray(PatternFormatter.EMPTY_ARRAY);
            this.defaultPattern = string;
            for (int i = 0; !bl4 && i < this.defaultFormatters.length; ++i) {
                bl4 = this.defaultFormatters[i].requiresLocation();
            }
        }
        catch (RuntimeException runtimeException) {
            throw new IllegalArgumentException("Cannot parse pattern '" + string + "'", runtimeException);
        }
        this.requiresLocation = bl4;
    }

    @Deprecated
    public ScriptPatternSelector(AbstractScript abstractScript, PatternMatch[] patternMatchArray, String string, boolean bl, boolean bl2, boolean bl3, Configuration configuration) {
        this.script = abstractScript;
        this.configuration = configuration;
        if (!(abstractScript instanceof ScriptRef)) {
            configuration.getScriptManager().addScript(abstractScript);
        }
        PatternParser patternParser = PatternLayout.createPatternParser(configuration);
        boolean bl4 = false;
        for (PatternMatch patternMatch : patternMatchArray) {
            try {
                List<PatternFormatter> list = patternParser.parse(patternMatch.getPattern(), bl, bl2, bl3);
                PatternFormatter[] patternFormatterArray = list.toArray(PatternFormatter.EMPTY_ARRAY);
                this.formatterMap.put(patternMatch.getKey(), patternFormatterArray);
                this.patternMap.put(patternMatch.getKey(), patternMatch.getPattern());
                for (int i = 0; !bl4 && i < patternFormatterArray.length; ++i) {
                    bl4 = patternFormatterArray[i].requiresLocation();
                }
            }
            catch (RuntimeException runtimeException) {
                throw new IllegalArgumentException("Cannot parse pattern '" + patternMatch.getPattern() + "'", runtimeException);
            }
        }
        try {
            List<PatternFormatter> list = patternParser.parse(string, bl, bl2, bl3);
            this.defaultFormatters = list.toArray(PatternFormatter.EMPTY_ARRAY);
            this.defaultPattern = string;
            for (int i = 0; !bl4 && i < this.defaultFormatters.length; ++i) {
                bl4 = this.defaultFormatters[i].requiresLocation();
            }
        }
        catch (RuntimeException runtimeException) {
            throw new IllegalArgumentException("Cannot parse pattern '" + string + "'", runtimeException);
        }
        this.requiresLocation = bl4;
    }

    @Override
    public boolean requiresLocation() {
        return this.requiresLocation;
    }

    @Override
    public PatternFormatter[] getFormatters(LogEvent logEvent) {
        SimpleBindings simpleBindings = new SimpleBindings();
        simpleBindings.putAll((Map<? extends String, ? extends Object>)this.configuration.getProperties());
        simpleBindings.put("substitutor", (Object)this.configuration.getStrSubstitutor());
        simpleBindings.put("logEvent", (Object)logEvent);
        Object object = this.configuration.getScriptManager().execute(this.script.getName(), simpleBindings);
        if (object == null) {
            return this.defaultFormatters;
        }
        PatternFormatter[] patternFormatterArray = this.formatterMap.get(object.toString());
        return patternFormatterArray == null ? this.defaultFormatters : patternFormatterArray;
    }

    @PluginBuilderFactory
    public static ScriptPatternSelector$Builder newBuilder() {
        return new ScriptPatternSelector$Builder(null);
    }

    @Deprecated
    public static ScriptPatternSelector createSelector(AbstractScript abstractScript, PatternMatch[] patternMatchArray, String string, boolean bl, boolean bl2, Configuration configuration) {
        ScriptPatternSelector$Builder scriptPatternSelector$Builder = ScriptPatternSelector.newBuilder();
        scriptPatternSelector$Builder.setScript(abstractScript);
        scriptPatternSelector$Builder.setProperties(patternMatchArray);
        scriptPatternSelector$Builder.setDefaultPattern(string);
        scriptPatternSelector$Builder.setAlwaysWriteExceptions(bl);
        scriptPatternSelector$Builder.setNoConsoleNoAnsi(bl2);
        scriptPatternSelector$Builder.setConfiguration(configuration);
        return scriptPatternSelector$Builder.build();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (Map.Entry<String, String> entry : this.patternMap.entrySet()) {
            if (!bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("key=\"").append(entry.getKey()).append("\", pattern=\"").append(entry.getValue()).append("\"");
            bl = false;
        }
        if (!bl) {
            stringBuilder.append(", ");
        }
        stringBuilder.append("default=\"").append(this.defaultPattern).append("\"");
        return stringBuilder.toString();
    }

    static /* synthetic */ Logger access$000() {
        return LOGGER;
    }

    /* synthetic */ ScriptPatternSelector(Configuration configuration, AbstractScript abstractScript, PatternMatch[] patternMatchArray, String string, boolean bl, boolean bl2, boolean bl3, ScriptPatternSelector$1 scriptPatternSelector$1) {
        this(configuration, abstractScript, patternMatchArray, string, bl, bl2, bl3);
    }
}

