/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.impl.LocationAware;
import org.apache.logging.log4j.core.layout.MarkerPatternSelector$1;
import org.apache.logging.log4j.core.layout.MarkerPatternSelector$Builder;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.layout.PatternMatch;
import org.apache.logging.log4j.core.layout.PatternSelector;
import org.apache.logging.log4j.core.pattern.PatternFormatter;
import org.apache.logging.log4j.core.pattern.PatternParser;
import org.apache.logging.log4j.status.StatusLogger;

@Plugin(name="MarkerPatternSelector", category="Core", elementType="patternSelector", printObject=true)
public class MarkerPatternSelector
implements LocationAware,
PatternSelector {
    private final Map<String, PatternFormatter[]> formatterMap = new HashMap<String, PatternFormatter[]>();
    private final Map<String, String> patternMap = new HashMap<String, String>();
    private final PatternFormatter[] defaultFormatters;
    private final String defaultPattern;
    private static Logger LOGGER = StatusLogger.getLogger();
    private final boolean requiresLocation;

    @Deprecated
    public MarkerPatternSelector(PatternMatch[] patternMatchArray, String string, boolean bl, boolean bl2, Configuration configuration) {
        this(patternMatchArray, string, bl, false, bl2, configuration);
    }

    private MarkerPatternSelector(PatternMatch[] patternMatchArray, String string, boolean bl, boolean bl2, boolean bl3, Configuration configuration) {
        boolean bl4 = false;
        PatternParser patternParser = PatternLayout.createPatternParser(configuration);
        for (PatternMatch patternMatch : patternMatchArray) {
            try {
                List<PatternFormatter> list = patternParser.parse(patternMatch.getPattern(), bl, bl2, bl3);
                PatternFormatter[] patternFormatterArray = list.toArray(PatternFormatter.EMPTY_ARRAY);
                this.formatterMap.put(patternMatch.getKey(), patternFormatterArray);
                for (int i = 0; !bl4 && i < patternFormatterArray.length; ++i) {
                    bl4 = patternFormatterArray[i].requiresLocation();
                }
                this.patternMap.put(patternMatch.getKey(), patternMatch.getPattern());
            }
            catch (RuntimeException runtimeException) {
                throw new IllegalArgumentException("Cannot parse pattern '" + patternMatch.getPattern() + "'", runtimeException);
            }
        }
        try {
            List<PatternFormatter> list = patternParser.parse(string, bl, bl2, bl3);
            this.defaultFormatters = list.toArray(PatternFormatter.EMPTY_ARRAY);
            this.defaultPattern = string;
            for (int i = 0; !bl4 && i < this.defaultFormatters.length; ++i) {
                bl4 = this.defaultFormatters[i].requiresLocation();
            }
        }
        catch (RuntimeException runtimeException) {
            throw new IllegalArgumentException("Cannot parse pattern '" + string + "'", runtimeException);
        }
        this.requiresLocation = bl4;
    }

    @Override
    public boolean requiresLocation() {
        return this.requiresLocation;
    }

    @Override
    public PatternFormatter[] getFormatters(LogEvent logEvent) {
        Marker marker = logEvent.getMarker();
        if (marker == null) {
            return this.defaultFormatters;
        }
        for (String string : this.formatterMap.keySet()) {
            if (!marker.isInstanceOf(string)) continue;
            return this.formatterMap.get(string);
        }
        return this.defaultFormatters;
    }

    @PluginBuilderFactory
    public static MarkerPatternSelector$Builder newBuilder() {
        return new MarkerPatternSelector$Builder();
    }

    @Deprecated
    public static MarkerPatternSelector createSelector(PatternMatch[] patternMatchArray, String string, boolean bl, boolean bl2, Configuration configuration) {
        MarkerPatternSelector$Builder markerPatternSelector$Builder = MarkerPatternSelector.newBuilder();
        markerPatternSelector$Builder.setProperties(patternMatchArray);
        markerPatternSelector$Builder.setDefaultPattern(string);
        markerPatternSelector$Builder.setAlwaysWriteExceptions(bl);
        markerPatternSelector$Builder.setNoConsoleNoAnsi(bl2);
        markerPatternSelector$Builder.setConfiguration(configuration);
        return markerPatternSelector$Builder.build();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (Map.Entry<String, String> entry : this.patternMap.entrySet()) {
            if (!bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("key=\"").append(entry.getKey()).append("\", pattern=\"").append(entry.getValue()).append("\"");
            bl = false;
        }
        if (!bl) {
            stringBuilder.append(", ");
        }
        stringBuilder.append("default=\"").append(this.defaultPattern).append("\"");
        return stringBuilder.toString();
    }

    static /* synthetic */ Logger access$000() {
        return LOGGER;
    }

    /* synthetic */ MarkerPatternSelector(PatternMatch[] patternMatchArray, String string, boolean bl, boolean bl2, boolean bl3, Configuration configuration, MarkerPatternSelector$1 markerPatternSelector$1) {
        this(patternMatchArray, string, bl, bl2, bl3, configuration);
    }
}

