/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.zip.DeflaterOutputStream;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.layout.AbstractStringLayout;
import org.apache.logging.log4j.core.layout.ByteBufferDestination;
import org.apache.logging.log4j.core.layout.Encoder;
import org.apache.logging.log4j.core.layout.GelfLayout$1;
import org.apache.logging.log4j.core.layout.GelfLayout$Builder;
import org.apache.logging.log4j.core.layout.GelfLayout$CompressionType;
import org.apache.logging.log4j.core.layout.GelfLayout$FieldWriter;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.layout.internal.ListChecker;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;
import org.apache.logging.log4j.core.net.Severity;
import org.apache.logging.log4j.core.util.JsonUtils;
import org.apache.logging.log4j.core.util.KeyValuePair;
import org.apache.logging.log4j.core.util.NetUtils;
import org.apache.logging.log4j.message.MapMessage;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.StringBuilderFormattable;
import org.apache.logging.log4j.util.Strings;

@Plugin(name="GelfLayout", category="Core", elementType="layout", printObject=true)
public final class GelfLayout
extends AbstractStringLayout {
    private static final char C = ',';
    private static final int COMPRESSION_THRESHOLD = 1024;
    private static final char Q = '\"';
    private static final String QC = "\",";
    private static final String QU = "\"_";
    private final KeyValuePair[] additionalFields;
    private final int compressionThreshold;
    private final GelfLayout$CompressionType compressionType;
    private final String host;
    private final boolean includeStacktrace;
    private final boolean includeThreadContext;
    private final boolean includeMapMessage;
    private final boolean includeNullDelimiter;
    private final boolean includeNewLineDelimiter;
    private final boolean omitEmptyFields;
    private final PatternLayout layout;
    private final GelfLayout$FieldWriter mdcWriter;
    private final GelfLayout$FieldWriter mapWriter;
    private static final ThreadLocal<StringBuilder> messageStringBuilder = new ThreadLocal();
    private static final ThreadLocal<StringBuilder> timestampStringBuilder = new ThreadLocal();

    @Deprecated
    public GelfLayout(String string, KeyValuePair[] keyValuePairArray, GelfLayout$CompressionType gelfLayout$CompressionType, int n, boolean bl) {
        this(null, string, keyValuePairArray, gelfLayout$CompressionType, n, bl, true, true, false, false, false, null, null, null, "", "");
    }

    private GelfLayout(Configuration configuration, String string, KeyValuePair[] keyValuePairArray, GelfLayout$CompressionType gelfLayout$CompressionType, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, ListChecker listChecker, ListChecker listChecker2, PatternLayout patternLayout, String string2, String string3) {
        super(configuration, StandardCharsets.UTF_8, null, null);
        this.host = string != null ? string : NetUtils.getLocalHostname();
        KeyValuePair[] keyValuePairArray2 = this.additionalFields = keyValuePairArray != null ? keyValuePairArray : KeyValuePair.EMPTY_ARRAY;
        if (configuration == null) {
            for (KeyValuePair keyValuePair : this.additionalFields) {
                if (!GelfLayout.valueNeedsLookup(keyValuePair.getValue())) continue;
                throw new IllegalArgumentException("configuration needs to be set when there are additional fields with variables");
            }
        }
        this.compressionType = gelfLayout$CompressionType;
        this.compressionThreshold = n;
        this.includeStacktrace = bl;
        this.includeThreadContext = bl2;
        this.includeMapMessage = bl3;
        this.includeNullDelimiter = bl4;
        this.includeNewLineDelimiter = bl5;
        this.omitEmptyFields = bl6;
        if (bl4 && gelfLayout$CompressionType != GelfLayout$CompressionType.OFF) {
            throw new IllegalArgumentException("null delimiter cannot be used with compression");
        }
        this.mdcWriter = new GelfLayout$FieldWriter(this, listChecker, string2);
        this.mapWriter = new GelfLayout$FieldWriter(this, listChecker2, string3);
        this.layout = patternLayout;
    }

    public String toString() {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("host=").append(this.host);
        stringBuilder.append(", compressionType=").append(this.compressionType.toString());
        stringBuilder.append(", compressionThreshold=").append(this.compressionThreshold);
        stringBuilder.append(", includeStackTrace=").append(this.includeStacktrace);
        stringBuilder.append(", includeThreadContext=").append(this.includeThreadContext);
        stringBuilder.append(", includeNullDelimiter=").append(this.includeNullDelimiter);
        stringBuilder.append(", includeNewLineDelimiter=").append(this.includeNewLineDelimiter);
        String string2 = this.mdcWriter.getChecker().toString();
        if (string2.length() > 0) {
            stringBuilder.append(", ").append(string2);
        }
        if ((string = this.mapWriter.getChecker().toString()).length() > 0) {
            stringBuilder.append(", ").append(string);
        }
        if (this.layout != null) {
            stringBuilder.append(", PatternLayout{").append(this.layout.toString()).append("}");
        }
        return stringBuilder.toString();
    }

    @Deprecated
    public static GelfLayout createLayout(@PluginAttribute(value="host") String string, @PluginElement(value="AdditionalField") KeyValuePair[] keyValuePairArray, @PluginAttribute(value="compressionType", defaultString="GZIP") GelfLayout$CompressionType gelfLayout$CompressionType, @PluginAttribute(value="compressionThreshold", defaultInt=1024) int n, @PluginAttribute(value="includeStacktrace", defaultBoolean=true) boolean bl) {
        return new GelfLayout(null, string, keyValuePairArray, gelfLayout$CompressionType, n, bl, true, true, false, false, false, null, null, null, "", "");
    }

    @PluginBuilderFactory
    public static <B extends GelfLayout$Builder<B>> B newBuilder() {
        return (B)((GelfLayout$Builder)new GelfLayout$Builder().asBuilder());
    }

    @Override
    public Map<String, String> getContentFormat() {
        return Collections.emptyMap();
    }

    @Override
    public String getContentType() {
        return "application/json; charset=" + this.getCharset();
    }

    @Override
    public byte[] toByteArray(LogEvent logEvent) {
        StringBuilder stringBuilder = this.toText(logEvent, GelfLayout.getStringBuilder(), false);
        byte[] byArray = this.getBytes(stringBuilder.toString());
        return this.compressionType != GelfLayout$CompressionType.OFF && byArray.length > this.compressionThreshold ? this.compress(byArray) : byArray;
    }

    @Override
    public void encode(LogEvent logEvent, ByteBufferDestination byteBufferDestination) {
        if (this.compressionType != GelfLayout$CompressionType.OFF) {
            super.encode(logEvent, byteBufferDestination);
            return;
        }
        StringBuilder stringBuilder = this.toText(logEvent, GelfLayout.getStringBuilder(), true);
        Encoder<StringBuilder> encoder = this.getStringBuilderEncoder();
        encoder.encode(stringBuilder, byteBufferDestination);
    }

    @Override
    public boolean requiresLocation() {
        return Objects.nonNull(this.layout) && this.layout.requiresLocation();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] compress(byte[] byArray) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.compressionThreshold / 8);
            try (DeflaterOutputStream deflaterOutputStream = this.compressionType.createDeflaterOutputStream(byteArrayOutputStream);){
                if (deflaterOutputStream == null) {
                    byte[] byArray2 = byArray;
                    return byArray2;
                }
                deflaterOutputStream.write(byArray);
                deflaterOutputStream.finish();
                return byteArrayOutputStream.toByteArray();
            }
        }
        catch (IOException iOException) {
            StatusLogger.getLogger().error(iOException);
            return byArray;
        }
    }

    @Override
    public String toSerializable(LogEvent logEvent) {
        StringBuilder stringBuilder = this.toText(logEvent, GelfLayout.getStringBuilder(), false);
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuilder toText(LogEvent logEvent, StringBuilder stringBuilder, boolean bl) {
        Object object2;
        stringBuilder.append('{');
        stringBuilder.append("\"version\":\"1.1\",");
        stringBuilder.append("\"host\":\"");
        JsonUtils.quoteAsString(GelfLayout.toNullSafeString(this.host), stringBuilder);
        stringBuilder.append(QC);
        stringBuilder.append("\"timestamp\":").append(GelfLayout.formatTimestamp(logEvent.getTimeMillis())).append(',');
        stringBuilder.append("\"level\":").append(this.formatLevel(logEvent.getLevel())).append(',');
        if (logEvent.getThreadName() != null) {
            stringBuilder.append("\"_thread\":\"");
            JsonUtils.quoteAsString(logEvent.getThreadName(), stringBuilder);
            stringBuilder.append(QC);
        }
        if (logEvent.getLoggerName() != null) {
            stringBuilder.append("\"_logger\":\"");
            JsonUtils.quoteAsString(logEvent.getLoggerName(), stringBuilder);
            stringBuilder.append(QC);
        }
        if (this.additionalFields.length > 0) {
            object2 = this.getConfiguration().getStrSubstitutor();
            for (KeyValuePair keyValuePair : this.additionalFields) {
                String string2;
                String string3 = string2 = GelfLayout.valueNeedsLookup(keyValuePair.getValue()) ? ((StrSubstitutor)object2).replace(logEvent, keyValuePair.getValue()) : keyValuePair.getValue();
                if (!Strings.isNotEmpty(string2) && this.omitEmptyFields) continue;
                stringBuilder.append(QU);
                JsonUtils.quoteAsString(keyValuePair.getKey(), stringBuilder);
                stringBuilder.append("\":\"");
                JsonUtils.quoteAsString(GelfLayout.toNullSafeString(string2), stringBuilder);
                stringBuilder.append(QC);
            }
        }
        if (this.includeThreadContext) {
            logEvent.getContextData().forEach(this.mdcWriter, stringBuilder);
        }
        if (this.includeMapMessage && logEvent.getMessage() instanceof MapMessage) {
            ((MapMessage)logEvent.getMessage()).forEach((string, object) -> this.mapWriter.accept((String)string, object, stringBuilder));
        }
        if (logEvent.getThrown() != null || this.layout != null) {
            stringBuilder.append("\"full_message\":\"");
            if (this.layout != null) {
                object2 = GelfLayout.getMessageStringBuilder();
                this.layout.serialize(logEvent, (StringBuilder)object2);
                JsonUtils.quoteAsString((CharSequence)object2, stringBuilder);
            } else if (this.includeStacktrace) {
                JsonUtils.quoteAsString(GelfLayout.formatThrowable(logEvent.getThrown()), stringBuilder);
            } else {
                JsonUtils.quoteAsString(logEvent.getThrown().toString(), stringBuilder);
            }
            stringBuilder.append(QC);
        }
        stringBuilder.append("\"short_message\":\"");
        object2 = logEvent.getMessage();
        if (object2 instanceof CharSequence) {
            JsonUtils.quoteAsString((CharSequence)object2, stringBuilder);
        } else if (bl && object2 instanceof StringBuilderFormattable) {
            StringBuilder stringBuilder2 = GelfLayout.getMessageStringBuilder();
            try {
                ((StringBuilderFormattable)object2).formatTo(stringBuilder2);
                JsonUtils.quoteAsString(stringBuilder2, stringBuilder);
            }
            finally {
                GelfLayout.trimToMaxSize(stringBuilder2);
            }
        } else {
            JsonUtils.quoteAsString(GelfLayout.toNullSafeString(object2.getFormattedMessage()), stringBuilder);
        }
        stringBuilder.append('\"');
        stringBuilder.append('}');
        if (this.includeNullDelimiter) {
            stringBuilder.append('\u0000');
        }
        if (this.includeNewLineDelimiter) {
            stringBuilder.append('\n');
        }
        return stringBuilder;
    }

    private static boolean valueNeedsLookup(String string) {
        return string != null && string.contains("${");
    }

    private static StringBuilder getMessageStringBuilder() {
        StringBuilder stringBuilder = messageStringBuilder.get();
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder(1024);
            messageStringBuilder.set(stringBuilder);
        }
        stringBuilder.setLength(0);
        return stringBuilder;
    }

    private static CharSequence toNullSafeString(CharSequence charSequence) {
        return charSequence == null ? "" : charSequence;
    }

    static CharSequence formatTimestamp(long l) {
        if (l < 1000L) {
            return "0";
        }
        StringBuilder stringBuilder = GelfLayout.getTimestampStringBuilder();
        stringBuilder.append(l);
        stringBuilder.insert(stringBuilder.length() - 3, '.');
        return stringBuilder;
    }

    private static StringBuilder getTimestampStringBuilder() {
        StringBuilder stringBuilder = timestampStringBuilder.get();
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder(20);
            timestampStringBuilder.set(stringBuilder);
        }
        stringBuilder.setLength(0);
        return stringBuilder;
    }

    private int formatLevel(Level level) {
        return Severity.getSeverity(level).getCode();
    }

    static CharSequence formatThrowable(Throwable throwable) {
        StringWriter stringWriter = new StringWriter(2048);
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        printWriter.flush();
        return stringWriter.getBuffer();
    }

    /* synthetic */ GelfLayout(Configuration configuration, String string, KeyValuePair[] keyValuePairArray, GelfLayout$CompressionType gelfLayout$CompressionType, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, ListChecker listChecker, ListChecker listChecker2, PatternLayout patternLayout, String string2, String string3, GelfLayout$1 gelfLayout$1) {
        this(configuration, string, keyValuePairArray, gelfLayout$CompressionType, n, bl, bl2, bl3, bl4, bl5, bl6, listChecker, listChecker2, patternLayout, string2, string3);
    }

    static /* synthetic */ boolean access$200(GelfLayout gelfLayout) {
        return gelfLayout.omitEmptyFields;
    }

    static /* synthetic */ CharSequence access$300(CharSequence charSequence) {
        return GelfLayout.toNullSafeString(charSequence);
    }
}

