/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.layout.AbstractLayout;
import org.apache.logging.log4j.core.layout.AbstractStringLayout$Builder;
import org.apache.logging.log4j.core.layout.GelfLayout;
import org.apache.logging.log4j.core.layout.GelfLayout$CompressionType;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.layout.PatternSelector;
import org.apache.logging.log4j.core.layout.internal.ExcludeChecker;
import org.apache.logging.log4j.core.layout.internal.IncludeChecker;
import org.apache.logging.log4j.core.layout.internal.ListChecker;
import org.apache.logging.log4j.core.util.Builder;
import org.apache.logging.log4j.core.util.KeyValuePair;
import org.apache.logging.log4j.core.util.Patterns;

public class GelfLayout$Builder<B extends GelfLayout$Builder<B>>
extends AbstractStringLayout$Builder<B>
implements Builder<GelfLayout> {
    @PluginBuilderAttribute
    private String host;
    @PluginElement(value="AdditionalField")
    private KeyValuePair[] additionalFields;
    @PluginBuilderAttribute
    private GelfLayout$CompressionType compressionType = GelfLayout$CompressionType.GZIP;
    @PluginBuilderAttribute
    private int compressionThreshold = 1024;
    @PluginBuilderAttribute
    private boolean includeStacktrace = true;
    @PluginBuilderAttribute
    private boolean includeThreadContext = true;
    @PluginBuilderAttribute
    private boolean includeNullDelimiter;
    @PluginBuilderAttribute
    private boolean includeNewLineDelimiter;
    @PluginBuilderAttribute
    private String threadContextIncludes;
    @PluginBuilderAttribute
    private String threadContextExcludes;
    @PluginBuilderAttribute
    private String mapMessageIncludes;
    @PluginBuilderAttribute
    private String mapMessageExcludes;
    @PluginBuilderAttribute
    private boolean includeMapMessage = true;
    @PluginBuilderAttribute
    private boolean omitEmptyFields;
    @PluginBuilderAttribute
    private String messagePattern;
    @PluginBuilderAttribute
    private String threadContextPrefix = "";
    @PluginBuilderAttribute
    private String mapPrefix = "";
    @PluginElement(value="PatternSelector")
    private PatternSelector patternSelector;

    public GelfLayout$Builder() {
        this.setCharset(StandardCharsets.UTF_8);
    }

    @Override
    public GelfLayout build() {
        ListChecker listChecker = this.createChecker(this.threadContextExcludes, this.threadContextIncludes);
        ListChecker listChecker2 = this.createChecker(this.mapMessageExcludes, this.mapMessageIncludes);
        PatternLayout patternLayout = null;
        if (this.messagePattern != null && this.patternSelector != null) {
            AbstractLayout.LOGGER.error("A message pattern and PatternSelector cannot both be specified on GelfLayout, ignoring message pattern");
            this.messagePattern = null;
        }
        if (this.messagePattern != null) {
            patternLayout = PatternLayout.newBuilder().withPattern(this.messagePattern).withAlwaysWriteExceptions(this.includeStacktrace).withConfiguration(this.getConfiguration()).build();
        }
        if (this.patternSelector != null) {
            patternLayout = PatternLayout.newBuilder().withPatternSelector(this.patternSelector).withAlwaysWriteExceptions(this.includeStacktrace).withConfiguration(this.getConfiguration()).build();
        }
        return new GelfLayout(this.getConfiguration(), this.host, this.additionalFields, this.compressionType, this.compressionThreshold, this.includeStacktrace, this.includeThreadContext, this.includeMapMessage, this.includeNullDelimiter, this.includeNewLineDelimiter, this.omitEmptyFields, listChecker, listChecker2, patternLayout, this.threadContextPrefix, this.mapPrefix, null);
    }

    private ListChecker createChecker(String string, String string2) {
        ArrayList<String> arrayList;
        String[] stringArray;
        ListChecker listChecker = null;
        if (string != null && (stringArray = string.split(Patterns.COMMA_SEPARATOR)).length > 0) {
            arrayList = new ArrayList<String>(stringArray.length);
            for (String string3 : stringArray) {
                arrayList.add(string3.trim());
            }
            listChecker = new ExcludeChecker(arrayList);
        }
        if (string2 != null && (stringArray = string2.split(Patterns.COMMA_SEPARATOR)).length > 0) {
            arrayList = new ArrayList(stringArray.length);
            for (String string3 : stringArray) {
                arrayList.add(string3.trim());
            }
            listChecker = new IncludeChecker(arrayList);
        }
        if (listChecker == null) {
            listChecker = ListChecker.NOOP_CHECKER;
        }
        return listChecker;
    }

    public String getHost() {
        return this.host;
    }

    public GelfLayout$CompressionType getCompressionType() {
        return this.compressionType;
    }

    public int getCompressionThreshold() {
        return this.compressionThreshold;
    }

    public boolean isIncludeStacktrace() {
        return this.includeStacktrace;
    }

    public boolean isIncludeThreadContext() {
        return this.includeThreadContext;
    }

    public boolean isIncludeNullDelimiter() {
        return this.includeNullDelimiter;
    }

    public boolean isIncludeNewLineDelimiter() {
        return this.includeNewLineDelimiter;
    }

    public KeyValuePair[] getAdditionalFields() {
        return this.additionalFields;
    }

    public B setHost(String string) {
        this.host = string;
        return (B)((GelfLayout$Builder)this.asBuilder());
    }

    public B setCompressionType(GelfLayout$CompressionType gelfLayout$CompressionType) {
        this.compressionType = gelfLayout$CompressionType;
        return (B)((GelfLayout$Builder)this.asBuilder());
    }

    public B setCompressionThreshold(int n) {
        this.compressionThreshold = n;
        return (B)((GelfLayout$Builder)this.asBuilder());
    }

    public B setIncludeStacktrace(boolean bl) {
        this.includeStacktrace = bl;
        return (B)((GelfLayout$Builder)this.asBuilder());
    }

    public B setIncludeThreadContext(boolean bl) {
        this.includeThreadContext = bl;
        return (B)((GelfLayout$Builder)this.asBuilder());
    }

    public B setIncludeNullDelimiter(boolean bl) {
        this.includeNullDelimiter = bl;
        return (B)((GelfLayout$Builder)this.asBuilder());
    }

    public B setIncludeNewLineDelimiter(boolean bl) {
        this.includeNewLineDelimiter = bl;
        return (B)((GelfLayout$Builder)this.asBuilder());
    }

    public B setAdditionalFields(KeyValuePair[] keyValuePairArray) {
        this.additionalFields = keyValuePairArray;
        return (B)((GelfLayout$Builder)this.asBuilder());
    }

    public B setMessagePattern(String string) {
        this.messagePattern = string;
        return (B)((GelfLayout$Builder)this.asBuilder());
    }

    public B setPatternSelector(PatternSelector patternSelector) {
        this.patternSelector = patternSelector;
        return (B)((GelfLayout$Builder)this.asBuilder());
    }

    public B setMdcIncludes(String string) {
        this.threadContextIncludes = string;
        return (B)((GelfLayout$Builder)this.asBuilder());
    }

    public B setMdcExcludes(String string) {
        this.threadContextExcludes = string;
        return (B)((GelfLayout$Builder)this.asBuilder());
    }

    public B setIncludeMapMessage(boolean bl) {
        this.includeMapMessage = bl;
        return (B)((GelfLayout$Builder)this.asBuilder());
    }

    public B setMapMessageIncludes(String string) {
        this.mapMessageIncludes = string;
        return (B)((GelfLayout$Builder)this.asBuilder());
    }

    public B setMapMessageExcludes(String string) {
        this.mapMessageExcludes = string;
        return (B)((GelfLayout$Builder)this.asBuilder());
    }

    public B setThreadContextPrefix(String string) {
        if (string != null) {
            this.threadContextPrefix = string;
        }
        return (B)((GelfLayout$Builder)this.asBuilder());
    }

    public B setMapPrefix(String string) {
        if (string != null) {
            this.mapPrefix = string;
        }
        return (B)((GelfLayout$Builder)this.asBuilder());
    }
}

