/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.StringLayout;
import org.apache.logging.log4j.core.config.AbstractConfiguration;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.impl.DefaultLogEventFactory;
import org.apache.logging.log4j.core.impl.LocationAware;
import org.apache.logging.log4j.core.layout.AbstractLayout;
import org.apache.logging.log4j.core.layout.AbstractStringLayout$Serializer;
import org.apache.logging.log4j.core.layout.Encoder;
import org.apache.logging.log4j.core.layout.StringBuilderEncoder;
import org.apache.logging.log4j.core.util.Constants;
import org.apache.logging.log4j.core.util.StringEncoder;
import org.apache.logging.log4j.spi.AbstractLogger;
import org.apache.logging.log4j.util.PropertiesUtil;
import org.apache.logging.log4j.util.StringBuilders;

public abstract class AbstractStringLayout
extends AbstractLayout<String>
implements StringLayout,
LocationAware {
    protected static final int DEFAULT_STRING_BUILDER_SIZE = 1024;
    protected static final int MAX_STRING_BUILDER_SIZE = Math.max(1024, AbstractStringLayout.size("log4j.layoutStringBuilder.maxSize", 2048));
    private static final ThreadLocal<StringBuilder> threadLocal = new ThreadLocal();
    private Encoder<StringBuilder> textEncoder;
    private final Charset charset;
    private final AbstractStringLayout$Serializer footerSerializer;
    private final AbstractStringLayout$Serializer headerSerializer;

    @Override
    public boolean requiresLocation() {
        return false;
    }

    protected static StringBuilder getStringBuilder() {
        if (AbstractLogger.getRecursionDepth() > 1) {
            return new StringBuilder(1024);
        }
        StringBuilder stringBuilder = threadLocal.get();
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder(1024);
            threadLocal.set(stringBuilder);
        }
        AbstractStringLayout.trimToMaxSize(stringBuilder);
        stringBuilder.setLength(0);
        return stringBuilder;
    }

    private static int size(String string, int n) {
        return PropertiesUtil.getProperties().getIntegerProperty(string, n);
    }

    protected static void trimToMaxSize(StringBuilder stringBuilder) {
        StringBuilders.trimToMaxSize(stringBuilder, MAX_STRING_BUILDER_SIZE);
    }

    protected AbstractStringLayout(Charset charset) {
        this(charset, (byte[])null, (byte[])null);
    }

    protected AbstractStringLayout(Charset charset, byte[] byArray, byte[] byArray2) {
        super(null, byArray, byArray2);
        this.headerSerializer = null;
        this.footerSerializer = null;
        this.charset = charset == null ? StandardCharsets.UTF_8 : charset;
        this.textEncoder = Constants.ENABLE_DIRECT_ENCODERS ? new StringBuilderEncoder(this.charset) : null;
    }

    protected AbstractStringLayout(Configuration configuration, Charset charset, AbstractStringLayout$Serializer abstractStringLayout$Serializer, AbstractStringLayout$Serializer abstractStringLayout$Serializer2) {
        super(configuration, null, null);
        this.headerSerializer = abstractStringLayout$Serializer;
        this.footerSerializer = abstractStringLayout$Serializer2;
        this.charset = charset == null ? StandardCharsets.UTF_8 : charset;
        this.textEncoder = Constants.ENABLE_DIRECT_ENCODERS ? new StringBuilderEncoder(this.charset) : null;
    }

    protected byte[] getBytes(String string) {
        return string.getBytes(this.charset);
    }

    @Override
    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public String getContentType() {
        return "text/plain";
    }

    @Override
    public byte[] getFooter() {
        return this.serializeToBytes(this.footerSerializer, super.getFooter());
    }

    public AbstractStringLayout$Serializer getFooterSerializer() {
        return this.footerSerializer;
    }

    @Override
    public byte[] getHeader() {
        return this.serializeToBytes(this.headerSerializer, super.getHeader());
    }

    public AbstractStringLayout$Serializer getHeaderSerializer() {
        return this.headerSerializer;
    }

    private DefaultLogEventFactory getLogEventFactory() {
        return DefaultLogEventFactory.getInstance();
    }

    protected Encoder<StringBuilder> getStringBuilderEncoder() {
        if (this.textEncoder == null) {
            this.textEncoder = new StringBuilderEncoder(this.getCharset());
        }
        return this.textEncoder;
    }

    protected byte[] serializeToBytes(AbstractStringLayout$Serializer abstractStringLayout$Serializer, byte[] byArray) {
        String string = this.serializeToString(abstractStringLayout$Serializer);
        if (string == null) {
            return byArray;
        }
        return StringEncoder.toBytes(string, this.getCharset());
    }

    protected String serializeToString(AbstractStringLayout$Serializer abstractStringLayout$Serializer) {
        Level level;
        String string;
        Object object;
        if (abstractStringLayout$Serializer == null) {
            return null;
        }
        if (this.configuration != null) {
            object = this.configuration.getRootLogger();
            string = ((LoggerConfig)object).getName();
            level = ((LoggerConfig)object).getLevel();
        } else {
            string = "";
            level = AbstractConfiguration.getDefaultLevel();
        }
        object = this.getLogEventFactory().createEvent(string, null, "", level, null, null, null);
        return abstractStringLayout$Serializer.toSerializable((LogEvent)object);
    }

    @Override
    public byte[] toByteArray(LogEvent logEvent) {
        return this.getBytes((String)this.toSerializable(logEvent));
    }
}

