/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.util.Map;
import org.apache.logging.log4j.util.ReadOnlyStringMap;
import org.apache.logging.log4j.util.TriConsumer;

public class ContextDataSerializer
extends StdSerializer<ReadOnlyStringMap> {
    private static final long serialVersionUID = 1L;
    private static final TriConsumer<String, Object, JsonGenerator> WRITE_STRING_FIELD_INTO = (string, object, jsonGenerator) -> {
        try {
            if (object == null) {
                jsonGenerator.writeNullField(string);
            } else {
                jsonGenerator.writeStringField(string, String.valueOf(object));
            }
        }
        catch (Exception exception) {
            throw new IllegalStateException("Problem with key " + string, exception);
        }
    };

    protected ContextDataSerializer() {
        super(Map.class, false);
    }

    public void serialize(ReadOnlyStringMap readOnlyStringMap, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        jsonGenerator.writeStartObject();
        readOnlyStringMap.forEach(WRITE_STRING_FIELD_INTO, jsonGenerator);
        jsonGenerator.writeEndObject();
    }
}

