/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.impl;

import java.net.URL;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.core.impl.ExtendedClassInfo;
import org.apache.logging.log4j.core.impl.ExtendedStackTraceElement;
import org.apache.logging.log4j.core.impl.ThrowableProxy;
import org.apache.logging.log4j.core.impl.ThrowableProxyHelper$CacheEntry;
import org.apache.logging.log4j.core.util.Loader;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.LoaderUtil;

class ThrowableProxyHelper {
    private ThrowableProxyHelper() {
    }

    static ExtendedStackTraceElement[] toExtendedStackTrace(ThrowableProxy throwableProxy, Deque<Class<?>> deque, Map<String, ThrowableProxyHelper$CacheEntry> map, StackTraceElement[] stackTraceElementArray, StackTraceElement[] stackTraceElementArray2) {
        int n;
        if (stackTraceElementArray != null) {
            int n2;
            int n3 = stackTraceElementArray.length - 1;
            for (n2 = stackTraceElementArray2.length - 1; n3 >= 0 && n2 >= 0 && stackTraceElementArray[n3].equals(stackTraceElementArray2[n2]); --n3, --n2) {
            }
            throwableProxy.setCommonElementCount(stackTraceElementArray2.length - 1 - n2);
            n = n2 + 1;
        } else {
            throwableProxy.setCommonElementCount(0);
            n = stackTraceElementArray2.length;
        }
        ExtendedStackTraceElement[] extendedStackTraceElementArray = new ExtendedStackTraceElement[n];
        Class<?> clazz = deque.isEmpty() ? null : deque.peekLast();
        ClassLoader classLoader = null;
        for (int i = n - 1; i >= 0; --i) {
            ExtendedClassInfo extendedClassInfo;
            ThrowableProxyHelper$CacheEntry throwableProxyHelper$CacheEntry;
            StackTraceElement stackTraceElement = stackTraceElementArray2[i];
            String string = stackTraceElement.getClassName();
            if (clazz != null && string.equals(clazz.getName())) {
                throwableProxyHelper$CacheEntry = ThrowableProxyHelper.toCacheEntry(clazz, true);
                extendedClassInfo = ThrowableProxyHelper$CacheEntry.access$000(throwableProxyHelper$CacheEntry);
                classLoader = ThrowableProxyHelper$CacheEntry.access$100(throwableProxyHelper$CacheEntry);
                deque.pollLast();
                clazz = deque.peekLast();
            } else {
                ThrowableProxyHelper$CacheEntry throwableProxyHelper$CacheEntry2;
                throwableProxyHelper$CacheEntry = map.get(string);
                if (throwableProxyHelper$CacheEntry != null) {
                    throwableProxyHelper$CacheEntry2 = throwableProxyHelper$CacheEntry;
                    extendedClassInfo = ThrowableProxyHelper$CacheEntry.access$000(throwableProxyHelper$CacheEntry2);
                    if (ThrowableProxyHelper$CacheEntry.access$100(throwableProxyHelper$CacheEntry2) != null) {
                        classLoader = ThrowableProxyHelper$CacheEntry.access$100(throwableProxyHelper$CacheEntry2);
                    }
                } else {
                    throwableProxyHelper$CacheEntry2 = ThrowableProxyHelper.toCacheEntry(ThrowableProxyHelper.loadClass(classLoader, string), false);
                    extendedClassInfo = ThrowableProxyHelper$CacheEntry.access$000(throwableProxyHelper$CacheEntry2);
                    map.put(string, throwableProxyHelper$CacheEntry2);
                    if (ThrowableProxyHelper$CacheEntry.access$100(throwableProxyHelper$CacheEntry2) != null) {
                        classLoader = ThrowableProxyHelper$CacheEntry.access$100(throwableProxyHelper$CacheEntry2);
                    }
                }
            }
            extendedStackTraceElementArray[i] = new ExtendedStackTraceElement(stackTraceElement, extendedClassInfo);
        }
        return extendedStackTraceElementArray;
    }

    static ThrowableProxy[] toSuppressedProxies(Throwable throwable, Set<Throwable> set) {
        try {
            Throwable[] throwableArray = throwable.getSuppressed();
            if (throwableArray == null || throwableArray.length == 0) {
                return ThrowableProxy.EMPTY_ARRAY;
            }
            ArrayList<ThrowableProxy> arrayList = new ArrayList<ThrowableProxy>(throwableArray.length);
            if (set == null) {
                set = new HashSet<Throwable>(throwableArray.length);
            }
            for (int i = 0; i < throwableArray.length; ++i) {
                Throwable throwable2 = throwableArray[i];
                if (!set.add(throwable2)) continue;
                arrayList.add(new ThrowableProxy(throwable2, set));
            }
            return arrayList.toArray(ThrowableProxy.EMPTY_ARRAY);
        }
        catch (Exception exception) {
            StatusLogger.getLogger().error(exception);
            return null;
        }
    }

    private static ThrowableProxyHelper$CacheEntry toCacheEntry(Class<?> clazz, boolean bl) {
        String string = "?";
        Object object = "?";
        ClassLoader classLoader = null;
        if (clazz != null) {
            Object object2;
            Object object3;
            try {
                object3 = clazz.getProtectionDomain().getCodeSource();
                if (object3 != null && (object2 = ((CodeSource)object3).getLocation()) != null) {
                    String string2 = ((URL)object2).toString().replace('\\', '/');
                    int n = string2.lastIndexOf("/");
                    if (n >= 0 && n == string2.length() - 1) {
                        n = string2.lastIndexOf("/", n - 1);
                    }
                    string = string2.substring(n + 1);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            object3 = clazz.getPackage();
            if (object3 != null && (object2 = ((Package)object3).getImplementationVersion()) != null) {
                object = object2;
            }
            try {
                classLoader = clazz.getClassLoader();
            }
            catch (SecurityException securityException) {
                classLoader = null;
            }
        }
        return new ThrowableProxyHelper$CacheEntry(new ExtendedClassInfo(bl, string, (String)object), classLoader, null);
    }

    private static Class<?> loadClass(ClassLoader classLoader, String string) {
        Class<?> clazz;
        if (classLoader != null) {
            try {
                clazz = classLoader.loadClass(string);
                if (clazz != null) {
                    return clazz;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        try {
            clazz = LoaderUtil.loadClass(string);
        }
        catch (ClassNotFoundException | NoClassDefFoundError throwable) {
            return ThrowableProxyHelper.loadClass(string);
        }
        catch (SecurityException securityException) {
            return null;
        }
        return clazz;
    }

    private static Class<?> loadClass(String string) {
        try {
            return Loader.loadClass(string, ThrowableProxyHelper.class.getClassLoader());
        }
        catch (ClassNotFoundException | NoClassDefFoundError | SecurityException throwable) {
            return null;
        }
    }
}

