/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config.plugins.processor;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.TreeMap;
import org.apache.logging.log4j.core.config.plugins.processor.PluginEntry;

public class PluginCache {
    private final Map<String, Map<String, PluginEntry>> categories = new TreeMap<String, Map<String, PluginEntry>>();

    public Map<String, Map<String, PluginEntry>> getAllCategories() {
        return this.categories;
    }

    public Map<String, PluginEntry> getCategory(String string2) {
        String string3 = string2.toLowerCase();
        return this.categories.computeIfAbsent(string3, string -> new TreeMap());
    }

    public void writeCache(OutputStream outputStream) {
        try (DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(outputStream));){
            dataOutputStream.writeInt(this.categories.size());
            for (Map.Entry<String, Map<String, PluginEntry>> entry : this.categories.entrySet()) {
                dataOutputStream.writeUTF(entry.getKey());
                Map<String, PluginEntry> map = entry.getValue();
                dataOutputStream.writeInt(map.size());
                for (Map.Entry<String, PluginEntry> entry2 : map.entrySet()) {
                    PluginEntry pluginEntry = entry2.getValue();
                    dataOutputStream.writeUTF(pluginEntry.getKey());
                    dataOutputStream.writeUTF(pluginEntry.getClassName());
                    dataOutputStream.writeUTF(pluginEntry.getName());
                    dataOutputStream.writeBoolean(pluginEntry.isPrintable());
                    dataOutputStream.writeBoolean(pluginEntry.isDefer());
                }
            }
        }
    }

    public void loadCacheFiles(Enumeration<URL> enumeration) {
        this.categories.clear();
        while (enumeration.hasMoreElements()) {
            URL uRL = enumeration.nextElement();
            DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(uRL.openStream()));
            Throwable throwable = null;
            try {
                int n = dataInputStream.readInt();
                for (int i = 0; i < n; ++i) {
                    String string = dataInputStream.readUTF();
                    Map<String, PluginEntry> map = this.getCategory(string);
                    int n2 = dataInputStream.readInt();
                    for (int j = 0; j < n2; ++j) {
                        String string2 = dataInputStream.readUTF();
                        String string3 = dataInputStream.readUTF();
                        String string5 = dataInputStream.readUTF();
                        boolean bl = dataInputStream.readBoolean();
                        boolean bl2 = dataInputStream.readBoolean();
                        map.computeIfAbsent(string2, string4 -> {
                            PluginEntry pluginEntry = new PluginEntry();
                            pluginEntry.setKey((String)string4);
                            pluginEntry.setClassName(string3);
                            pluginEntry.setName(string5);
                            pluginEntry.setPrintable(bl);
                            pluginEntry.setDefer(bl2);
                            pluginEntry.setCategory(string);
                            return pluginEntry;
                        });
                    }
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dataInputStream == null) continue;
                if (throwable != null) {
                    try {
                        dataInputStream.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                dataInputStream.close();
            }
        }
    }

    public int size() {
        return this.categories.size();
    }
}

