/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.LoggerConfig$LevelAndRefs;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.apache.logging.log4j.core.util.Builder;

public class LoggerConfig$Builder<B extends LoggerConfig$Builder<B>>
implements Builder<LoggerConfig> {
    @PluginBuilderAttribute
    private Boolean additivity;
    @PluginBuilderAttribute
    private Level level;
    @PluginBuilderAttribute
    private String levelAndRefs;
    @PluginBuilderAttribute(value="name")
    @Required(message="Loggers cannot be configured without a name")
    private String loggerName;
    @PluginBuilderAttribute
    private String includeLocation;
    @PluginElement(value="AppenderRef")
    private AppenderRef[] refs;
    @PluginElement(value="Properties")
    private Property[] properties;
    @PluginConfiguration
    private Configuration config;
    @PluginElement(value="Filter")
    private Filter filter;

    public boolean isAdditivity() {
        return this.additivity == null || this.additivity != false;
    }

    public B withAdditivity(boolean bl) {
        this.additivity = bl;
        return this.asBuilder();
    }

    public Level getLevel() {
        return this.level;
    }

    public B withLevel(Level level) {
        this.level = level;
        return this.asBuilder();
    }

    public String getLevelAndRefs() {
        return this.levelAndRefs;
    }

    public B withLevelAndRefs(String string) {
        this.levelAndRefs = string;
        return this.asBuilder();
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    public B withLoggerName(String string) {
        this.loggerName = string;
        return this.asBuilder();
    }

    public String getIncludeLocation() {
        return this.includeLocation;
    }

    public B withIncludeLocation(String string) {
        this.includeLocation = string;
        return this.asBuilder();
    }

    public AppenderRef[] getRefs() {
        return this.refs;
    }

    public B withRefs(AppenderRef[] appenderRefArray) {
        this.refs = appenderRefArray;
        return this.asBuilder();
    }

    public Property[] getProperties() {
        return this.properties;
    }

    public B withProperties(Property[] propertyArray) {
        this.properties = propertyArray;
        return this.asBuilder();
    }

    public Configuration getConfig() {
        return this.config;
    }

    public B withConfig(Configuration configuration) {
        this.config = configuration;
        return this.asBuilder();
    }

    public Filter getFilter() {
        return this.filter;
    }

    public B withtFilter(Filter filter) {
        this.filter = filter;
        return this.asBuilder();
    }

    @Override
    public LoggerConfig build() {
        String string = this.loggerName.equals("root") ? "" : this.loggerName;
        LoggerConfig$LevelAndRefs loggerConfig$LevelAndRefs = LoggerConfig.getLevelAndRefs(this.level, this.refs, this.levelAndRefs, this.config);
        boolean bl = LoggerConfig.includeLocation(this.includeLocation, this.config);
        return new LoggerConfig(string, loggerConfig$LevelAndRefs.refs, this.filter, loggerConfig$LevelAndRefs.level, this.isAdditivity(), this.properties, this.config, bl);
    }

    public B asBuilder() {
        return (B)this;
    }
}

