/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.config.ConfigurationListener;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.Reconfigurable;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAliases;
import org.apache.logging.log4j.core.net.ssl.SslConfiguration;
import org.apache.logging.log4j.core.net.ssl.SslConfigurationFactory;
import org.apache.logging.log4j.core.util.AbstractWatcher;
import org.apache.logging.log4j.core.util.AuthorizationProvider;
import org.apache.logging.log4j.core.util.Source;
import org.apache.logging.log4j.core.util.Watcher;
import org.apache.logging.log4j.core.util.internal.HttpInputStreamUtil;
import org.apache.logging.log4j.core.util.internal.HttpInputStreamUtil$Result;
import org.apache.logging.log4j.core.util.internal.LastModifiedSource;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.PropertiesUtil;

@Plugin(name="http", category="Watcher", elementType="watcher", printObject=true)
@PluginAliases(value={"https"})
public class HttpWatcher
extends AbstractWatcher {
    private final Logger LOGGER = StatusLogger.getLogger();
    private final SslConfiguration sslConfiguration = SslConfigurationFactory.getSslConfiguration();
    private AuthorizationProvider authorizationProvider;
    private URL url;
    private volatile long lastModifiedMillis;
    private static final String HTTP = "http";
    private static final String HTTPS = "https";

    public HttpWatcher(Configuration configuration, Reconfigurable reconfigurable, List<ConfigurationListener> list, long l) {
        super(configuration, reconfigurable, list);
        this.lastModifiedMillis = l;
    }

    @Override
    public long getLastModified() {
        return this.lastModifiedMillis;
    }

    @Override
    public boolean isModified() {
        return this.refreshConfiguration();
    }

    @Override
    public void watching(Source source) {
        if (!source.getURI().getScheme().equals(HTTP) && !source.getURI().getScheme().equals(HTTPS)) {
            throw new IllegalArgumentException("HttpWatcher requires a url using the HTTP or HTTPS protocol, not " + source.getURI().getScheme());
        }
        try {
            this.url = source.getURI().toURL();
            this.authorizationProvider = ConfigurationFactory.authorizationProvider(PropertiesUtil.getProperties());
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException("Invalid URL for HttpWatcher " + source.getURI(), malformedURLException);
        }
        super.watching(source);
    }

    @Override
    public Watcher newWatcher(Reconfigurable reconfigurable, List<ConfigurationListener> list, long l) {
        HttpWatcher httpWatcher = new HttpWatcher(this.getConfiguration(), reconfigurable, list, l);
        if (this.getSource() != null) {
            httpWatcher.watching(this.getSource());
        }
        return httpWatcher;
    }

    private boolean refreshConfiguration() {
        try {
            LastModifiedSource lastModifiedSource = new LastModifiedSource(this.url.toURI(), this.lastModifiedMillis);
            HttpInputStreamUtil$Result httpInputStreamUtil$Result = HttpInputStreamUtil.getInputStream(lastModifiedSource, this.authorizationProvider);
            switch (httpInputStreamUtil$Result.getStatus()) {
                case NOT_MODIFIED: {
                    this.LOGGER.debug("Configuration Not Modified");
                    return false;
                }
                case SUCCESS: {
                    ConfigurationSource configurationSource = this.getConfiguration().getConfigurationSource();
                    try {
                        configurationSource.setData(HttpInputStreamUtil.readStream(httpInputStreamUtil$Result.getInputStream()));
                        configurationSource.setModifiedMillis(lastModifiedSource.getLastModified());
                        this.LOGGER.debug("Content was modified for {}", (Object)this.url.toString());
                        return true;
                    }
                    catch (IOException iOException) {
                        this.LOGGER.error("Error accessing configuration at {}: {}", (Object)this.url, (Object)iOException.getMessage());
                        return false;
                    }
                }
                case NOT_FOUND: {
                    this.LOGGER.info("Unable to locate configuration at {}", (Object)this.url.toString());
                    return false;
                }
            }
            this.LOGGER.warn("Unexpected error accessing configuration at {}", (Object)this.url.toString());
            return false;
        }
        catch (URISyntaxException uRISyntaxException) {
            this.LOGGER.error("Bad configuration URL: {}, {}", (Object)this.url.toString(), (Object)uRISyntaxException.getMessage());
            return false;
        }
    }
}

