/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.ArrayList;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.AbstractConfiguration;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.config.ConfigurationFactory$1;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.DefaultConfiguration;
import org.apache.logging.log4j.core.config.composite.CompositeConfiguration;
import org.apache.logging.log4j.core.util.NetUtils;
import org.apache.logging.log4j.util.LoaderUtil;
import org.apache.logging.log4j.util.PropertiesUtil;
import org.apache.logging.log4j.util.Strings;

class ConfigurationFactory$Factory
extends ConfigurationFactory {
    private static final String ALL_TYPES = "*";

    private ConfigurationFactory$Factory() {
    }

    @Override
    public Configuration getConfiguration(LoggerContext loggerContext, String string, URI uRI) {
        Object object;
        if (uRI == null) {
            object = this.substitutor.replace(PropertiesUtil.getProperties().getStringProperty("log4j.configurationFile"));
            if (object != null) {
                String[] stringArray = this.parseConfigLocations((String)object);
                if (stringArray.length > 1) {
                    ArrayList<AbstractConfiguration> arrayList = new ArrayList<AbstractConfiguration>();
                    for (String string2 : stringArray) {
                        Configuration configuration = this.getConfiguration(loggerContext, string2.trim());
                        if (configuration != null) {
                            if (configuration instanceof AbstractConfiguration) {
                                arrayList.add((AbstractConfiguration)configuration);
                                continue;
                            }
                            LOGGER.error("Failed to created configuration at {}", (Object)string2);
                            return null;
                        }
                        LOGGER.warn("Unable to create configuration for {}, ignoring", (Object)string2);
                    }
                    if (arrayList.size() > 1) {
                        return new CompositeConfiguration(arrayList);
                    }
                    if (arrayList.size() == 1) {
                        return (Configuration)arrayList.get(0);
                    }
                }
                return this.getConfiguration(loggerContext, (String)object);
            }
            String string3 = this.substitutor.replace(PropertiesUtil.getProperties().getStringProperty("log4j.configuration"));
            if (string3 != null) {
                System.setProperty("log4j1.compatibility", "true");
                return this.getConfiguration("1", loggerContext, string3);
            }
            for (ConfigurationFactory configurationFactory : ConfigurationFactory$Factory.getFactories()) {
                String[] stringArray = configurationFactory.getSupportedTypes();
                if (stringArray == null) continue;
                for (String string4 : stringArray) {
                    Configuration configuration;
                    if (!string4.equals(ALL_TYPES) || (configuration = configurationFactory.getConfiguration(loggerContext, string, uRI)) == null) continue;
                    return configuration;
                }
            }
        } else {
            object = this.parseConfigLocations(uRI);
            if (((String[])object).length > 1) {
                ArrayList<AbstractConfiguration> arrayList = new ArrayList<AbstractConfiguration>();
                for (String string5 : object) {
                    Configuration configuration = this.getConfiguration(loggerContext, string5.trim());
                    if (!(configuration instanceof AbstractConfiguration)) {
                        LOGGER.error("Failed to created configuration at {}", (Object)string5);
                        return null;
                    }
                    arrayList.add((AbstractConfiguration)configuration);
                }
                return new CompositeConfiguration(arrayList);
            }
            String string6 = uRI.toString();
            for (ConfigurationFactory configurationFactory : ConfigurationFactory$Factory.getFactories()) {
                String[] stringArray = configurationFactory.getSupportedTypes();
                if (stringArray == null) continue;
                for (String string7 : stringArray) {
                    Configuration configuration;
                    if (!string7.equals(ALL_TYPES) && !string6.endsWith(string7) || (configuration = configurationFactory.getConfiguration(loggerContext, string, uRI)) == null) continue;
                    return configuration;
                }
            }
        }
        if ((object = this.getConfiguration(loggerContext, true, string)) == null && (object = this.getConfiguration(loggerContext, true, null)) == null && (object = this.getConfiguration(loggerContext, false, string)) == null) {
            object = this.getConfiguration(loggerContext, false, null);
        }
        if (object != null) {
            return object;
        }
        LOGGER.warn("No Log4j 2 configuration file found. Using default configuration (logging only errors to the console), or user programmatically provided configurations. Set system property 'log4j2.debug' to show Log4j 2 internal initialization logging. See https://logging.apache.org/log4j/2.x/manual/configuration.html for instructions on how to configure Log4j 2");
        return new DefaultConfiguration();
    }

    private Configuration getConfiguration(LoggerContext loggerContext, String string) {
        return this.getConfiguration(null, loggerContext, string);
    }

    private Configuration getConfiguration(String string, LoggerContext loggerContext, String string2) {
        ConfigurationSource configurationSource = null;
        try {
            configurationSource = ConfigurationSource.fromUri(NetUtils.toURI(string2));
        }
        catch (Exception exception) {
            LOGGER.catching(Level.DEBUG, exception);
        }
        if (configurationSource == null) {
            ClassLoader classLoader = LoaderUtil.getThreadContextClassLoader();
            configurationSource = this.getInputFromString(string2, classLoader);
        }
        if (configurationSource != null) {
            for (ConfigurationFactory configurationFactory : ConfigurationFactory$Factory.getFactories()) {
                String[] stringArray;
                if (string != null && !configurationFactory.getVersion().equals(string) || (stringArray = configurationFactory.getSupportedTypes()) == null) continue;
                for (String string3 : stringArray) {
                    Configuration configuration;
                    if (!string3.equals(ALL_TYPES) && !string2.endsWith(string3) || (configuration = configurationFactory.getConfiguration(loggerContext, configurationSource)) == null) continue;
                    return configuration;
                }
            }
        }
        return null;
    }

    private Configuration getConfiguration(LoggerContext loggerContext, boolean bl, String string) {
        boolean bl2 = Strings.isNotEmpty(string);
        ClassLoader classLoader = LoaderUtil.getThreadContextClassLoader();
        for (ConfigurationFactory configurationFactory : ConfigurationFactory$Factory.getFactories()) {
            String string2 = bl ? configurationFactory.getTestPrefix() : configurationFactory.getDefaultPrefix();
            String[] stringArray = configurationFactory.getSupportedTypes();
            if (stringArray == null) continue;
            for (String string3 : stringArray) {
                String string4;
                ConfigurationSource configurationSource;
                if (string3.equals(ALL_TYPES) || (configurationSource = ConfigurationSource.fromResource(string4 = bl2 ? string2 + string + string3 : string2 + string3, classLoader)) == null) continue;
                if (!configurationFactory.isActive()) {
                    LOGGER.warn("Found configuration file {} for inactive ConfigurationFactory {}", (Object)string4, (Object)configurationFactory.getClass().getName());
                }
                return configurationFactory.getConfiguration(loggerContext, configurationSource);
            }
        }
        return null;
    }

    @Override
    public String[] getSupportedTypes() {
        return null;
    }

    @Override
    public Configuration getConfiguration(LoggerContext loggerContext, ConfigurationSource configurationSource) {
        if (configurationSource != null) {
            String string = configurationSource.getLocation();
            for (ConfigurationFactory configurationFactory : ConfigurationFactory$Factory.getFactories()) {
                String[] stringArray = configurationFactory.getSupportedTypes();
                if (stringArray == null) continue;
                for (String string2 : stringArray) {
                    if (!string2.equals(ALL_TYPES) && (string == null || !string.endsWith(string2))) continue;
                    Configuration configuration = configurationFactory.getConfiguration(loggerContext, configurationSource);
                    if (configuration != null) {
                        LOGGER.debug("Loaded configuration from {}", (Object)configurationSource);
                        return configuration;
                    }
                    LOGGER.error("Cannot determine the ConfigurationFactory to use for {}", (Object)string);
                    return null;
                }
            }
        }
        LOGGER.error("Cannot process configuration, input source is null");
        return null;
    }

    private String[] parseConfigLocations(URI uRI) {
        String[] stringArray = uRI.toString().split("\\?");
        ArrayList<String> arrayList = new ArrayList<String>();
        if (stringArray.length > 1) {
            String[] stringArray2;
            arrayList.add(stringArray[0]);
            for (String string : stringArray2 = uRI.getQuery().split("&")) {
                int n = string.indexOf("=");
                try {
                    String string2;
                    String string3 = string2 = n > 0 ? URLDecoder.decode(string.substring(0, n), "UTF-8") : string;
                    if (!string2.equalsIgnoreCase("override")) continue;
                    arrayList.add(URLDecoder.decode(string.substring(n + 1), "UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    LOGGER.warn("Invalid query parameter in {}", (Object)uRI);
                }
            }
            return arrayList.toArray(Strings.EMPTY_ARRAY);
        }
        return new String[]{stringArray[0]};
    }

    private String[] parseConfigLocations(String string) {
        String[] stringArray = string.split(",");
        if (stringArray.length > 1) {
            return stringArray;
        }
        try {
            return this.parseConfigLocations(new URI(string));
        }
        catch (URISyntaxException uRISyntaxException) {
            LOGGER.warn("Error parsing URI {}", (Object)string);
            return new String[]{string};
        }
    }

    /* synthetic */ ConfigurationFactory$Factory(ConfigurationFactory$1 configurationFactory$1) {
        this();
    }
}

