/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.async;

import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.SequenceBarrier;
import com.lmax.disruptor.TimeoutException;
import com.lmax.disruptor.WaitStrategy;
import java.util.concurrent.TimeUnit;

class TimeoutBlockingWaitStrategy
implements WaitStrategy {
    private final Object mutex = new Object();
    private final long timeoutInNanos;
    private static final int ONE_MILLISECOND_IN_NANOSECONDS = 1000000;

    public TimeoutBlockingWaitStrategy(long l, TimeUnit timeUnit) {
        this.timeoutInNanos = timeUnit.toNanos(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long waitFor(long l, Sequence sequence, Sequence sequence2, SequenceBarrier sequenceBarrier) {
        long l2;
        long l3 = this.timeoutInNanos;
        if (sequence.get() < l) {
            Object object = this.mutex;
            synchronized (object) {
                while (sequence.get() < l) {
                    sequenceBarrier.checkAlert();
                    if ((l3 = TimeoutBlockingWaitStrategy.awaitNanos(this.mutex, l3)) > 0L) continue;
                    throw TimeoutException.INSTANCE;
                }
            }
        }
        while ((l2 = sequence2.get()) < l) {
            sequenceBarrier.checkAlert();
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signalAllWhenBlocking() {
        Object object = this.mutex;
        synchronized (object) {
            this.mutex.notifyAll();
        }
    }

    public String toString() {
        return "TimeoutBlockingWaitStrategy{mutex=" + this.mutex + ", timeoutInNanos=" + this.timeoutInNanos + '}';
    }

    private static long awaitNanos(Object object, long l) {
        long l2 = l / 1000000L;
        long l3 = l % 1000000L;
        long l4 = System.nanoTime();
        object.wait(l2, (int)l3);
        long l5 = System.nanoTime();
        return l - (l5 - l4);
    }
}

