/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.async;

import java.util.Objects;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.async.AsyncWaitStrategyFactory;
import org.apache.logging.log4j.core.async.AsyncWaitStrategyFactoryConfig$Builder;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.util.Loader;
import org.apache.logging.log4j.status.StatusLogger;

@Plugin(name="AsyncWaitStrategyFactory", category="Core", printObject=true)
public class AsyncWaitStrategyFactoryConfig {
    protected static final Logger LOGGER = StatusLogger.getLogger();
    private final String factoryClassName;

    public AsyncWaitStrategyFactoryConfig(String string) {
        this.factoryClassName = Objects.requireNonNull(string, "factoryClassName");
    }

    @PluginBuilderFactory
    public static <B extends AsyncWaitStrategyFactoryConfig$Builder<B>> B newBuilder() {
        return new AsyncWaitStrategyFactoryConfig$Builder().asBuilder();
    }

    public AsyncWaitStrategyFactory createWaitStrategyFactory() {
        try {
            Class<?> clazz = Loader.loadClass(this.factoryClassName);
            if (AsyncWaitStrategyFactory.class.isAssignableFrom(clazz)) {
                return (AsyncWaitStrategyFactory)clazz.newInstance();
            }
            LOGGER.error("Ignoring factory '{}': it is not assignable to AsyncWaitStrategyFactory", (Object)this.factoryClassName);
            return null;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException) {
            LOGGER.info("Invalid implementation class name value: error creating AsyncWaitStrategyFactory {}: {}", (Object)this.factoryClassName, (Object)reflectiveOperationException);
            return null;
        }
    }
}

