/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.routing;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.script.Bindings;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LifeCycle2;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.rewrite.RewritePolicy;
import org.apache.logging.log4j.core.appender.routing.PurgePolicy;
import org.apache.logging.log4j.core.appender.routing.Route;
import org.apache.logging.log4j.core.appender.routing.Routes;
import org.apache.logging.log4j.core.appender.routing.RoutingAppender$1;
import org.apache.logging.log4j.core.appender.routing.RoutingAppender$Builder;
import org.apache.logging.log4j.core.appender.routing.RoutingAppender$CreatedRouteAppenderControl;
import org.apache.logging.log4j.core.appender.routing.RoutingAppender$ReferencedRouteAppenderControl;
import org.apache.logging.log4j.core.appender.routing.RoutingAppender$RouteAppenderControl;
import org.apache.logging.log4j.core.config.AppenderControl;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Node;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.script.AbstractScript;
import org.apache.logging.log4j.core.script.ScriptManager;
import org.apache.logging.log4j.core.util.Booleans;

@Plugin(name="Routing", category="Core", elementType="appender", printObject=true)
public final class RoutingAppender
extends AbstractAppender {
    public static final String STATIC_VARIABLES_KEY = "staticVariables";
    private static final String DEFAULT_KEY = "ROUTING_APPENDER_DEFAULT";
    private final Routes routes;
    private Route defaultRoute;
    private final Configuration configuration;
    private final ConcurrentMap<String, RoutingAppender$CreatedRouteAppenderControl> createdAppenders = new ConcurrentHashMap<String, RoutingAppender$CreatedRouteAppenderControl>();
    private final Map<String, AppenderControl> createdAppendersUnmodifiableView = Collections.unmodifiableMap(this.createdAppenders);
    private final ConcurrentMap<String, RoutingAppender$RouteAppenderControl> referencedAppenders = new ConcurrentHashMap<String, RoutingAppender$RouteAppenderControl>();
    private final RewritePolicy rewritePolicy;
    private final PurgePolicy purgePolicy;
    private final AbstractScript defaultRouteScript;
    private final ConcurrentMap<Object, Object> scriptStaticVariables = new ConcurrentHashMap<Object, Object>();

    @PluginBuilderFactory
    public static <B extends RoutingAppender$Builder<B>> B newBuilder() {
        return (B)((RoutingAppender$Builder)new RoutingAppender$Builder().asBuilder());
    }

    private RoutingAppender(String string, Filter filter, boolean bl, Routes routes, RewritePolicy rewritePolicy, Configuration configuration, PurgePolicy purgePolicy, AbstractScript abstractScript, Property[] propertyArray) {
        super(string, filter, null, bl, propertyArray);
        this.routes = routes;
        this.configuration = configuration;
        this.rewritePolicy = rewritePolicy;
        this.purgePolicy = purgePolicy;
        if (this.purgePolicy != null) {
            this.purgePolicy.initialize(this);
        }
        this.defaultRouteScript = abstractScript;
        Route route = null;
        for (Route route2 : routes.getRoutes()) {
            if (route2.getKey() != null) continue;
            if (route == null) {
                route = route2;
                continue;
            }
            this.error("Multiple default routes. Route " + route2.toString() + " will be ignored");
        }
        this.defaultRoute = route;
    }

    @Override
    public void start() {
        if (this.defaultRouteScript != null) {
            if (this.configuration == null) {
                this.error("No Configuration defined for RoutingAppender; required for Script element.");
            } else {
                ScriptManager scriptManager = this.configuration.getScriptManager();
                Bindings bindings = scriptManager.createBindings(this.defaultRouteScript);
                bindings.put(STATIC_VARIABLES_KEY, (Object)this.scriptStaticVariables);
                Object object = scriptManager.execute(this.defaultRouteScript.getName(), bindings);
                Route object2 = this.routes.getRoute(Objects.toString(object, null));
                if (object2 != null) {
                    this.defaultRoute = object2;
                }
            }
        }
        for (Route route : this.routes.getRoutes()) {
            if (route.getAppenderRef() == null) continue;
            Object t = this.configuration.getAppender(route.getAppenderRef());
            if (t != null) {
                String string = route == this.defaultRoute ? DEFAULT_KEY : route.getKey();
                this.referencedAppenders.put(string, new RoutingAppender$ReferencedRouteAppenderControl((Appender)t));
                continue;
            }
            this.error("Appender " + route.getAppenderRef() + " cannot be located. Route ignored");
        }
        super.start();
    }

    @Override
    public boolean stop(long l, TimeUnit timeUnit) {
        this.setStopping();
        super.stop(l, timeUnit, false);
        for (Map.Entry entry : this.createdAppenders.entrySet()) {
            Appender appender = ((RoutingAppender$CreatedRouteAppenderControl)entry.getValue()).getAppender();
            if (appender instanceof LifeCycle2) {
                ((LifeCycle2)((Object)appender)).stop(l, timeUnit);
                continue;
            }
            appender.stop();
        }
        this.setStopped();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void append(LogEvent logEvent) {
        String string;
        String string2;
        RoutingAppender$RouteAppenderControl routingAppender$RouteAppenderControl;
        if (this.rewritePolicy != null) {
            logEvent = this.rewritePolicy.rewrite(logEvent);
        }
        if ((routingAppender$RouteAppenderControl = this.getControl(string2 = (string = this.routes.getPattern(logEvent, this.scriptStaticVariables)) != null ? this.configuration.getStrSubstitutor().replace(logEvent, string) : (this.defaultRoute.getKey() != null ? this.defaultRoute.getKey() : DEFAULT_KEY), logEvent)) != null) {
            try {
                routingAppender$RouteAppenderControl.callAppender(logEvent);
            }
            finally {
                routingAppender$RouteAppenderControl.release();
            }
        }
        this.updatePurgePolicy(string2, logEvent);
    }

    private void updatePurgePolicy(String string, LogEvent logEvent) {
        if (this.purgePolicy != null && !this.referencedAppenders.containsKey(string)) {
            this.purgePolicy.update(string, logEvent);
        }
    }

    private synchronized RoutingAppender$RouteAppenderControl getControl(String string, LogEvent logEvent) {
        RoutingAppender$RouteAppenderControl routingAppender$RouteAppenderControl = this.getAppender(string);
        if (routingAppender$RouteAppenderControl != null) {
            routingAppender$RouteAppenderControl.checkout();
            return routingAppender$RouteAppenderControl;
        }
        Route route = null;
        for (Route route2 : this.routes.getRoutes()) {
            if (route2.getAppenderRef() != null || !string.equals(route2.getKey())) continue;
            route = route2;
            break;
        }
        if (route == null) {
            route = this.defaultRoute;
            routingAppender$RouteAppenderControl = this.getAppender(DEFAULT_KEY);
            if (routingAppender$RouteAppenderControl != null) {
                routingAppender$RouteAppenderControl.checkout();
                return routingAppender$RouteAppenderControl;
            }
        }
        if (route != null) {
            Appender appender = this.createAppender(route, logEvent);
            if (appender == null) {
                return null;
            }
            RoutingAppender$CreatedRouteAppenderControl routingAppender$CreatedRouteAppenderControl = new RoutingAppender$CreatedRouteAppenderControl(appender);
            routingAppender$RouteAppenderControl = routingAppender$CreatedRouteAppenderControl;
            this.createdAppenders.put(string, routingAppender$CreatedRouteAppenderControl);
        }
        if (routingAppender$RouteAppenderControl != null) {
            routingAppender$RouteAppenderControl.checkout();
        }
        return routingAppender$RouteAppenderControl;
    }

    private RoutingAppender$RouteAppenderControl getAppender(String string) {
        RoutingAppender$RouteAppenderControl routingAppender$RouteAppenderControl = (RoutingAppender$RouteAppenderControl)this.referencedAppenders.get(string);
        if (routingAppender$RouteAppenderControl == null) {
            return (RoutingAppender$RouteAppenderControl)this.createdAppenders.get(string);
        }
        return routingAppender$RouteAppenderControl;
    }

    private Appender createAppender(Route route, LogEvent logEvent) {
        Node node = route.getNode();
        for (Node node2 : node.getChildren()) {
            if (!node2.getType().getElementName().equals("appender")) continue;
            Node node3 = new Node(node2);
            this.configuration.createConfiguration(node3, logEvent);
            if (node3.getObject() instanceof Appender) {
                Appender appender = (Appender)node3.getObject();
                appender.start();
                return appender;
            }
            this.error("Unable to create Appender of type " + node2.getName());
            return null;
        }
        this.error("No Appender was configured for route " + route.getKey());
        return null;
    }

    public Map<String, AppenderControl> getAppenders() {
        return this.createdAppendersUnmodifiableView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAppender(String string) {
        LOGGER.debug("Deleting route with {} key ", (Object)string);
        RoutingAppender$CreatedRouteAppenderControl routingAppender$CreatedRouteAppenderControl = (RoutingAppender$CreatedRouteAppenderControl)this.createdAppenders.remove(string);
        if (null != routingAppender$CreatedRouteAppenderControl) {
            LOGGER.debug("Stopping route with {} key", (Object)string);
            RoutingAppender routingAppender = this;
            synchronized (routingAppender) {
                RoutingAppender$CreatedRouteAppenderControl.access$402(routingAppender$CreatedRouteAppenderControl, true);
            }
            routingAppender$CreatedRouteAppenderControl.tryStopAppender();
        } else if (this.referencedAppenders.containsKey(string)) {
            LOGGER.debug("Route {} using an appender reference may not be removed because the appender may be used outside of the RoutingAppender", (Object)string);
        } else {
            LOGGER.debug("Route with {} key already deleted", (Object)string);
        }
    }

    @Deprecated
    public static RoutingAppender createAppender(String string, String string2, Routes routes, Configuration configuration, RewritePolicy rewritePolicy, PurgePolicy purgePolicy, Filter filter) {
        boolean bl = Booleans.parseBoolean(string2, true);
        if (string == null) {
            LOGGER.error("No name provided for RoutingAppender");
            return null;
        }
        if (routes == null) {
            LOGGER.error("No routes defined for RoutingAppender");
            return null;
        }
        return new RoutingAppender(string, filter, bl, routes, rewritePolicy, configuration, purgePolicy, null, null);
    }

    public Route getDefaultRoute() {
        return this.defaultRoute;
    }

    public AbstractScript getDefaultRouteScript() {
        return this.defaultRouteScript;
    }

    public PurgePolicy getPurgePolicy() {
        return this.purgePolicy;
    }

    public RewritePolicy getRewritePolicy() {
        return this.rewritePolicy;
    }

    public Routes getRoutes() {
        return this.routes;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public ConcurrentMap<Object, Object> getScriptStaticVariables() {
        return this.scriptStaticVariables;
    }

    static /* synthetic */ Logger access$000() {
        return LOGGER;
    }

    static /* synthetic */ Logger access$100() {
        return LOGGER;
    }

    static /* synthetic */ Logger access$200() {
        return LOGGER;
    }

    /* synthetic */ RoutingAppender(String string, Filter filter, boolean bl, Routes routes, RewritePolicy rewritePolicy, Configuration configuration, PurgePolicy purgePolicy, AbstractScript abstractScript, Property[] propertyArray, RoutingAppender$1 routingAppender$1) {
        this(string, filter, bl, routes, rewritePolicy, configuration, purgePolicy, abstractScript, propertyArray);
    }
}

