/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling.action;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.logging.log4j.core.appender.rolling.action.AbstractAction;
import org.apache.logging.log4j.core.appender.rolling.action.GzCompressAction$ConfigurableLevelGZIPOutputStream;

public final class GzCompressAction
extends AbstractAction {
    private static final int BUF_SIZE = 8192;
    private final File source;
    private final File destination;
    private final boolean deleteSource;
    private final int compressionLevel;

    public GzCompressAction(File file, File file2, boolean bl, int n) {
        Objects.requireNonNull(file, "source");
        Objects.requireNonNull(file2, "destination");
        this.source = file;
        this.destination = file2;
        this.deleteSource = bl;
        this.compressionLevel = n;
    }

    @Deprecated
    public GzCompressAction(File file, File file2, boolean bl) {
        this(file, file2, bl, -1);
    }

    @Override
    public boolean execute() {
        return GzCompressAction.execute(this.source, this.destination, this.deleteSource, this.compressionLevel);
    }

    @Deprecated
    public static boolean execute(File file, File file2, boolean bl) {
        return GzCompressAction.execute(file, file2, bl, -1);
    }

    public static boolean execute(File file, File file2, boolean bl, int n) {
        if (file.exists()) {
            try (FileInputStream fileInputStream = new FileInputStream(file);
                 FileOutputStream fileOutputStream = new FileOutputStream(file2);
                 GzCompressAction$ConfigurableLevelGZIPOutputStream gzCompressAction$ConfigurableLevelGZIPOutputStream = new GzCompressAction$ConfigurableLevelGZIPOutputStream((OutputStream)fileOutputStream, 8192, n);
                 BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(gzCompressAction$ConfigurableLevelGZIPOutputStream, 8192);){
                int n2;
                byte[] byArray = new byte[8192];
                while ((n2 = fileInputStream.read(byArray)) != -1) {
                    ((OutputStream)bufferedOutputStream).write(byArray, 0, n2);
                }
            }
            if (bl && !file.delete()) {
                LOGGER.warn("Unable to delete {}.", (Object)file);
            }
            return true;
        }
        return false;
    }

    @Override
    protected void reportException(Exception exception) {
        LOGGER.warn("Exception during compression of '" + this.source.toString() + "'.", (Throwable)exception);
    }

    public String toString() {
        return GzCompressAction.class.getSimpleName() + '[' + this.source + " to " + this.destination + ", deleteSource=" + this.deleteSource + ']';
    }

    public File getSource() {
        return this.source;
    }

    public File getDestination() {
        return this.destination;
    }

    public boolean isDeleteSource() {
        return this.deleteSource;
    }
}

