/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AppenderLoggingException;
import org.apache.logging.log4j.core.appender.rolling.DirectWriteRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.PatternProcessor;
import org.apache.logging.log4j.core.appender.rolling.RollingFileManager;
import org.apache.logging.log4j.core.appender.rolling.RollingRandomAccessFileManager$FactoryData;
import org.apache.logging.log4j.core.appender.rolling.RollingRandomAccessFileManager$RollingRandomAccessFileManagerFactory;
import org.apache.logging.log4j.core.appender.rolling.RolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.util.FileUtils;

public class RollingRandomAccessFileManager
extends RollingFileManager {
    public static final int DEFAULT_BUFFER_SIZE = 262144;
    private static final RollingRandomAccessFileManager$RollingRandomAccessFileManagerFactory FACTORY = new RollingRandomAccessFileManager$RollingRandomAccessFileManagerFactory(null);
    private RandomAccessFile randomAccessFile;

    @Deprecated
    public RollingRandomAccessFileManager(LoggerContext loggerContext, RandomAccessFile randomAccessFile, String string, String string2, OutputStream outputStream, boolean bl, boolean bl2, int n, long l, long l2, TriggeringPolicy triggeringPolicy, RolloverStrategy rolloverStrategy, String string3, Layout<? extends Serializable> layout, boolean bl3) {
        this(loggerContext, randomAccessFile, string, string2, outputStream, bl, bl2, n, l, l2, triggeringPolicy, rolloverStrategy, string3, layout, null, null, null, bl3);
    }

    public RollingRandomAccessFileManager(LoggerContext loggerContext, RandomAccessFile randomAccessFile, String string, String string2, OutputStream outputStream, boolean bl, boolean bl2, int n, long l, long l2, TriggeringPolicy triggeringPolicy, RolloverStrategy rolloverStrategy, String string3, Layout<? extends Serializable> layout, String string4, String string5, String string6, boolean bl3) {
        super(loggerContext, string, string2, outputStream, bl, false, l, l2, triggeringPolicy, rolloverStrategy, string3, layout, string4, string5, string6, bl3, ByteBuffer.wrap(new byte[n]));
        this.randomAccessFile = randomAccessFile;
        this.writeHeader();
    }

    private void writeHeader() {
        if (this.layout == null) {
            return;
        }
        byte[] byArray = this.layout.getHeader();
        if (byArray == null) {
            return;
        }
        try {
            if (this.randomAccessFile != null && this.randomAccessFile.length() == 0L) {
                this.randomAccessFile.write(byArray, 0, byArray.length);
            }
        }
        catch (IOException iOException) {
            this.logError("Unable to write header", iOException);
        }
    }

    public static RollingRandomAccessFileManager getRollingRandomAccessFileManager(String string, String string2, boolean bl, boolean bl2, int n, TriggeringPolicy triggeringPolicy, RolloverStrategy rolloverStrategy, String string3, Layout<? extends Serializable> layout, String string4, String string5, String string6, Configuration configuration) {
        if (rolloverStrategy instanceof DirectWriteRolloverStrategy && string != null) {
            LOGGER.error("The fileName attribute must not be specified with the DirectWriteRolloverStrategy");
            return null;
        }
        String string7 = string == null ? string2 : string;
        return RollingRandomAccessFileManager.narrow(RollingRandomAccessFileManager.class, RollingRandomAccessFileManager.getManager(string7, new RollingRandomAccessFileManager$FactoryData(string, string2, bl, bl2, n, triggeringPolicy, rolloverStrategy, string3, layout, string4, string5, string6, configuration), FACTORY));
    }

    @Deprecated
    public Boolean isEndOfBatch() {
        return Boolean.FALSE;
    }

    @Deprecated
    public void setEndOfBatch(boolean bl) {
    }

    @Override
    protected synchronized void write(byte[] byArray, int n, int n2, boolean bl) {
        super.write(byArray, n, n2, bl);
    }

    @Override
    protected synchronized void writeToDestination(byte[] byArray, int n, int n2) {
        try {
            if (this.randomAccessFile == null) {
                this.createFileAfterRollover();
            }
            this.randomAccessFile.write(byArray, n, n2);
            this.size += (long)n2;
        }
        catch (IOException iOException) {
            String string = "Error writing to RandomAccessFile " + this.getName();
            throw new AppenderLoggingException(string, iOException);
        }
    }

    @Override
    protected void createFileAfterRollover() {
        String string = this.getFileName();
        File file = new File(string);
        FileUtils.makeParentDirs(file);
        this.createFileAfterRollover(string);
    }

    private void createFileAfterRollover(String string) {
        this.randomAccessFile = new RandomAccessFile(string, "rw");
        if (this.isAttributeViewEnabled()) {
            this.defineAttributeView(Paths.get(string, new String[0]));
        }
        if (this.isAppend()) {
            this.randomAccessFile.seek(this.randomAccessFile.length());
        }
        this.writeHeader();
    }

    @Override
    public synchronized void flush() {
        this.flushBuffer(this.byteBuffer);
    }

    @Override
    public synchronized boolean closeOutputStream() {
        this.flush();
        if (this.randomAccessFile != null) {
            try {
                this.randomAccessFile.close();
                return true;
            }
            catch (IOException iOException) {
                this.logError("Unable to close RandomAccessFile", iOException);
                return false;
            }
        }
        return true;
    }

    @Override
    public int getBufferSize() {
        return this.byteBuffer.capacity();
    }

    @Override
    public void updateData(Object object) {
        RollingRandomAccessFileManager$FactoryData rollingRandomAccessFileManager$FactoryData = (RollingRandomAccessFileManager$FactoryData)object;
        this.setRolloverStrategy(rollingRandomAccessFileManager$FactoryData.getRolloverStrategy());
        this.setPatternProcessor(new PatternProcessor(rollingRandomAccessFileManager$FactoryData.getPattern(), this.getPatternProcessor()));
        this.setTriggeringPolicy(rollingRandomAccessFileManager$FactoryData.getTriggeringPolicy());
    }

    static /* synthetic */ Logger access$300() {
        return LOGGER;
    }

    static /* synthetic */ Logger access$400() {
        return LOGGER;
    }

    static /* synthetic */ Logger access$500() {
        return LOGGER;
    }

    static /* synthetic */ Logger access$600() {
        return LOGGER;
    }

    static /* synthetic */ void access$1700(RollingRandomAccessFileManager rollingRandomAccessFileManager, Path path) {
        rollingRandomAccessFileManager.defineAttributeView(path);
    }
}

