/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling;

import org.apache.logging.log4j.core.appender.rolling.AbstractRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.DirectWriteRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.action.Action;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.util.Builder;
import org.apache.logging.log4j.core.util.Integers;

public class DirectWriteRolloverStrategy$Builder
implements Builder<DirectWriteRolloverStrategy> {
    @PluginBuilderAttribute(value="maxFiles")
    private String maxFiles;
    @PluginBuilderAttribute(value="compressionLevel")
    private String compressionLevelStr;
    @PluginElement(value="Actions")
    private Action[] customActions;
    @PluginBuilderAttribute(value="stopCustomActionsOnError")
    private boolean stopCustomActionsOnError = true;
    @PluginBuilderAttribute(value="tempCompressedFilePattern")
    private String tempCompressedFilePattern;
    @PluginConfiguration
    private Configuration config;

    @Override
    public DirectWriteRolloverStrategy build() {
        int n = Integer.MAX_VALUE;
        if (this.maxFiles != null) {
            n = Integers.parseInt(this.maxFiles);
            if (n < 0) {
                n = Integer.MAX_VALUE;
            } else if (n < 2) {
                AbstractRolloverStrategy.LOGGER.error("Maximum files too small. Limited to 7");
                n = 7;
            }
        }
        int n2 = Integers.parseInt(this.compressionLevelStr, -1);
        return new DirectWriteRolloverStrategy(n, n2, this.config.getStrSubstitutor(), this.customActions, this.stopCustomActionsOnError, this.tempCompressedFilePattern);
    }

    public String getMaxFiles() {
        return this.maxFiles;
    }

    public DirectWriteRolloverStrategy$Builder withMaxFiles(String string) {
        this.maxFiles = string;
        return this;
    }

    public String getCompressionLevelStr() {
        return this.compressionLevelStr;
    }

    public DirectWriteRolloverStrategy$Builder withCompressionLevelStr(String string) {
        this.compressionLevelStr = string;
        return this;
    }

    public Action[] getCustomActions() {
        return this.customActions;
    }

    public DirectWriteRolloverStrategy$Builder withCustomActions(Action[] actionArray) {
        this.customActions = actionArray;
        return this;
    }

    public boolean isStopCustomActionsOnError() {
        return this.stopCustomActionsOnError;
    }

    public DirectWriteRolloverStrategy$Builder withStopCustomActionsOnError(boolean bl) {
        this.stopCustomActionsOnError = bl;
        return this;
    }

    public String getTempCompressedFilePattern() {
        return this.tempCompressedFilePattern;
    }

    public DirectWriteRolloverStrategy$Builder withTempCompressedFilePattern(String string) {
        this.tempCompressedFilePattern = string;
        return this;
    }

    public Configuration getConfig() {
        return this.config;
    }

    public DirectWriteRolloverStrategy$Builder withConfig(Configuration configuration) {
        this.config = configuration;
        return this;
    }
}

