/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.core.appender.rolling.AbstractRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.DefaultRolloverStrategy$Builder;
import org.apache.logging.log4j.core.appender.rolling.FileExtension;
import org.apache.logging.log4j.core.appender.rolling.PatternProcessor;
import org.apache.logging.log4j.core.appender.rolling.RollingFileManager;
import org.apache.logging.log4j.core.appender.rolling.RolloverDescription;
import org.apache.logging.log4j.core.appender.rolling.RolloverDescriptionImpl;
import org.apache.logging.log4j.core.appender.rolling.action.Action;
import org.apache.logging.log4j.core.appender.rolling.action.CompositeAction;
import org.apache.logging.log4j.core.appender.rolling.action.FileRenameAction;
import org.apache.logging.log4j.core.appender.rolling.action.PathCondition;
import org.apache.logging.log4j.core.appender.rolling.action.PosixViewAttributeAction;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;

@Plugin(name="DefaultRolloverStrategy", category="Core", printObject=true)
public class DefaultRolloverStrategy
extends AbstractRolloverStrategy {
    private static final int MIN_WINDOW_SIZE = 1;
    private static final int DEFAULT_WINDOW_SIZE = 7;
    private final int maxIndex;
    private final int minIndex;
    private final boolean useMax;
    private final int compressionLevel;
    private final List<Action> customActions;
    private final boolean stopCustomActionsOnError;
    private final PatternProcessor tempCompressedFilePattern;

    @PluginBuilderFactory
    public static DefaultRolloverStrategy$Builder newBuilder() {
        return new DefaultRolloverStrategy$Builder();
    }

    @PluginFactory
    @Deprecated
    public static DefaultRolloverStrategy createStrategy(@PluginAttribute(value="max") String string, @PluginAttribute(value="min") String string2, @PluginAttribute(value="fileIndex") String string3, @PluginAttribute(value="compressionLevel") String string4, @PluginElement(value="Actions") Action[] actionArray, @PluginAttribute(value="stopCustomActionsOnError", defaultBoolean=true) boolean bl, @PluginConfiguration Configuration configuration) {
        return DefaultRolloverStrategy.newBuilder().withMin(string2).withMax(string).withFileIndex(string3).withCompressionLevelStr(string4).withCustomActions(actionArray).withStopCustomActionsOnError(bl).withConfig(configuration).build();
    }

    @Deprecated
    protected DefaultRolloverStrategy(int n, int n2, boolean bl, int n3, StrSubstitutor strSubstitutor, Action[] actionArray, boolean bl2) {
        this(n, n2, bl, n3, strSubstitutor, actionArray, bl2, null);
    }

    protected DefaultRolloverStrategy(int n, int n2, boolean bl, int n3, StrSubstitutor strSubstitutor, Action[] actionArray, boolean bl2, String string) {
        super(strSubstitutor);
        this.minIndex = n;
        this.maxIndex = n2;
        this.useMax = bl;
        this.compressionLevel = n3;
        this.stopCustomActionsOnError = bl2;
        this.customActions = actionArray == null ? Collections.emptyList() : Arrays.asList(actionArray);
        this.tempCompressedFilePattern = string != null ? new PatternProcessor(string) : null;
    }

    public int getCompressionLevel() {
        return this.compressionLevel;
    }

    public List<Action> getCustomActions() {
        return this.customActions;
    }

    public int getMaxIndex() {
        return this.maxIndex;
    }

    public int getMinIndex() {
        return this.minIndex;
    }

    public boolean isStopCustomActionsOnError() {
        return this.stopCustomActionsOnError;
    }

    public boolean isUseMax() {
        return this.useMax;
    }

    public PatternProcessor getTempCompressedFilePattern() {
        return this.tempCompressedFilePattern;
    }

    private int purge(int n, int n2, RollingFileManager rollingFileManager) {
        return this.useMax ? this.purgeAscending(n, n2, rollingFileManager) : this.purgeDescending(n, n2, rollingFileManager);
    }

    private int purgeAscending(int n, int n2, RollingFileManager rollingFileManager) {
        Comparable<StringBuilder> comparable;
        boolean bl;
        SortedMap<Integer, Path> sortedMap = this.getEligibleFiles(rollingFileManager);
        int n3 = n2 - n + 1;
        LOGGER.debug("Eligible files: {}", (Object)sortedMap);
        boolean bl2 = bl = !sortedMap.isEmpty() && sortedMap.lastKey() >= this.maxIndex;
        while (sortedMap.size() >= n3) {
            try {
                LOGGER.debug("Eligible files: {}", (Object)sortedMap);
                comparable = sortedMap.firstKey();
                LOGGER.debug("Deleting {}", (Object)((Path)sortedMap.get(comparable)).toFile().getAbsolutePath());
                Files.delete((Path)sortedMap.get(comparable));
                sortedMap.remove(comparable);
                bl = true;
            }
            catch (IOException iOException) {
                LOGGER.error("Unable to delete {}, {}", (Object)sortedMap.firstKey(), (Object)iOException.getMessage(), (Object)iOException);
                break;
            }
        }
        comparable = new StringBuilder();
        if (bl) {
            for (Map.Entry<Integer, Path> entry : sortedMap.entrySet()) {
                ((StringBuilder)comparable).setLength(0);
                rollingFileManager.getPatternProcessor().formatFileName(this.strSubstitutor, (StringBuilder)comparable, (Object)(entry.getKey() - 1));
                String string = entry.getValue().toFile().getName();
                String string2 = ((StringBuilder)comparable).toString();
                int n4 = this.suffixLength(string2);
                if (n4 > 0 && this.suffixLength(string) == 0) {
                    string2 = string2.substring(0, string2.length() - n4);
                }
                FileRenameAction fileRenameAction = new FileRenameAction(entry.getValue().toFile(), new File(string2), true);
                try {
                    LOGGER.debug("DefaultRolloverStrategy.purgeAscending executing {}", (Object)fileRenameAction);
                    if (fileRenameAction.execute()) continue;
                    return -1;
                }
                catch (Exception exception) {
                    LOGGER.warn("Exception during purge in RollingFileAppender", (Throwable)exception);
                    return -1;
                }
            }
        }
        return sortedMap.size() > 0 ? (sortedMap.lastKey() < n2 ? sortedMap.lastKey() + 1 : n2) : n;
    }

    private int purgeDescending(int n, int n2, RollingFileManager rollingFileManager) {
        Comparable<StringBuilder> comparable;
        SortedMap<Integer, Path> sortedMap = this.getEligibleFiles(rollingFileManager, false);
        int n3 = n2 - n + 1;
        LOGGER.debug("Eligible files: {}", (Object)sortedMap);
        while (sortedMap.size() >= n3) {
            try {
                comparable = sortedMap.firstKey();
                LOGGER.debug("Deleting {}", (Object)((Path)sortedMap.get(comparable)).toFile().getAbsolutePath());
                Files.delete((Path)sortedMap.get(comparable));
                sortedMap.remove(comparable);
            }
            catch (IOException iOException) {
                LOGGER.error("Unable to delete {}, {}", (Object)sortedMap.firstKey(), (Object)iOException.getMessage(), (Object)iOException);
                break;
            }
        }
        comparable = new StringBuilder();
        for (Map.Entry<Integer, Path> entry : sortedMap.entrySet()) {
            ((StringBuilder)comparable).setLength(0);
            rollingFileManager.getPatternProcessor().formatFileName(this.strSubstitutor, (StringBuilder)comparable, (Object)(entry.getKey() + 1));
            String string = entry.getValue().toFile().getName();
            String string2 = ((StringBuilder)comparable).toString();
            int n4 = this.suffixLength(string2);
            if (n4 > 0 && this.suffixLength(string) == 0) {
                string2 = string2.substring(0, string2.length() - n4);
            }
            FileRenameAction fileRenameAction = new FileRenameAction(entry.getValue().toFile(), new File(string2), true);
            try {
                LOGGER.debug("DefaultRolloverStrategy.purgeDescending executing {}", (Object)fileRenameAction);
                if (fileRenameAction.execute()) continue;
                return -1;
            }
            catch (Exception exception) {
                LOGGER.warn("Exception during purge in RollingFileAppender", (Throwable)exception);
                return -1;
            }
        }
        return n;
    }

    @Override
    public RolloverDescription rollover(RollingFileManager rollingFileManager) {
        Object object;
        Object object2;
        String string;
        int n;
        SortedMap<Integer, Path> sortedMap;
        StringBuilder stringBuilder = new StringBuilder(255);
        if (this.minIndex == Integer.MIN_VALUE) {
            sortedMap = this.getEligibleFiles(rollingFileManager);
            n = sortedMap.size() > 0 ? sortedMap.lastKey() + 1 : 1;
            rollingFileManager.getPatternProcessor().formatFileName(this.strSubstitutor, stringBuilder, (Object)n);
        } else {
            if (this.maxIndex < 0) {
                return null;
            }
            long l = System.nanoTime();
            n = this.purge(this.minIndex, this.maxIndex, rollingFileManager);
            if (n < 0) {
                return null;
            }
            rollingFileManager.getPatternProcessor().formatFileName(this.strSubstitutor, stringBuilder, (Object)n);
            if (LOGGER.isTraceEnabled()) {
                double d = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - l);
                LOGGER.trace("DefaultRolloverStrategy.purge() took {} milliseconds", (Object)d);
            }
        }
        sortedMap = rollingFileManager.getFileName();
        String string2 = string = stringBuilder.toString();
        Action action = null;
        FileExtension fileExtension = rollingFileManager.getFileExtension();
        if (fileExtension != null) {
            object2 = new File(string);
            string = string.substring(0, string.length() - fileExtension.length());
            if (this.tempCompressedFilePattern != null) {
                stringBuilder.delete(0, stringBuilder.length());
                this.tempCompressedFilePattern.formatFileName(this.strSubstitutor, stringBuilder, (Object)n);
                object = stringBuilder.toString();
                File file = new File((String)object);
                File file2 = file.getParentFile();
                if (file2 != null) {
                    file2.mkdirs();
                }
                action = new CompositeAction(Arrays.asList(fileExtension.createCompressAction(string, (String)object, true, this.compressionLevel), new FileRenameAction(file, (File)object2, true)), true);
            } else {
                action = fileExtension.createCompressAction(string, string2, true, this.compressionLevel);
            }
        }
        if (((String)((Object)sortedMap)).equals(string)) {
            LOGGER.warn("Attempt to rename file {} to itself will be ignored", (Object)sortedMap);
            return new RolloverDescriptionImpl((String)((Object)sortedMap), false, null, null);
        }
        if (action != null && rollingFileManager.isAttributeViewEnabled()) {
            object2 = PosixViewAttributeAction.newBuilder().withBasePath(string2).withFollowLinks(false).withMaxDepth(1).withPathConditions(PathCondition.EMPTY_ARRAY).withSubst(this.getStrSubstitutor()).withFilePermissions(rollingFileManager.getFilePermissions()).withFileOwner(rollingFileManager.getFileOwner()).withFileGroup(rollingFileManager.getFileGroup()).build();
            action = new CompositeAction(Arrays.asList(action, object2), false);
        }
        object2 = new FileRenameAction(new File((String)((Object)sortedMap)), new File(string), rollingFileManager.isRenameEmptyFiles());
        object = this.merge(action, this.customActions, this.stopCustomActionsOnError);
        return new RolloverDescriptionImpl((String)((Object)sortedMap), false, (Action)object2, (Action)object);
    }

    public String toString() {
        return "DefaultRolloverStrategy(min=" + this.minIndex + ", max=" + this.maxIndex + ", useMax=" + this.useMax + ")";
    }
}

