/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling;

import org.apache.logging.log4j.core.appender.rolling.AbstractRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.DefaultRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.action.Action;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;
import org.apache.logging.log4j.core.util.Builder;
import org.apache.logging.log4j.core.util.Integers;

public class DefaultRolloverStrategy$Builder
implements Builder<DefaultRolloverStrategy> {
    @PluginBuilderAttribute(value="max")
    private String max;
    @PluginBuilderAttribute(value="min")
    private String min;
    @PluginBuilderAttribute(value="fileIndex")
    private String fileIndex;
    @PluginBuilderAttribute(value="compressionLevel")
    private String compressionLevelStr;
    @PluginElement(value="Actions")
    private Action[] customActions;
    @PluginBuilderAttribute(value="stopCustomActionsOnError")
    private boolean stopCustomActionsOnError = true;
    @PluginBuilderAttribute(value="tempCompressedFilePattern")
    private String tempCompressedFilePattern;
    @PluginConfiguration
    private Configuration config;

    @Override
    public DefaultRolloverStrategy build() {
        boolean bl;
        int n;
        int n2;
        if (this.fileIndex != null && this.fileIndex.equalsIgnoreCase("nomax")) {
            n2 = Integer.MIN_VALUE;
            n = Integer.MAX_VALUE;
            bl = false;
        } else {
            bl = this.fileIndex == null ? true : this.fileIndex.equalsIgnoreCase("max");
            n2 = 1;
            if (this.min != null && (n2 = Integers.parseInt(this.min)) < 1) {
                AbstractRolloverStrategy.LOGGER.error("Minimum window size too small. Limited to 1");
                n2 = 1;
            }
            n = 7;
            if (this.max != null && (n = Integer.parseInt(this.max.trim())) < n2) {
                n = n2 < 7 ? 7 : n2;
                AbstractRolloverStrategy.LOGGER.error("Maximum window size must be greater than the minimum windows size. Set to " + n);
            }
        }
        String string = this.compressionLevelStr != null ? this.compressionLevelStr.trim() : this.compressionLevelStr;
        int n3 = Integers.parseInt(string, -1);
        StrSubstitutor strSubstitutor = this.config != null ? this.config.getStrSubstitutor() : new StrSubstitutor();
        return new DefaultRolloverStrategy(n2, n, bl, n3, strSubstitutor, this.customActions, this.stopCustomActionsOnError, this.tempCompressedFilePattern);
    }

    public String getMax() {
        return this.max;
    }

    public DefaultRolloverStrategy$Builder withMax(String string) {
        this.max = string;
        return this;
    }

    public String getMin() {
        return this.min;
    }

    public DefaultRolloverStrategy$Builder withMin(String string) {
        this.min = string;
        return this;
    }

    public String getFileIndex() {
        return this.fileIndex;
    }

    public DefaultRolloverStrategy$Builder withFileIndex(String string) {
        this.fileIndex = string;
        return this;
    }

    public String getCompressionLevelStr() {
        return this.compressionLevelStr;
    }

    public DefaultRolloverStrategy$Builder withCompressionLevelStr(String string) {
        this.compressionLevelStr = string;
        return this;
    }

    public Action[] getCustomActions() {
        return this.customActions;
    }

    public DefaultRolloverStrategy$Builder withCustomActions(Action[] actionArray) {
        this.customActions = actionArray;
        return this;
    }

    public boolean isStopCustomActionsOnError() {
        return this.stopCustomActionsOnError;
    }

    public DefaultRolloverStrategy$Builder withStopCustomActionsOnError(boolean bl) {
        this.stopCustomActionsOnError = bl;
        return this;
    }

    public String getTempCompressedFilePattern() {
        return this.tempCompressedFilePattern;
    }

    public DefaultRolloverStrategy$Builder withTempCompressedFilePattern(String string) {
        this.tempCompressedFilePattern = string;
        return this;
    }

    public Configuration getConfig() {
        return this.config;
    }

    public DefaultRolloverStrategy$Builder withConfig(Configuration configuration) {
        this.config = configuration;
        return this;
    }
}

