/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.nosql;

import java.io.Serializable;
import java.util.Date;
import java.util.stream.Stream;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AppenderLoggingException;
import org.apache.logging.log4j.core.appender.db.AbstractDatabaseManager;
import org.apache.logging.log4j.core.appender.nosql.NoSqlConnection;
import org.apache.logging.log4j.core.appender.nosql.NoSqlDatabaseManager$1;
import org.apache.logging.log4j.core.appender.nosql.NoSqlDatabaseManager$FactoryData;
import org.apache.logging.log4j.core.appender.nosql.NoSqlDatabaseManager$NoSQLDatabaseManagerFactory;
import org.apache.logging.log4j.core.appender.nosql.NoSqlObject;
import org.apache.logging.log4j.core.appender.nosql.NoSqlProvider;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;
import org.apache.logging.log4j.core.util.Closer;
import org.apache.logging.log4j.core.util.KeyValuePair;
import org.apache.logging.log4j.message.MapMessage;

public final class NoSqlDatabaseManager<W>
extends AbstractDatabaseManager {
    private static final NoSqlDatabaseManager$NoSQLDatabaseManagerFactory FACTORY = new NoSqlDatabaseManager$NoSQLDatabaseManagerFactory(null);
    private final NoSqlProvider<NoSqlConnection<W, ? extends NoSqlObject<W>>> provider;
    private NoSqlConnection<W, ? extends NoSqlObject<W>> connection;
    private final KeyValuePair[] additionalFields;

    @Deprecated
    public static NoSqlDatabaseManager<?> getNoSqlDatabaseManager(String string, int n, NoSqlProvider<?> noSqlProvider) {
        return (NoSqlDatabaseManager)AbstractDatabaseManager.getManager(string, new NoSqlDatabaseManager$FactoryData(null, n, noSqlProvider, null), FACTORY);
    }

    public static NoSqlDatabaseManager<?> getNoSqlDatabaseManager(String string, int n, NoSqlProvider<?> noSqlProvider, KeyValuePair[] keyValuePairArray, Configuration configuration) {
        return (NoSqlDatabaseManager)AbstractDatabaseManager.getManager(string, new NoSqlDatabaseManager$FactoryData(configuration, n, noSqlProvider, keyValuePairArray), FACTORY);
    }

    private NoSqlDatabaseManager(String string, int n, NoSqlProvider<NoSqlConnection<W, ? extends NoSqlObject<W>>> noSqlProvider, KeyValuePair[] keyValuePairArray, Configuration configuration) {
        super(string, n, null, configuration);
        this.provider = noSqlProvider;
        this.additionalFields = keyValuePairArray;
    }

    private NoSqlObject<W> buildMarkerEntity(Marker marker) {
        NoSqlObject<W> noSqlObject = this.connection.createObject();
        noSqlObject.set("name", marker.getName());
        Marker[] markerArray = marker.getParents();
        if (markerArray != null) {
            NoSqlObject[] noSqlObjectArray = new NoSqlObject[markerArray.length];
            for (int i = 0; i < markerArray.length; ++i) {
                noSqlObjectArray[i] = this.buildMarkerEntity(markerArray[i]);
            }
            noSqlObject.set("parents", noSqlObjectArray);
        }
        return noSqlObject;
    }

    @Override
    protected boolean commitAndClose() {
        return true;
    }

    @Override
    protected void connectAndStart() {
        try {
            this.connection = this.provider.getConnection();
        }
        catch (Exception exception) {
            throw new AppenderLoggingException("Failed to get connection from NoSQL connection provider.", exception);
        }
    }

    private NoSqlObject<W>[] convertStackTrace(StackTraceElement[] stackTraceElementArray) {
        NoSqlObject[] noSqlObjectArray = this.connection.createList(stackTraceElementArray.length);
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            noSqlObjectArray[i] = this.convertStackTraceElement(stackTraceElementArray[i]);
        }
        return noSqlObjectArray;
    }

    private NoSqlObject<W> convertStackTraceElement(StackTraceElement stackTraceElement) {
        NoSqlObject<W> noSqlObject = this.connection.createObject();
        noSqlObject.set("className", stackTraceElement.getClassName());
        noSqlObject.set("methodName", stackTraceElement.getMethodName());
        noSqlObject.set("fileName", stackTraceElement.getFileName());
        noSqlObject.set("lineNumber", stackTraceElement.getLineNumber());
        return noSqlObject;
    }

    private void setAdditionalFields(NoSqlObject<W> noSqlObject) {
        if (this.additionalFields != null) {
            NoSqlObject noSqlObject2 = this.connection.createObject();
            StrSubstitutor strSubstitutor = this.getStrSubstitutor();
            Stream.of(this.additionalFields).forEach(keyValuePair -> noSqlObject2.set(keyValuePair.getKey(), strSubstitutor != null ? strSubstitutor.replace(keyValuePair.getValue()) : keyValuePair.getValue()));
            noSqlObject.set("additionalFields", noSqlObject2);
        }
    }

    private void setFields(LogEvent logEvent, NoSqlObject<W> noSqlObject) {
        NoSqlObject noSqlObject2;
        Object object2;
        noSqlObject.set("level", logEvent.getLevel());
        noSqlObject.set("loggerName", logEvent.getLoggerName());
        noSqlObject.set("message", logEvent.getMessage() == null ? null : logEvent.getMessage().getFormattedMessage());
        StackTraceElement stackTraceElement = logEvent.getSource();
        if (stackTraceElement == null) {
            noSqlObject.set("source", (Object)null);
        } else {
            noSqlObject.set("source", this.convertStackTraceElement(stackTraceElement));
        }
        Marker marker = logEvent.getMarker();
        if (marker == null) {
            noSqlObject.set("marker", (Object)null);
        } else {
            noSqlObject.set("marker", this.buildMarkerEntity(marker));
        }
        noSqlObject.set("threadId", logEvent.getThreadId());
        noSqlObject.set("threadName", logEvent.getThreadName());
        noSqlObject.set("threadPriority", logEvent.getThreadPriority());
        noSqlObject.set("millis", logEvent.getTimeMillis());
        noSqlObject.set("date", new Date(logEvent.getTimeMillis()));
        Throwable throwable = logEvent.getThrown();
        if (throwable == null) {
            noSqlObject.set("thrown", (Object)null);
        } else {
            object2 = this.connection.createObject();
            noSqlObject2 = object2;
            noSqlObject2.set("type", throwable.getClass().getName());
            noSqlObject2.set("message", throwable.getMessage());
            noSqlObject2.set("stackTrace", this.convertStackTrace(throwable.getStackTrace()));
            while (throwable.getCause() != null) {
                throwable = throwable.getCause();
                NoSqlObject noSqlObject3 = this.connection.createObject();
                noSqlObject3.set("type", throwable.getClass().getName());
                noSqlObject3.set("message", throwable.getMessage());
                noSqlObject3.set("stackTrace", this.convertStackTrace(throwable.getStackTrace()));
                noSqlObject2.set("cause", noSqlObject3);
                noSqlObject2 = noSqlObject3;
            }
            noSqlObject.set("thrown", (NoSqlObject<W>)object2);
        }
        object2 = logEvent.getContextData();
        if (object2 == null) {
            noSqlObject.set("contextMap", (Object)null);
        } else {
            noSqlObject2 = this.connection.createObject();
            object2.forEach((string, object) -> noSqlObject2.set((String)string, object));
            noSqlObject.set("contextMap", noSqlObject2);
        }
        noSqlObject2 = logEvent.getContextStack();
        if (noSqlObject2 == null) {
            noSqlObject.set("contextStack", (Object)null);
        } else {
            noSqlObject.set("contextStack", noSqlObject2.asList().toArray());
        }
    }

    private void setFields(MapMessage<?, ?> mapMessage, NoSqlObject<W> noSqlObject) {
        mapMessage.forEach((string, object) -> noSqlObject.set((String)string, object));
    }

    @Override
    protected boolean shutdownInternal() {
        return Closer.closeSilently(this.connection);
    }

    @Override
    protected void startupInternal() {
    }

    @Override
    protected void writeInternal(LogEvent logEvent, Serializable serializable) {
        if (!this.isRunning() || this.connection == null || this.connection.isClosed()) {
            throw new AppenderLoggingException("Cannot write logging event; NoSQL manager not connected to the database.");
        }
        NoSqlObject<W> noSqlObject = this.connection.createObject();
        if (serializable instanceof MapMessage) {
            this.setFields((MapMessage)serializable, noSqlObject);
        } else {
            this.setFields(logEvent, noSqlObject);
        }
        this.setAdditionalFields(noSqlObject);
        this.connection.insertObject(noSqlObject);
    }

    /* synthetic */ NoSqlDatabaseManager(String string, int n, NoSqlProvider noSqlProvider, KeyValuePair[] keyValuePairArray, Configuration configuration, NoSqlDatabaseManager$1 noSqlDatabaseManager$1) {
        this(string, n, noSqlProvider, keyValuePairArray, configuration);
    }
}

