/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.mom.kafka;

import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractManager;
import org.apache.logging.log4j.core.appender.mom.kafka.DefaultKafkaProducerFactory;
import org.apache.logging.log4j.core.appender.mom.kafka.KafkaManager$1;
import org.apache.logging.log4j.core.appender.mom.kafka.KafkaManager$FactoryData;
import org.apache.logging.log4j.core.appender.mom.kafka.KafkaManager$KafkaManagerFactory;
import org.apache.logging.log4j.core.appender.mom.kafka.KafkaProducerFactory;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.util.Integers;
import org.apache.logging.log4j.core.util.Log4jThread;

public class KafkaManager
extends AbstractManager {
    public static final String DEFAULT_TIMEOUT_MILLIS = "30000";
    static KafkaProducerFactory producerFactory = new DefaultKafkaProducerFactory();
    private final Properties config = new Properties();
    private Producer<byte[], byte[]> producer;
    private final int timeoutMillis;
    private final String topic;
    private final String key;
    private final boolean syncSend;
    private final boolean sendTimestamp;
    private static final KafkaManager$KafkaManagerFactory factory = new KafkaManager$KafkaManagerFactory(null);

    public KafkaManager(LoggerContext loggerContext, String string, String string2, boolean bl, Property[] propertyArray, String string3) {
        this(loggerContext, string, string2, bl, false, propertyArray, string3);
    }

    /*
     * WARNING - void declaration
     */
    private KafkaManager(LoggerContext loggerContext, String string, String string2, boolean bl, boolean bl2, Property[] propertyArray, String string3) {
        super(loggerContext, string);
        void var8_11;
        this.topic = Objects.requireNonNull(string2, "topic");
        this.syncSend = bl;
        this.sendTimestamp = bl2;
        this.config.put("key.serializer", ByteArraySerializer.class);
        this.config.put("value.serializer", ByteArraySerializer.class);
        this.config.put("batch.size", (Object)0);
        for (Property property : propertyArray) {
            this.config.setProperty(property.getName(), property.getValue());
        }
        this.key = string3;
        String string4 = this.config.getProperty("timeout.ms");
        if (string4 == null) {
            String string5 = this.config.getProperty("request.timeout.ms", DEFAULT_TIMEOUT_MILLIS);
        }
        this.timeoutMillis = Integers.parseInt((String)var8_11);
    }

    @Override
    public boolean releaseSub(long l, TimeUnit timeUnit) {
        if (l > 0L) {
            this.closeProducer(l, timeUnit);
        } else {
            this.closeProducer(this.timeoutMillis, TimeUnit.MILLISECONDS);
        }
        return true;
    }

    private void closeProducer(long l, TimeUnit timeUnit) {
        if (this.producer != null) {
            Log4jThread log4jThread = new Log4jThread(() -> {
                if (this.producer != null) {
                    this.producer.close();
                }
            }, "KafkaManager-CloseThread");
            log4jThread.setDaemon(true);
            log4jThread.start();
            try {
                log4jThread.join(timeUnit.toMillis(l));
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Deprecated
    public void send(byte[] byArray) {
        this.send(byArray, null);
    }

    public void send(byte[] byArray, Long l) {
        if (this.producer != null) {
            byte[] byArray2 = null;
            if (this.key != null && this.key.contains("${")) {
                byArray2 = this.getLoggerContext().getConfiguration().getStrSubstitutor().replace(this.key).getBytes(StandardCharsets.UTF_8);
            } else if (this.key != null) {
                byArray2 = this.key.getBytes(StandardCharsets.UTF_8);
            }
            Long l2 = this.sendTimestamp ? l : null;
            ProducerRecord producerRecord = new ProducerRecord(this.topic, null, l2, (Object)byArray2, (Object)byArray);
            if (this.syncSend) {
                Future future = this.producer.send(producerRecord);
                future.get(this.timeoutMillis, TimeUnit.MILLISECONDS);
            } else {
                this.producer.send(producerRecord, (recordMetadata, exception) -> {
                    if (exception != null) {
                        LOGGER.error("Unable to write to Kafka in appender [" + this.getName() + "]", (Throwable)exception);
                    }
                });
            }
        }
    }

    public void startup() {
        if (this.producer == null) {
            this.producer = producerFactory.newKafkaProducer(this.config);
        }
    }

    public String getTopic() {
        return this.topic;
    }

    @Deprecated
    public static KafkaManager getManager(LoggerContext loggerContext, String string, String string2, boolean bl, Property[] propertyArray, String string3) {
        return KafkaManager.getManager(loggerContext, string, string2, bl, false, propertyArray, string3);
    }

    static KafkaManager getManager(LoggerContext loggerContext, String string, String string2, boolean bl, boolean bl2, Property[] propertyArray, String string3) {
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append(" ").append(string2).append(" ").append(bl).append(" ").append(bl2);
        for (Property property : propertyArray) {
            stringBuilder.append(" ").append(property.getName()).append("=").append(property.getValue());
        }
        return KafkaManager.getManager(stringBuilder.toString(), factory, new KafkaManager$FactoryData(loggerContext, string2, bl, bl2, propertyArray, string3));
    }

    /* synthetic */ KafkaManager(LoggerContext loggerContext, String string, String string2, boolean bl, boolean bl2, Property[] propertyArray, String string3, KafkaManager$1 kafkaManager$1) {
        this(loggerContext, string, string2, bl, bl2, propertyArray, string3);
    }
}

