/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.mom.kafka;

import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.AbstractLifeCycle;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.mom.kafka.KafkaAppender$1;
import org.apache.logging.log4j.core.appender.mom.kafka.KafkaAppender$Builder;
import org.apache.logging.log4j.core.appender.mom.kafka.KafkaManager;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.layout.SerializedLayout;

@Plugin(name="Kafka", category="Core", elementType="appender", printObject=true)
public final class KafkaAppender
extends AbstractAppender {
    private static final String[] KAFKA_CLIENT_PACKAGES = new String[]{"org.apache.kafka.common", "org.apache.kafka.clients"};
    private final Integer retryCount;
    private final KafkaManager manager;

    @Deprecated
    public static KafkaAppender createAppender(Layout<? extends Serializable> layout, Filter filter, String string, boolean bl, String string2, Property[] propertyArray, Configuration configuration, String string3) {
        if (layout == null) {
            AbstractLifeCycle.LOGGER.error("No layout provided for KafkaAppender");
            return null;
        }
        KafkaManager kafkaManager = KafkaManager.getManager(configuration.getLoggerContext(), string, string2, true, propertyArray, string3);
        return new KafkaAppender(string, layout, filter, bl, kafkaManager, null, 0);
    }

    private static boolean isRecursive(LogEvent logEvent) {
        return Stream.of(KAFKA_CLIENT_PACKAGES).anyMatch(string -> logEvent.getLoggerName().startsWith((String)string));
    }

    @PluginBuilderFactory
    public static <B extends KafkaAppender$Builder<B>> B newBuilder() {
        return (B)((KafkaAppender$Builder)new KafkaAppender$Builder().asBuilder());
    }

    private KafkaAppender(String string, Layout<? extends Serializable> layout, Filter filter, boolean bl, KafkaManager kafkaManager, Property[] propertyArray, int n) {
        super(string, filter, layout, bl, propertyArray);
        this.manager = Objects.requireNonNull(kafkaManager, "manager");
        this.retryCount = n;
    }

    @Override
    public void append(LogEvent logEvent) {
        if (logEvent.getLoggerName() != null && KafkaAppender.isRecursive(logEvent)) {
            LOGGER.warn("Recursive logging from [{}] for appender [{}].", (Object)logEvent.getLoggerName(), (Object)this.getName());
        } else {
            try {
                this.tryAppend(logEvent);
            }
            catch (Exception exception) {
                if (this.retryCount != null) {
                    for (int i = 0; i < this.retryCount; ++i) {
                        try {
                            this.tryAppend(logEvent);
                            break;
                        }
                        catch (Exception exception2) {
                            continue;
                        }
                    }
                }
                this.error("Unable to write to Kafka in appender [" + this.getName() + "]", logEvent, exception);
            }
        }
    }

    @Override
    public void start() {
        super.start();
        this.manager.startup();
    }

    @Override
    public boolean stop(long l, TimeUnit timeUnit) {
        this.setStopping();
        boolean bl = super.stop(l, timeUnit, false);
        this.setStopped();
        return bl &= this.manager.stop(l, timeUnit);
    }

    @Override
    public String toString() {
        return "KafkaAppender{name=" + this.getName() + ", state=" + (Object)((Object)this.getState()) + ", topic=" + this.manager.getTopic() + '}';
    }

    private void tryAppend(LogEvent logEvent) {
        byte[] byArray;
        Layout<? extends Serializable> layout = this.getLayout();
        if (layout instanceof SerializedLayout) {
            byte[] byArray2 = layout.getHeader();
            byte[] byArray3 = layout.toByteArray(logEvent);
            byArray = new byte[byArray2.length + byArray3.length];
            System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
            System.arraycopy(byArray3, 0, byArray, byArray2.length, byArray3.length);
        } else {
            byArray = layout.toByteArray(logEvent);
        }
        this.manager.send(byArray, logEvent.getTimeMillis());
    }

    static /* synthetic */ Logger access$000() {
        return LOGGER;
    }

    /* synthetic */ KafkaAppender(String string, Layout layout, Filter filter, boolean bl, KafkaManager kafkaManager, Property[] propertyArray, int n, KafkaAppender$1 kafkaAppender$1) {
        this(string, layout, filter, bl, kafkaManager, propertyArray, n);
    }
}

