/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.mom.kafka;

import java.io.Serializable;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.appender.AbstractAppender$Builder;
import org.apache.logging.log4j.core.appender.mom.kafka.KafkaAppender;
import org.apache.logging.log4j.core.appender.mom.kafka.KafkaManager;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.util.Builder;
import org.apache.logging.log4j.core.util.Integers;

public class KafkaAppender$Builder<B extends KafkaAppender$Builder<B>>
extends AbstractAppender$Builder<B>
implements Builder<KafkaAppender> {
    @PluginAttribute(value="retryCount")
    private int retryCount;
    @PluginAttribute(value="topic")
    private String topic;
    @PluginAttribute(value="key")
    private String key;
    @PluginAttribute(value="syncSend", defaultBoolean=true)
    private boolean syncSend;
    @PluginAttribute(value="sendEventTimestamp", defaultBoolean=false)
    private boolean sendEventTimestamp;

    @Override
    public KafkaAppender build() {
        Layout<Serializable> layout = this.getLayout();
        if (layout == null) {
            KafkaAppender.access$000().error("No layout provided for KafkaAppender");
            return null;
        }
        KafkaManager kafkaManager = KafkaManager.getManager(this.getConfiguration().getLoggerContext(), this.getName(), this.topic, this.syncSend, this.sendEventTimestamp, this.getPropertyArray(), this.key);
        return new KafkaAppender(this.getName(), layout, this.getFilter(), this.isIgnoreExceptions(), kafkaManager, this.getPropertyArray(), this.getRetryCount(), null);
    }

    public Integer getRetryCount() {
        Integer n = null;
        try {
            n = this.retryCount;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    public String getTopic() {
        return this.topic;
    }

    public boolean isSendEventTimestamp() {
        return this.sendEventTimestamp;
    }

    public boolean isSyncSend() {
        return this.syncSend;
    }

    public B setKey(String string) {
        this.key = string;
        return (B)((KafkaAppender$Builder)this.asBuilder());
    }

    @Deprecated
    public B setRetryCount(String string) {
        this.retryCount = Integers.parseInt(string, 0);
        return (B)((KafkaAppender$Builder)this.asBuilder());
    }

    public B setRetryCount(int n) {
        this.retryCount = n;
        return (B)((KafkaAppender$Builder)this.asBuilder());
    }

    public B setSendEventTimestamp(boolean bl) {
        this.sendEventTimestamp = bl;
        return (B)((KafkaAppender$Builder)this.asBuilder());
    }

    public B setSyncSend(boolean bl) {
        this.syncSend = bl;
        return (B)((KafkaAppender$Builder)this.asBuilder());
    }

    public B setTopic(String string) {
        this.topic = string;
        return (B)((KafkaAppender$Builder)this.asBuilder());
    }
}

